/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.ListItemActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.logger.CTELogger;

public class ListActivityRemove
extends ListItemActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ListActivityRemove.class);
    @Input
    public String removeFromList;
    @Input
    public Object itemToRemove;
    @Output
    public Boolean removed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        Object object = activityContext.getWorkflowExecution().getLock();
        synchronized (object) {
            if (this.removeFromList == null || this.removeFromList.length() == 0) {
                logger.warn(Long.valueOf(activityContext.getJobId()), "list input is empty");
                this.removed = false;
                return AttemptStatus.SUCCESS;
            }
            if (this.itemToRemove == null || this.itemToRemove.toString().length() == 0) {
                logger.warn(Long.valueOf(activityContext.getJobId()), "item input is empty");
                this.removed = false;
                return AttemptStatus.SUCCESS;
            }
            try {
                this.decodeList(activityContext, this.removeFromList);
                this.decodeItem(activityContext, this.itemToRemove, false);
            }
            catch (EvFailureException evFailureException) {
                activityContext.setFailureReason(evFailureException.getMessageContainer());
                this.removed = false;
                return AttemptStatus.FAILED;
            }
            if (this.itemObject == null) {
                logger.info(Long.valueOf(activityContext.getJobId()), "item input expression [%s] returned a null object", new Object[]{this.removeFromList});
                this.removed = false;
                return AttemptStatus.SUCCESS;
            }
            logger.debug(Long.valueOf(activityContext.getJobId()), "removing item [%s], class [%s] from list [%s]", new Object[]{this.itemObject, this.itemObject.getClass(), this.removeFromList});
            for (WorkflowElement workflowElement : this.listElements) {
                if (!workflowElement.getText().equalsIgnoreCase(String.valueOf(this.itemObject))) continue;
                this.removed = true;
                this.parent.removeContent(workflowElement);
            }
        }
        return AttemptStatus.SUCCESS;
    }
}

