/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.ListItemActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;

public class ListActivityExists
extends ListItemActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ListActivityExists.class);
    @Input
    public String listToCheck;
    @Input
    public Object itemToCheck;
    @Output
    public Boolean exists;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        Object object = activityContext.getWorkflowExecution().getLock();
        synchronized (object) {
            if (this.listToCheck == null || this.listToCheck.length() == 0) {
                logger.warn(Long.valueOf(activityContext.getJobId()), "list input is empty");
                this.exists = false;
                return AttemptStatus.SUCCESS;
            }
            if (this.itemToCheck == null || this.itemToCheck.toString().length() == 0) {
                logger.warn(Long.valueOf(activityContext.getJobId()), "item input is empty");
                this.exists = false;
                return AttemptStatus.SUCCESS;
            }
            try {
                this.decodeList(activityContext, this.listToCheck);
                this.decodeItem(activityContext, this.itemToCheck, false);
            }
            catch (EvFailureException evFailureException) {
                activityContext.setFailureReason(evFailureException.getMessageContainer());
                this.exists = false;
                return AttemptStatus.FAILED;
            }
            if (this.itemObject == null) {
                logger.info(Long.valueOf(activityContext.getJobId()), "item input expression [%s] returned a null object", new Object[]{this.listToCheck});
                this.exists = false;
                return AttemptStatus.SUCCESS;
            }
            logger.info(Long.valueOf(activityContext.getJobId()), "checking to see if item [%s], type [%s], is in list %s", new Object[]{this.itemObject, this.itemObject.getClass().getName(), this.listObject.toString()});
            this.exists = this.listObject.contains(this.itemObject);
        }
        return AttemptStatus.SUCCESS;
    }
}

