/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;
import workflow.types.data.DataRow;
import workflow.types.data.DataSet;
import workflow.types.data.MetaData;

public class JsonToResultSet
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(JsonToResultSet.class);
    @Input
    public String json;
    @Output
    public DataSet resultSet;
    private MetaData meta = null;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        this.resultSet = new DataSet();
        if (this.json == null || this.json.length() == 0) {
            return AttemptStatus.SUCCESS;
        }
        if (this.json.startsWith("{")) {
            JSONObject jSONObject = new JSONObject(this.json);
            this.initMeta(jSONObject);
            this.addRow(this.resultSet, jSONObject);
        } else if (this.json.startsWith("[")) {
            JSONArray jSONArray = new JSONArray(this.json);
            this.initMeta(jSONArray);
            for (int i = 0; i < jSONArray.length(); ++i) {
                this.addRow(this.resultSet, jSONArray.getJSONObject(i));
            }
        } else {
            logger.error(Long.valueOf(activityContext.getJobId()), "unable to determine json type from input [" + this.json + "]");
            EvMessageContainer evMessageContainer = new EvMessageContainer("unable to determine json type");
            activityContext.setFailureReason(evMessageContainer);
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }

    private void initMeta(JSONObject jSONObject) {
        this.meta = new MetaData(jSONObject.keySet().toArray(new String[0]));
    }

    private void initMeta(JSONArray jSONArray) {
        JSONObject jSONObject = null;
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            if (jSONObject != null && jSONObject2.keySet().size() <= jSONObject.keySet().size()) continue;
            jSONObject = jSONObject2;
        }
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        this.meta = new MetaData(jSONObject.keySet().toArray(new String[0]));
    }

    private void addRow(DataSet dataSet, JSONObject jSONObject) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.meta.getColumnCount(); ++i) {
            arrayList.add(jSONObject.optString(this.meta.getColumnName(i)));
        }
        dataSet.add(new DataRow(this.meta, arrayList));
    }
}

