/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.db.CTEDBException;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvFailureReason;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.WorkflowContext;
import commvault.cte.workflow.WorkflowTransition;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.db.DataAccessLayer;
import commvault.cte.workflow.db.engine.WF_ProcessTransitions_t;
import commvault.cte.workflow.logger.CTELogger;
import java.util.ArrayList;
import java.util.List;

public class JoinActivity
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(JoinActivity.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        DataAccessLayer dataAccessLayer = activityContext.getDataAccess();
        synchronized (dataAccessLayer) {
            List list;
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = activityContext.getUniqueName();
            if (activityContext.getSuperProcessId() != null) {
                string = string + "_" + activityContext.getSuperProcessId();
            }
            try {
                if (activityContext.getWorkflowExecution().isJoinCompleted(string)) {
                    logger.debug("join was already completed");
                    activityContext.setStatus(ProcessStatus.SKIPPED);
                    activityContext.setTransitionCancelled(true);
                    return AttemptStatus.SUCCESS;
                }
            }
            catch (EvFailureException evFailureException) {
                activityContext.setFailureReason(evFailureException.getMessageContainer());
                return AttemptStatus.FAILED;
            }
            logger.info(Long.valueOf(activityContext.getJobId()), "completing inbound activity [%s]", new Object[]{activityContext.getSourceActivity()});
            try {
                list = activityContext.getDataAccess().getCompletedTransitions(activityContext.getStepId(), activityContext.getParent().getContext().getId());
            }
            catch (CTEDBException cTEDBException) {
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to get completed transitions", (Throwable)cTEDBException);
                activityContext.setFailureReason(new EvMessageContainer(cTEDBException.getMessage()));
                return AttemptStatus.FAILED;
            }
            for (WorkflowTransition workflowTransition : activityContext.getInboundTransitions()) {
                boolean bl = false;
                for (WF_ProcessTransitions_t wF_ProcessTransitions_t : list) {
                    if (!workflowTransition.getSourceActivity().equals(wF_ProcessTransitions_t.SourceActivity.get())) continue;
                    logger.debug(Long.valueOf(activityContext.getJobId()), "inbound transition [%s] has completed", new Object[]{workflowTransition.getSourceActivity()});
                    bl = true;
                }
                if (bl) continue;
                logger.info(Long.valueOf(activityContext.getJobId()), "join activity is still waiting on inbound activity(s) [%s]", new Object[]{workflowTransition.getSourceActivity()});
                arrayList.add(workflowTransition.getSourceActivity());
            }
            if (arrayList.size() > 0) {
                String string2 = this.getJoinJPR(arrayList);
                EvMessageContainer evMessageContainer = EventMessage.getContainer((String)"JM_WORKFLOW_WAITING_JOIN", (Object[])new Object[]{string2});
                EvFailureReason evFailureReason = new EvFailureReason((WorkflowContext)activityContext, evMessageContainer);
                evFailureReason.setUserObject((Object)activityContext.getStepId());
                activityContext.setFailureReason(evFailureReason);
                activityContext.setStatus(ProcessStatus.SKIPPED);
                activityContext.setTransitionCancelled(true);
            } else {
                logger.info(Long.valueOf(activityContext.getJobId()), "all inbound transitions have completed");
                activityContext.getWorkflowExecution().setJoinCompleted(string);
            }
            return AttemptStatus.SUCCESS;
        }
    }

    private String getJoinJPR(List<String> list) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (String string : list) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = true;
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

