/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.db.CTEDBException;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.ExecutionState;
import commvault.cte.workflow.ForEachParallelProcess;
import commvault.cte.workflow.ForEachProcessManager;
import commvault.cte.workflow.ParellelProcess;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.activity.PhaseHandler;
import commvault.cte.workflow.db.engine.WF_SuperProcess_t;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.handler.DetermineInputs;
import commvault.cte.workflow.handler.DetermineTransitions;
import commvault.cte.workflow.handler.ExecuteActivity;
import commvault.cte.workflow.handler.ProcessHandler;
import commvault.cte.workflow.handler.ProcessInputs;
import commvault.cte.workflow.handler.ProcessOnEnter;
import commvault.cte.workflow.handler.ProcessOnExit;
import commvault.cte.workflow.handler.SetActivityInputs;
import commvault.cte.workflow.logger.CTELogger;
import java.util.List;

public abstract class IterableActivity
implements Activity,
PhaseHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(IterableActivity.class);

    protected AttemptStatus execute(ActivityContext activityContext, String string, List list, Integer n, Boolean bl) throws InterruptedException {
        List list2;
        if (activityContext.interrupted()) {
            logger.info(Long.valueOf(activityContext.getJobId()), "process context has been interrupted, exiting foreach process");
            return AttemptStatus.SUCCESS;
        }
        if (list == null || list.size() == 0) {
            logger.info(Long.valueOf(activityContext.getJobId()), "no items exist in for each expression");
            return AttemptStatus.SUCCESS;
        }
        if (n == null || n <= 0) {
            n = 1;
        }
        if (bl == null) {
            bl = false;
        }
        ForEachProcessManager forEachProcessManager = new ForEachProcessManager(activityContext, string, list, bl.booleanValue(), n.intValue());
        try {
            list2 = activityContext.getDataAccess().getSuperProcesses(activityContext.getProcessStepId().intValue(), ExecutionState.RUNNING);
        }
        catch (CTEDBException cTEDBException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to retrieve executing super processes for step id [" + activityContext.getProcessStepId() + "]", (Throwable)cTEDBException);
            activityContext.setFailureReason(new EvMessageContainer(cTEDBException.getMessage()));
            return AttemptStatus.FAILED;
        }
        if (list2.size() > 0) {
            for (WF_SuperProcess_t wF_SuperProcess_t : list2) {
                WorkflowElement workflowElement;
                ForEachParallelProcess forEachParallelProcess;
                try {
                    forEachParallelProcess = new ForEachParallelProcess(activityContext, wF_SuperProcess_t, bl.booleanValue());
                }
                catch (EvFailureException evFailureException) {
                    logger.error(Long.valueOf(activityContext.getJobId()), "failed to load super process entry for process step id [" + activityContext.getProcessStepId() + "]", (Throwable)evFailureException);
                    activityContext.setFailureReason(new EvMessageContainer(evFailureException.getMessage()));
                    return AttemptStatus.FAILED;
                }
                try {
                    workflowElement = WorkflowElement.parse((String)wF_SuperProcess_t.Execution.get());
                }
                catch (EvFailureException evFailureException) {
                    logger.error(Long.valueOf(activityContext.getJobId()), "failed to parse the foreach input xml for super process id [" + wF_SuperProcess_t.SuperProcessId.get() + "], xml [" + wF_SuperProcess_t.Execution.get() + "]");
                    activityContext.setFailureReason(evFailureException.getMessageContainer());
                    return AttemptStatus.FAILED;
                }
                WorkflowElement workflowElement2 = workflowElement != null ? (workflowElement.getName().equals(activityContext.getUniqueName()) ? workflowElement : workflowElement.getChild(activityContext.getUniqueName())) : new WorkflowElement(activityContext.getUniqueName());
                forEachParallelProcess.setProcessXml(workflowElement2);
                forEachProcessManager.addProcess((ParellelProcess)forEachParallelProcess);
                logger.info(Long.valueOf(activityContext.getJobId()), "continuing for-each process for item index [%s]", new Object[]{forEachParallelProcess.getLoopIndex()});
            }
        }
        forEachProcessManager.worker();
        if (activityContext.getStatus() == ProcessStatus.RUNNING) {
            if (forEachProcessManager.isRunning()) {
                logger.info(Long.valueOf(activityContext.getJobId()), "for each block exiting with running threads");
                activityContext.repeat(Integer.valueOf(0));
            } else {
                long l = 0L;
                if (activityContext.getSubJobId() != null) {
                    l = activityContext.getSubJobId();
                }
                if (l < (long)list.size()) {
                    logger.info(Long.valueOf(activityContext.getJobId()), "repeating foreach activity since there are [%s] more element(s) to process", new Object[]{(long)list.size() - l});
                    activityContext.repeat(Integer.valueOf(0));
                } else {
                    logger.info(Long.valueOf(activityContext.getJobId()), "all for each inputs have been processed");
                }
            }
        } else if (activityContext.getStatus() == ProcessStatus.SUSPEND_PENDING || activityContext.getStatus() == ProcessStatus.SUSPENDED) {
            activityContext.setStatus(ProcessStatus.SUSPENDED);
            activityContext.setCurrentPhase(-1);
        } else {
            logger.debug(Long.valueOf(activityContext.getJobId()), "process block exited with status [%s]", new Object[]{activityContext.getStatus().toString()});
            activityContext.repeat(Integer.valueOf(0));
        }
        return AttemptStatus.SUCCESS;
    }

    public ProcessHandler[] getExecutionPhases() {
        return new ProcessHandler[]{new DetermineInputs(), new ProcessInputs(), new SetActivityInputs(), new ProcessOnEnter(), new ExecuteActivity(), new ProcessOnExit(), new DetermineTransitions()};
    }
}

