/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.common.schema.util.SchemaUtils;
import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.common.xml.CTEProcessingModel;
import commvault.cte.common.xml.XMLDecoder;
import commvault.cte.common.xml.XMLEncoder;
import commvault.cte.db.CTEDBException;
import commvault.cte.db.CTEDBReservation;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.CVInitiatedFrom;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.FileUploadMonitor;
import commvault.cte.workflow.InputFormManager;
import commvault.cte.workflow.InteractiveAction;
import commvault.cte.workflow.SessionManager;
import commvault.cte.workflow.WorkflowContext;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.WorkflowTransition;
import commvault.cte.workflow.activities.InteractiveBaseActivity;
import commvault.cte.workflow.activities.WizardBlock;
import commvault.cte.workflow.activity.ActivityValidator;
import commvault.cte.workflow.activity.ExpressionHandler;
import commvault.cte.workflow.activity.PhaseHandler;
import commvault.cte.workflow.activity.XMLOutput;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.db.engine.WF_ProcessSteps_t;
import commvault.cte.workflow.db.engine.WF_StepTransitions_t;
import commvault.cte.workflow.dom.DOMUtil;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.eval.EvalManager;
import commvault.cte.workflow.eval.WorkflowEvaluator;
import commvault.cte.workflow.handler.DetermineInputs;
import commvault.cte.workflow.handler.DetermineTransitions;
import commvault.cte.workflow.handler.ExecuteActivity;
import commvault.cte.workflow.handler.ProcessHandler;
import commvault.cte.workflow.handler.ProcessInputs;
import commvault.cte.workflow.handler.ProcessOnEnter;
import commvault.cte.workflow.handler.ProcessOnExit;
import commvault.cte.workflow.handler.RepeatActivity;
import commvault.cte.workflow.handler.RetrieveOutputs;
import commvault.cte.workflow.handler.SetActivityInputs;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.message.RequestManager;
import commvault.cte.workflow.utils.CommServUtils;
import commvault.cte.workflow.utils.WorkflowUtils;
import commvault.msgs.App.XMLSchema;
import commvault.msgs.Workflow.ActivityDefinition;
import commvault.msgs.Workflow.InputAction;
import commvault.msgs.Workflow.InputForm;
import commvault.msgs.Workflow.InputPageRequest;
import commvault.msgs.Workflow.InputPageResponse;
import commvault.msgs.Workflow.InteractiveRequest;
import commvault.msgs.Workflow.InteractiveResponse;
import commvault.msgs.Workflow.PopupInputRequest;
import commvault.msgs.Workflow.PopupInputResponse;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import workflow.types.XML;

public class InteractiveInputActivity
extends InteractiveBaseActivity
implements XMLOutput,
ActivityValidator,
PhaseHandler,
ExpressionHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(InteractiveInputActivity.class);
    private static final String ACTION_BACK = "Back";
    private static final String ACTION_NEXT = "Next";
    private static final String ACTION_FINISH = "Finish";
    private static final String ACTION_CANCEL = "Cancel";
    @Input
    public String subject;
    @Input
    public XML inputs;
    @Input
    public List<InputAction> actions;
    @Input
    public String formProperties;
    private InputForm inputForm;
    private String output;
    private InputFormManager manager;
    private WF_ProcessSteps_t previousStep = null;
    private boolean backSelected = false;
    private boolean cancelledSelected = false;
    private Boolean finishButton = null;

    @Override
    public InteractiveResponse getResponse(ActivityContext activityContext) throws EvFailureException {
        PopupInputResponse popupInputResponse = new PopupInputResponse();
        if (activityContext.getParent() instanceof WizardBlock.WizardProcess) {
            String string;
            try {
                this.previousStep = this.getPreviousWizardStep(activityContext);
            }
            catch (Exception exception) {
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to lookup previous wizard step");
            }
            if (this.previousStep != null) {
                string = new InputAction();
                string.setName(ACTION_BACK);
                string.setValidateForm(false);
                this.inputForm.getActions().add(string);
            }
            string = ACTION_NEXT;
            if (this.finishButton != null) {
                if (this.finishButton.booleanValue()) {
                    string = ACTION_FINISH;
                }
            } else if (activityContext.getOutboundTransitions().length == 0) {
                string = ACTION_FINISH;
            }
            InputAction inputAction = new InputAction();
            inputAction.setName(string);
            inputAction.setValidateForm(true);
            this.inputForm.getActions().add(inputAction);
            if (!((WizardBlock.WizardProcess)activityContext.getParent()).isHideCancelButton()) {
                InputAction inputAction2 = new InputAction();
                inputAction2.setName(ACTION_CANCEL);
                inputAction2.setValidateForm(false);
                this.inputForm.getActions().add(inputAction2);
            }
        }
        if (this.actions != null) {
            this.inputForm.getActions().addAll(this.actions);
        }
        try {
            this.inputForm.setCanEdit(CommServUtils.canEditWorkflow((int)activityContext.getExecutorId(), (int)activityContext.getWorkflowId()));
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to check edit capability for user [" + activityContext.getExecutorId() + "] and workflow id [" + activityContext.getWorkflowId() + "]", (Throwable)cTEDBException);
        }
        popupInputResponse.setInputForm(this.inputForm);
        popupInputResponse.setDescription(activityContext.getDescription());
        popupInputResponse.setSubject(this.subject);
        return popupInputResponse;
    }

    public void setInput(String string, Object object) {
        for (XMLSchema xMLSchema : this.getForm().getEntries()) {
            if (!xMLSchema.getName().equalsIgnoreCase(string)) continue;
            xMLSchema.setDefaultValue(String.valueOf(object));
            xMLSchema.getDefaultValues().clear();
            xMLSchema.getDefaultValues().add(String.valueOf(object));
        }
    }

    public String getInput(String string) {
        for (XMLSchema xMLSchema : this.getForm().getEntries()) {
            if (!xMLSchema.getName().equalsIgnoreCase(string)) continue;
            return xMLSchema.getDefaultValue();
        }
        return null;
    }

    @Override
    public AttemptStatus processRequest(InteractiveRequest interactiveRequest, ActivityContext activityContext) throws EvFailureException {
        List list;
        PopupInputRequest popupInputRequest = (PopupInputRequest)interactiveRequest;
        WorkflowElement workflowElement = WorkflowElement.parse((String)popupInputRequest.getInputXml());
        if (workflowElement == null) {
            logger.debug(Long.valueOf(activityContext.getJobId()), "missing xml results recieved from popup interaction");
            workflowElement = new WorkflowElement("outputs");
        }
        workflowElement.removeContent("okClicked");
        workflowElement.removeContent("actionSelected");
        SchemaUtils.updateAttributes((XML)workflowElement, (XMLSchema)activityContext.getSchema().getInputs());
        List list2 = activityContext.getMarshaller().encode("okClicked", (Object)popupInputRequest.getOkClicked());
        if (list2 != null && list2.size() > 0) {
            workflowElement.addContent(list2);
        }
        if ((list = activityContext.getMarshaller().encode("actionSelected", (Object)popupInputRequest.getAction())) != null && list.size() > 0) {
            workflowElement.addContent(list);
        }
        DOMUtil.checkInputs((WorkflowElement)workflowElement, (EvalManager)new EvalManager((WorkflowContext)activityContext));
        try {
            FileUploadMonitor fileUploadMonitor = new FileUploadMonitor(workflowElement, (WorkflowContext)activityContext);
            fileUploadMonitor.upload();
        }
        catch (InterruptedException interruptedException) {
            throw new EvFailureException(new EvMessageContainer(interruptedException.getMessage()));
        }
        this.output = workflowElement.toString();
        this.backSelected = popupInputRequest.getAction().equalsIgnoreCase(ACTION_BACK);
        this.cancelledSelected = popupInputRequest.getAction().equalsIgnoreCase(ACTION_CANCEL);
        return AttemptStatus.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(InteractiveRequest interactiveRequest, WorkflowContext workflowContext) throws EvFailureException {
        Object object = workflowContext.getLock();
        synchronized (object) {
            if (interactiveRequest instanceof InputPageRequest) {
                InputPageResponse inputPageResponse = new InputPageResponse();
                inputPageResponse.setInput(this.manager.process((InputPageRequest)interactiveRequest));
                RequestManager.populateInteractiveResponse((InteractiveResponse)inputPageResponse, (WorkflowContext)workflowContext);
                SessionManager.getInstance().sendResponse(workflowContext, (CTEProcessingModel)inputPageResponse, (InteractiveAction)this);
            } else {
                super.actionPerformed(interactiveRequest, workflowContext);
            }
        }
    }

    public void setFinishButton(boolean bl) {
        this.finishButton = bl;
    }

    public String getOutputs() {
        return this.output;
    }

    public InputForm getForm() {
        return this.inputForm;
    }

    @Override
    public String getPendingReason(ActivityContext activityContext) {
        return String.format("waiting on user input [%s]", this.subject);
    }

    public void validate(ActivityDefinition activityDefinition) throws EvFailureException {
        if (activityDefinition.getInputs().size() == 0) {
            String string = String.format("interaction activity [%s] is missing required inputs", activityDefinition.getUniqueName());
            logger.error(string);
            throw new EvFailureException(new EvMessageContainer(string));
        }
        WorkflowElement workflowElement = WorkflowElement.parse((String)((String)activityDefinition.getInputs().get(0)));
        WorkflowElement workflowElement2 = workflowElement.getChild("subject");
        if (workflowElement2 == null || workflowElement2.getText().trim().length() == 0) {
            String string = String.format("interaction activity [%s] is missing required subject", activityDefinition.getUniqueName());
            logger.error(string);
            throw new EvFailureException(new EvMessageContainer(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WF_ProcessSteps_t getPreviousWizardStep(ActivityContext activityContext) throws Exception {
        int n = activityContext.getProcessStepId();
        while (true) {
            CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getEngineConnection().createReservation();
            try {
                PreparedStatement preparedStatement = cTEDBReservation.createStatement(String.format("Select t.SourceProcessStepId, s.StepId, s.ClassName From WF_ProcessTransitions t INNER JOIN WF_ProcessSteps p ON t.SourceProcessStepId = p.ProcessStepId INNER JOIN WF_Steps s ON p.StepId = s.StepId Where t.TargetProcessStepId = %s AND p.ContextId = %s", n, activityContext.getContext().getId()));
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    if (resultSet.getString("ClassName").equalsIgnoreCase(InteractiveInputActivity.class.getName())) {
                        WF_ProcessSteps_t wF_ProcessSteps_t = new WF_ProcessSteps_t();
                        if (!wF_ProcessSteps_t.fill("ProcessStepId = " + resultSet.getInt("SourceProcessStepId"))) {
                            logger.error("failed to find process step for process step id [" + resultSet.getInt("SourceProcessStepId") + "]");
                            WF_ProcessSteps_t wF_ProcessSteps_t2 = null;
                            return wF_ProcessSteps_t2;
                        }
                        WF_ProcessSteps_t wF_ProcessSteps_t3 = wF_ProcessSteps_t;
                        return wF_ProcessSteps_t3;
                    }
                    n = resultSet.getInt("SourceProcessStepId");
                    continue;
                }
                logger.debug("did not find source step for process step id [%s]", new Object[]{n});
                WF_ProcessSteps_t wF_ProcessSteps_t = null;
                return wF_ProcessSteps_t;
            }
            finally {
                cTEDBReservation.close();
                continue;
            }
            break;
        }
    }

    public ProcessHandler[] getExecutionPhases() {
        return new ProcessHandler[]{new DetermineInputs(), new ProcessInputs(), new SetActivityInputs(), new BuildForm(), new ProcessOnEnter(), new ExecuteActivity(), new ProcessOnExit(), new RetrieveOutputs(), new RepeatActivity(), new WizardTransition()};
    }

    public void processExpressions(ActivityContext activityContext, WorkflowElement workflowElement) throws Exception {
        logger.debug(Long.valueOf(activityContext.getJobId()), "begin processing expressions for inputs into activity [%s], xml [%s]", new Object[]{activityContext.getFriendlyName(), workflowElement.toString()});
        WorkflowEvaluator workflowEvaluator = new WorkflowEvaluator(activityContext.getEvaluator());
        for (WorkflowElement workflowElement2 : workflowElement.getChildren()) {
            if (workflowElement2.getName().equalsIgnoreCase("formProperties")) continue;
            workflowEvaluator.processChildElement(workflowElement2);
        }
    }

    private class WizardTransition
    extends DetermineTransitions {
        private WizardTransition() {
        }

        public void executeHandler(ActivityContext activityContext) throws InterruptedException {
            if (activityContext.getParent() instanceof WizardBlock.WizardProcess) {
                if (InteractiveInputActivity.this.cancelledSelected) {
                    ((WizardBlock.WizardProcess)activityContext.getParent()).setCancelled(true);
                } else if (InteractiveInputActivity.this.backSelected) {
                    try {
                        if (InteractiveInputActivity.this.previousStep == null) {
                            activityContext.setFailureReason("could not find previous wizard step");
                            activityContext.setStatus(ProcessStatus.PENDING);
                            return;
                        }
                        WF_StepTransitions_t wF_StepTransitions_t = new WF_StepTransitions_t();
                        wF_StepTransitions_t.SourceActivity.set(activityContext.getUniqueName());
                        wF_StepTransitions_t.TargetActivity.set(((InteractiveInputActivity)InteractiveInputActivity.this).previousStep.Name.get());
                        wF_StepTransitions_t.TargetStepId.set(((InteractiveInputActivity)InteractiveInputActivity.this).previousStep.StepId.get());
                        wF_StepTransitions_t.Status.set(Integer.valueOf(0));
                        WorkflowTransition workflowTransition = new WorkflowTransition(activityContext, wF_StepTransitions_t);
                        workflowTransition.setVirtualProcessStepId(((InteractiveInputActivity)InteractiveInputActivity.this).previousStep.ProcessStepId.get());
                        activityContext.addTransitionTo(workflowTransition);
                    }
                    catch (EvFailureException evFailureException) {
                        activityContext.setFailureReason(evFailureException.getMessageContainer());
                        activityContext.setStatus(ProcessStatus.PENDING);
                    }
                } else {
                    super.executeHandler(activityContext);
                }
            } else {
                super.executeHandler(activityContext);
            }
        }
    }

    public class BuildForm
    implements ProcessHandler {
        public void executeHandler(ActivityContext activityContext) throws InterruptedException {
            String string;
            String string2;
            InputForm inputForm = null;
            try {
                inputForm = WorkflowUtils.getUserInputForm((ActivityContext)activityContext, (XML)InteractiveInputActivity.this.inputs, (String)InteractiveInputActivity.this.formProperties);
            }
            catch (EvFailureException evFailureException) {
                logger.error(Long.valueOf(activityContext.getJobId()), "error building input form from inputs [" + InteractiveInputActivity.this.inputs + "]");
                activityContext.setFailureReason(evFailureException.getMessageContainer());
                activityContext.setStatus(ProcessStatus.PENDING);
                return;
            }
            try {
                string2 = XMLEncoder.encode((Object)inputForm);
            }
            catch (Exception exception) {
                logger.error("failed to encode message Workflow::InputForm", (Throwable)exception);
                activityContext.setFailureReason(exception.getMessage());
                activityContext.setStatus(ProcessStatus.PENDING);
                return;
            }
            WorkflowEvaluator workflowEvaluator = new WorkflowEvaluator(activityContext.getEvaluator());
            try {
                string = workflowEvaluator.parseString(string2, true);
            }
            catch (EvFailureException evFailureException) {
                logger.error("failed to process expressions in InputForm");
                activityContext.setFailureReason(evFailureException.getMessageContainer());
                activityContext.setStatus(ProcessStatus.PENDING);
                return;
            }
            logger.debug("Interaction Form: %s", new Object[]{string});
            try {
                inputForm = (InputForm)XMLDecoder.decode((String)string);
            }
            catch (Exception exception) {
                logger.error("failed to decode message Workflow::InputForm, xml [" + string + "]", (Throwable)exception);
                activityContext.setFailureReason(exception.getMessage());
                activityContext.setStatus(ProcessStatus.PENDING);
                return;
            }
            if (activityContext.getParent() instanceof WizardBlock.WizardProcess) {
                WorkflowElement workflowElement = activityContext.getWorkflowExecution().getOutput(activityContext.getUniqueName());
                if (workflowElement != null) {
                    InputForm inputForm2 = null;
                    WorkflowElement workflowElement2 = workflowElement.clone();
                    workflowElement2.setName("inputs");
                    try {
                        inputForm2 = WorkflowUtils.getUserInputForm((ActivityContext)activityContext, (XML)workflowElement2, (String)InteractiveInputActivity.this.formProperties);
                    }
                    catch (EvFailureException evFailureException) {
                        logger.error(Long.valueOf(activityContext.getJobId()), "error building wizard form from inputs [" + workflowElement2 + "]");
                        activityContext.setFailureReason(evFailureException.getMessageContainer());
                        activityContext.setStatus(ProcessStatus.PENDING);
                        return;
                    }
                    block10: for (XMLSchema xMLSchema : inputForm2.getEntries()) {
                        if (!xMLSchema.getReadOnly()) continue;
                        for (XMLSchema xMLSchema2 : inputForm.getEntries()) {
                            if (!xMLSchema.getInputName().equals(xMLSchema2.getInputName())) continue;
                            xMLSchema.setDefaultValue(xMLSchema2.getDefaultValue());
                            continue block10;
                        }
                    }
                    InteractiveInputActivity.this.inputForm = inputForm2;
                } else {
                    InteractiveInputActivity.this.inputForm = inputForm;
                }
            } else {
                InteractiveInputActivity.this.inputForm = inputForm;
            }
            InteractiveInputActivity.this.manager = new InputFormManager(InteractiveInputActivity.this.inputForm, activityContext.getInitFrom() == CVInitiatedFrom.THIRDPARTY);
        }
    }
}

