/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.common.xml.CTEProcessingModel;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.InteractiveAction;
import commvault.cte.workflow.SessionManager;
import commvault.cte.workflow.WorkflowContext;
import commvault.cte.workflow.activity.InteractiveActivity;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.message.RequestManager;
import commvault.msgs.Workflow.InteractiveRequest;
import commvault.msgs.Workflow.InteractiveResponse;

public abstract class InteractiveBaseActivity
implements InteractiveActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(InteractiveBaseActivity.class);
    private static final long SLEEP_TIME = 10000L;
    private boolean processed = false;
    private boolean sessionClosed = false;
    private AttemptStatus returnStatus = AttemptStatus.SUCCESS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        InteractiveResponse interactiveResponse;
        try {
            interactiveResponse = this.getResponse(activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(new EvMessageContainer(evFailureException.getMessage()));
            return AttemptStatus.FAILED;
        }
        RequestManager.populateInteractiveResponse((InteractiveResponse)interactiveResponse, (WorkflowContext)activityContext);
        try {
            SessionManager.getInstance().sendResponse((WorkflowContext)activityContext, (CTEProcessingModel)interactiveResponse, (InteractiveAction)this);
        }
        catch (EvFailureException evFailureException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to respond to workflow session");
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        logger.info(Long.valueOf(activityContext.getJobId()), "waiting on interactive request from user [%s]", new Object[]{activityContext.getExecutor()});
        activityContext.setFailureReason(this.getPendingReason(activityContext));
        activityContext.getJobManager().updatePendingReason();
        activityContext.setStatus(ProcessStatus.WAITING);
        while (true) {
            Object object = activityContext.getLock();
            synchronized (object) {
                if (this.processed) {
                    return this.returnStatus;
                }
                if (this.sessionClosed) {
                    logger.warn(Long.valueOf(activityContext.getJobId()), "exiting activity since session was closed");
                    return AttemptStatus.FAILED;
                }
                if (activityContext.getStatus() != ProcessStatus.WAITING) {
                    logger.info(Long.valueOf(activityContext.getJobId()), "exiting activity since it has a status of [%s]", new Object[]{activityContext.getStatus()});
                    return AttemptStatus.FAILED;
                }
                if (!activityContext.isRunning()) {
                    logger.info(Long.valueOf(activityContext.getJobId()), "exiting activity since the workflow is shutting down");
                    return AttemptStatus.FAILED;
                }
                activityContext.getLock().wait(10000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(InteractiveRequest interactiveRequest, WorkflowContext workflowContext) throws EvFailureException {
        Object object = workflowContext.getLock();
        synchronized (object) {
            this.returnStatus = this.processRequest(interactiveRequest, (ActivityContext)workflowContext);
            this.processed = true;
            workflowContext.getLock().notifyAll();
        }
    }

    public void onInteractiveSessionClosed() {
        this.sessionClosed = true;
    }

    public abstract String getPendingReason(ActivityContext var1);

    public abstract InteractiveResponse getResponse(ActivityContext var1) throws EvFailureException;

    public abstract AttemptStatus processRequest(InteractiveRequest var1, ActivityContext var2) throws EvFailureException;
}

