/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.common.xml.EncoderUtil;
import commvault.cte.db.CTEDBException;
import commvault.cte.db.CTEDBReservation;
import commvault.cte.util.DateUtilities;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.InteractiveAction;
import commvault.cte.workflow.Mailbox;
import commvault.cte.workflow.SessionManager;
import commvault.cte.workflow.UserInteractionTask;
import commvault.cte.workflow.UserModel;
import commvault.cte.workflow.WorkflowContext;
import commvault.cte.workflow.WorkflowMail;
import commvault.cte.workflow.WorkflowMessage;
import commvault.cte.workflow.WorkflowMessageListener;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.activity.ActivityValidator;
import commvault.cte.workflow.activity.InteractiveActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Internal;
import commvault.cte.workflow.db.cs.WFSetInteraction_p;
import commvault.cte.workflow.db.cs.WFSetInteraction_t;
import commvault.cte.workflow.db.cs.WF_InteractionUsers_t;
import commvault.cte.workflow.db.cs.WF_Interaction_t;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.CommServUtils;
import commvault.cte.workflow.utils.WorkflowUtils;
import commvault.msgs.App.GenericResp;
import commvault.msgs.CvEntities.ExternalGroupEntity;
import commvault.msgs.CvEntities.UserEntity;
import commvault.msgs.CvEntities.UserGroupEntity;
import commvault.msgs.Workflow.ActivityDefinition;
import commvault.msgs.Workflow.DeploymentFlags;
import commvault.msgs.Workflow.InteractionStatus;
import commvault.msgs.Workflow.InteractiveRequest;
import commvault.msgs.Workflow.SetWebFormInteractionRequest;
import commvault.msgs.Workflow.UserInteractionRequest;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.jdom2.Element;
import workflow.types.Binary;
import workflow.types.Email;

public abstract class InteractionActivity
implements Activity,
ActivityValidator,
InteractiveActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(InteractionActivity.class);
    private static final long SLEEP_TIME = 10000L;
    private static final String INTERACTION_EMAIL_KEY_OLD = "[InteractionId:%s]";
    private static final String INTERACTION_EMAIL_KEY = "[id:%s]";
    private static final String REGEX_INTERACTION_ID = "(?i)\\$interactionid\\$";
    @Input
    public List<Object> interactionUsers;
    @Input
    public String subject;
    @Input
    public String description;
    @Input
    public Boolean sendEmail;
    @Input
    public Boolean approvalEnabled;
    @Input
    public Email email;
    @Internal
    public Integer interactionId;
    @Internal
    public String fromAddress = "";
    private boolean interactiveResponse = false;
    private WorkflowMessageListener mailboxListener;
    private UserInteractionTask.InteractionTask interactionTask;
    private String emailKeyOld;
    private String emailKey;
    private int repeatInterval = 0;
    protected WorkflowMail mail = new WorkflowMail();
    private WF_Interaction_t completedRow = null;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        try {
            AttemptStatus attemptStatus = this.execute2(activityContext);
            return attemptStatus;
        }
        finally {
            if (this.interactionTask != null) {
                UserInteractionTask.getInstance().removeTask(this.interactionTask);
            }
            if (this.mailboxListener != null) {
                this.mailboxListener.setClosed(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttemptStatus execute2(final ActivityContext activityContext) throws InterruptedException {
        UserEntity userEntity;
        if (this.interactionUsers == null || this.interactionUsers.size() == 0) {
            logger.info(Long.valueOf(activityContext.getJobId()), "interaction activity does not contain any authenticated users, adding executor [%s] as authorized user", new Object[]{activityContext.getExecutor()});
            this.interactionUsers = new ArrayList<Object>();
            userEntity = new UserEntity();
            userEntity.setUserId(activityContext.getExecutorId());
            userEntity.setUserName(activityContext.getExecutor());
            this.interactionUsers.add(userEntity);
        }
        if (this.sendEmail == null) {
            this.sendEmail = true;
        }
        if (this.approvalEnabled == null) {
            this.approvalEnabled = false;
        }
        for (UserEntity userEntity2 : this.interactionUsers.toArray()) {
            UserModel userModel;
            if (userEntity2 instanceof UserEntity || userEntity2 instanceof UserGroupEntity || userEntity2 instanceof ExternalGroupEntity) continue;
            String string = String.valueOf(userEntity2);
            logger.debug(Long.valueOf(activityContext.getJobId()), "found unknown user type [%s], value [%s], looking up as UserEntity", new Object[]{userEntity2.getClass().getSimpleName(), string});
            try {
                userModel = UserModel.load((String)string);
            }
            catch (EvFailureException evFailureException) {
                logger.warn(Long.valueOf(activityContext.getJobId()), "could not load approver [" + string + "], skipping user");
                continue;
            }
            this.interactionUsers.remove(userEntity2);
            this.interactionUsers.add(userModel);
        }
        if (this.interactionUsers.size() == 0) {
            logger.error(Long.valueOf(activityContext.getJobId()), "interaction id [" + this.interactionId + "] does not contain any approvers");
            activityContext.setFailureReason("no approvers configured for interaction");
            return AttemptStatus.FAILED;
        }
        userEntity = new WF_Interaction_t();
        if (activityContext.getSubJobId() == null || activityContext.getSubJobId() == 0L) {
            if (this.interactionId != null) {
                logger.info(Long.valueOf(activityContext.getJobId()), "overriding interaction with id [%s]", new Object[]{this.interactionId});
                try {
                    if (!userEntity.fill(String.format("InteractionId=%s", this.interactionId))) {
                        logger.error(Long.valueOf(activityContext.getJobId()), "failed to override interaction with id [" + this.interactionId + "] since interaction was not found");
                        activityContext.setFailureReason(new EvMessageContainer("failed to override interaction"));
                        return AttemptStatus.FAILED;
                    }
                }
                catch (CTEDBException cTEDBException) {
                    logger.error(Long.valueOf(activityContext.getJobId()), "failed to retrieve overrided WF_Interaction record for interaction id [" + this.interactionId + "]", (Throwable)cTEDBException);
                    activityContext.setFailureReason(new EvMessageContainer(cTEDBException.getMessage()));
                    return AttemptStatus.FAILED;
                }
            }
            int n = 0;
            if (activityContext.isStartInteractiveSession()) {
                n |= DeploymentFlags.INTERACTIVE.getEnumValue();
            }
            userEntity.workflowId.set(Integer.valueOf(activityContext.getWorkflowId()));
            userEntity.jobId.set(Long.valueOf(activityContext.getJobId()));
            userEntity.commCellId.set(Integer.valueOf(activityContext.getCommCellId()));
            userEntity.processStepId.set(activityContext.getProcessStepId());
            userEntity.createdBy.set(Integer.valueOf(activityContext.getExecutorId()));
            userEntity.created.set(Integer.valueOf(CommServUtils.getCommCellTimeUnix()));
            userEntity.interactionGuid.set(String.valueOf(Math.abs(UUID.randomUUID().hashCode())));
            userEntity.clientId.set(Integer.valueOf(WorkflowProperties.getInstance().getClient().getClientId()));
            userEntity.activityName.set(activityContext.getDisplayName());
            if (this.description != null && this.description.length() > 0) {
                userEntity.description.set(this.description);
            } else {
                userEntity.description.set(activityContext.getDescription());
            }
            userEntity.status.set(Integer.valueOf(InteractionStatus.NEW.getEnumValue()));
            userEntity.subject.set(EncoderUtil.encodeString((String)this.subject));
            userEntity.flags.set(Integer.valueOf(n));
            try {
                this.setInteraction(activityContext, (WF_Interaction_t)userEntity);
            }
            catch (EvFailureException evFailureException) {
                activityContext.setFailureReason(new EvMessageContainer(evFailureException.getMessage()));
                return AttemptStatus.FAILED;
            }
            try {
                userEntity.save();
            }
            catch (CTEDBException cTEDBException) {
                UserEntity userEntity2;
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to create interaction entry on commserv", (Throwable)cTEDBException);
                userEntity2 = new EvMessageContainer(cTEDBException.getMessage());
                activityContext.setFailureReason((EvMessageContainer)userEntity2);
                return AttemptStatus.FAILED;
            }
            try {
                this.processApprovers(activityContext, (WF_Interaction_t)userEntity);
            }
            catch (EvFailureException evFailureException) {
                activityContext.setFailureReason(new EvMessageContainer(evFailureException.getMessage()));
                return AttemptStatus.FAILED;
            }
            activityContext.setSubJobId((long)userEntity.InteractionId.get().intValue());
            activityContext.setCustomFlag(DateUtilities.getNow());
            activityContext.save();
            this.emailKeyOld = String.format(INTERACTION_EMAIL_KEY_OLD, userEntity.interactionGuid.get());
            this.emailKey = String.format(INTERACTION_EMAIL_KEY, userEntity.interactionGuid.get());
            this.interactionId = userEntity.InteractionId.get();
            if (this.sendEmail.booleanValue()) {
                try {
                    this.sendEmail(activityContext, (WF_Interaction_t)userEntity);
                }
                catch (EvFailureException evFailureException) {
                    activityContext.setFailureReason(new EvMessageContainer(evFailureException.getMessage()));
                    this.sendEmail = false;
                }
            } else {
                logger.debug(Long.valueOf(activityContext.getJobId()), "email for interaction is skipped due to input setting");
            }
        } else {
            try {
                if (!userEntity.fill(String.format("InteractionId=%s", activityContext.getSubJobId()))) {
                    logger.error(Long.valueOf(activityContext.getJobId()), "could not find WF_Interaction record for interaction id [" + activityContext.getSubJobId() + "]");
                    activityContext.setFailureReason(new EvMessageContainer("missing interaction id [%s]", new Object[]{activityContext.getSubJobId()}));
                    return AttemptStatus.FAILED;
                }
            }
            catch (CTEDBException cTEDBException) {
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to retrieve WF_Interaction record for interaction id [" + activityContext.getSubJobId() + "]", (Throwable)cTEDBException);
                activityContext.setFailureReason(new EvMessageContainer(cTEDBException.getMessage()));
                return AttemptStatus.FAILED;
            }
            if (userEntity.status.get() > 0) {
                try {
                    this.completedRow = userEntity;
                    return this.completeAction(activityContext);
                }
                catch (EvFailureException evFailureException) {
                    activityContext.setFailureReason(evFailureException.getMessageContainer());
                    return AttemptStatus.FAILED;
                }
            }
            this.emailKeyOld = String.format(INTERACTION_EMAIL_KEY_OLD, userEntity.interactionGuid.get());
            this.emailKey = String.format(INTERACTION_EMAIL_KEY, userEntity.interactionGuid.get());
            this.interactionId = userEntity.InteractionId.get();
        }
        if (activityContext.isStartInteractiveSession()) {
            SessionManager.getInstance().createSession((WorkflowContext)activityContext, (InteractiveAction)this);
            userEntity.sessionId.set(activityContext.getSessionId());
            try {
                userEntity.save();
            }
            catch (CTEDBException cTEDBException) {
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to update interaction entry on commserv", (Throwable)cTEDBException);
                EvMessageContainer evMessageContainer = new EvMessageContainer(cTEDBException.getMessage());
                activityContext.setFailureReason(evMessageContainer);
                return AttemptStatus.FAILED;
            }
        }
        if (Mailbox.getInstance().isEnabled() && this.approvalEnabled.booleanValue()) {
            this.mailboxListener = new WorkflowMessageListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean onReceive(WorkflowMessage workflowMessage) {
                    if (workflowMessage != null && workflowMessage.getSubject() != null) {
                        if (workflowMessage.getSubject().indexOf(InteractionActivity.this.emailKey) > -1 || workflowMessage.getSubject().indexOf(InteractionActivity.this.emailKeyOld) > -1) {
                            Object object = activityContext.getLock();
                            synchronized (object) {
                                activityContext.getLock().notifyAll();
                                InteractionActivity.this.onEmailApprovalRequest(workflowMessage, activityContext);
                            }
                            return true;
                        }
                        return false;
                    }
                    return false;
                }

                public ProcessStatus getStatus() {
                    return activityContext.getStatus();
                }

                public long getJobId() {
                    return activityContext.getJobId();
                }

                public void setClosed(boolean bl) {
                }

                public boolean isClosed() {
                    return false;
                }
            };
            Mailbox.getInstance().addListener(this.mailboxListener);
        }
        logger.info(Long.valueOf(activityContext.getJobId()), "activity is waiting for user interaction id [%s] with subject [%s]", new Object[]{activityContext.getSubJobId(), this.subject});
        activityContext.setFailureReason(new EvMessageContainer("waiting on user input [%s]", new Object[]{this.subject}));
        activityContext.getJobManager().updatePendingReason();
        activityContext.setStatus(ProcessStatus.WAITING);
        activityContext.save();
        this.interactionTask = new UserInteractionTask.InteractionTask((WF_Interaction_t)userEntity){
            final /* synthetic */ WF_Interaction_t val$interactionRow;
            {
                this.val$interactionRow = wF_Interaction_t;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public GenericResp performTask(SetWebFormInteractionRequest setWebFormInteractionRequest) throws EvFailureException {
                Object object = activityContext.getLock();
                synchronized (object) {
                    GenericResp genericResp = InteractionActivity.this.processRequest(setWebFormInteractionRequest, setWebFormInteractionRequest.getProcessingInstructionInfo().getUser().getUserId(), activityContext);
                    activityContext.getLock().notifyAll();
                    return genericResp;
                }
            }

            public int getInteractionId() {
                return this.val$interactionRow.InteractionId.get();
            }
        };
        UserInteractionTask.getInstance().addTask(this.interactionTask);
        while (true) {
            Object object = activityContext.getLock();
            synchronized (object) {
                if (this.completedRow != null) {
                    try {
                        return this.completeAction(activityContext);
                    }
                    catch (EvFailureException evFailureException) {
                        activityContext.setFailureReason(evFailureException.getMessageContainer());
                        return AttemptStatus.FAILED;
                    }
                }
                logger.trace(Long.valueOf(activityContext.getJobId()), "activity is waiting for user interaction id [%s]", new Object[]{activityContext.getSubJobId()});
                if (activityContext.getStatus() != ProcessStatus.WAITING) {
                    logger.info(Long.valueOf(activityContext.getJobId()), "exiting activity since it has a status of [%s]", new Object[]{activityContext.getStatus()});
                    activityContext.repeat(Integer.valueOf(0));
                    return AttemptStatus.SUCCESS;
                }
                if (!activityContext.isRunning()) {
                    logger.info(Long.valueOf(activityContext.getJobId()), "exiting activity since the workflow is shutting down");
                    activityContext.repeat(Integer.valueOf(0));
                    return AttemptStatus.SUCCESS;
                }
                if (this.sendEmail.booleanValue() && this.repeatInterval > 0) {
                    int n = DateUtilities.getNow();
                    int n2 = this.repeatInterval * 60;
                    if (n >= activityContext.getCustomFlag() + n2) {
                        try {
                            this.sendEmail(activityContext, (WF_Interaction_t)userEntity);
                        }
                        catch (EvFailureException evFailureException) {
                            activityContext.setFailureReason(new EvMessageContainer(evFailureException.getMessage()));
                            this.sendEmail = false;
                        }
                    }
                }
                activityContext.getLock().wait(10000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getCurrentInteractionId(long l, int n, int n2) {
        ResultSet resultSet;
        try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getCommCellConnection().createReservation();){
            PreparedStatement preparedStatement = cTEDBReservation.createStatement("Select InteractionId From WF_Interaction Where jobId = ? AND commCellId = ? AND processStepId = ?");
            preparedStatement.setLong(1, l);
            preparedStatement.setInt(2, n);
            preparedStatement.setInt(3, n2);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                Integer n3 = resultSet.getInt("InteractionId");
                return n3;
            }
            Integer n4 = null;
            return n4;
        }
    }

    private AttemptStatus completeAction(ActivityContext activityContext) throws EvFailureException {
        UserModel userModel;
        try {
            userModel = UserModel.load((int)this.completedRow.completedBy.get());
        }
        catch (EvFailureException evFailureException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to retrieve user id [" + this.completedRow.completedBy.get() + "] who completed interaction id [" + activityContext.getSubJobId() + "]");
            throw evFailureException;
        }
        if (this.completedRow.status.get().intValue() == InteractionStatus.COMPLETED.getEnumValue()) {
            AttemptStatus attemptStatus = this.performInteraction(activityContext, this.completedRow, (UserEntity)userModel);
            if (activityContext.isStartInteractiveSession() && !this.interactiveResponse) {
                logger.warn(Long.valueOf(activityContext.getJobId()), "closing session [%s] as we didn't recieve an interactive response", new Object[]{activityContext.getSessionId()});
                SessionManager.getInstance().close(activityContext.getSessionId());
            }
            return attemptStatus;
        }
        logger.warn(Long.valueOf(activityContext.getJobId()), "interaction request [%s] was deleted by user [%s]", new Object[]{activityContext.getSubJobId(), userModel.getUserName()});
        throw new EvFailureException(new EvMessageContainer("interaction request [" + this.completedRow.InteractionId.get() + "] was deleted by user [" + userModel.getUserName() + "]"));
    }

    private WF_Interaction_t getInteractionRow(int n) throws EvFailureException {
        String string = String.format("InteractionId = %s", n);
        WF_Interaction_t wF_Interaction_t = new WF_Interaction_t();
        try {
            if (wF_Interaction_t.fill(string)) {
                return wF_Interaction_t;
            }
            logger.error("WF_Interaction row for ineteraction id [" + n + "] does not exist");
            throw new EvFailureException(new EvMessageContainer("could not find interaction id [" + n + "]"));
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to retrieve WF_Interaction record for interaction id [" + n + "]", (Throwable)cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
    }

    protected GenericResp processRequest(String string, String string2, int n, ActivityContext activityContext) throws EvFailureException {
        SetWebFormInteractionRequest setWebFormInteractionRequest = new SetWebFormInteractionRequest();
        setWebFormInteractionRequest.setInteractionId(activityContext.getSubJobId().intValue());
        setWebFormInteractionRequest.setInputXml(string);
        setWebFormInteractionRequest.setAction(string2);
        return this.processRequest(setWebFormInteractionRequest, n, activityContext);
    }

    protected GenericResp processRequest(SetWebFormInteractionRequest setWebFormInteractionRequest, int n, ActivityContext activityContext) throws EvFailureException {
        GenericResp genericResp;
        WFSetInteraction_t wFSetInteraction_t;
        Element element;
        try {
            element = WorkflowUtils.encodeMessage((Object)setWebFormInteractionRequest);
        }
        catch (Exception exception) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to encode Workflow::SetWebFormInteractionRequest", (Throwable)exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        WFSetInteraction_p wFSetInteraction_p = new WFSetInteraction_p();
        wFSetInteraction_p.i_xmlText.set(element);
        wFSetInteraction_p.i_userId.set(Integer.valueOf(n));
        try {
            wFSetInteraction_t = wFSetInteraction_p.executeQuery();
        }
        catch (CTEDBException cTEDBException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to execute sp WFSetInteraction", (Throwable)cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        try {
            genericResp = (GenericResp)WorkflowUtils.decodeMessage((Element)wFSetInteraction_t.o_xmlText.get(), (Object)new GenericResp());
        }
        catch (Exception exception) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to decode xml [" + wFSetInteraction_t.o_xmlText.get() + "]", (Throwable)exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        if (genericResp.getErrorCode() == 0) {
            WF_Interaction_t wF_Interaction_t = this.getInteractionRow(setWebFormInteractionRequest.getInteractionId());
            if (wF_Interaction_t.status.get() > 0) {
                this.completedRow = wF_Interaction_t;
            } else {
                logger.error(Long.valueOf(activityContext.getJobId()), "interaction id [" + wF_Interaction_t.InteractionId.get() + "] was not been completed, WFSetInteraction response [" + wFSetInteraction_t.o_xmlText.get() + "]");
                throw new EvFailureException(new EvMessageContainer("interaction was not completed"));
            }
        }
        return genericResp;
    }

    public void setInteractionId(Integer n) {
        this.interactionId = n;
    }

    public String getFromAddress(ActivityContext activityContext) {
        if (this.fromAddress != null && this.fromAddress.length() > 0) {
            return this.fromAddress;
        }
        if (this.email != null && this.email.getFrom() != null & this.email.getFrom().length() > 0) {
            return this.email.getFrom();
        }
        return activityContext.getJobSettings().getSmtpSender();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processApprovers(ActivityContext activityContext, WF_Interaction_t wF_Interaction_t) throws EvFailureException {
        String string = String.format("DELETE FROM WF_InteractionUsers Where InteractionId=%s", wF_Interaction_t.InteractionId.get());
        try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getCommCellConnection().createReservation();){
            Statement statement = cTEDBReservation.createStatement();
            statement.execute(string);
        }
        for (Object e : this.interactionUsers) {
            UserEntity userEntity;
            WF_InteractionUsers_t wF_InteractionUsers_t = new WF_InteractionUsers_t();
            wF_InteractionUsers_t.InteractionId.set(wF_Interaction_t.InteractionId.get());
            wF_InteractionUsers_t.userId.set(Integer.valueOf(0));
            wF_InteractionUsers_t.groupId.set(Integer.valueOf(0));
            wF_InteractionUsers_t.extGroupId.set(Integer.valueOf(0));
            wF_InteractionUsers_t.userGuid.set(UUID.randomUUID().toString());
            if (e instanceof UserEntity) {
                userEntity = (UserEntity)e;
                userEntity.setUserId(0);
                WorkflowUtils.updateMessageId((Object)userEntity);
                if (userEntity.getUserId() == 0) {
                    logger.error("invalid user [" + userEntity.getUserName() + "]");
                    continue;
                }
                wF_InteractionUsers_t.userId.set(Integer.valueOf(userEntity.getUserId()));
            }
            if (e instanceof UserGroupEntity) {
                userEntity = (UserGroupEntity)e;
                userEntity.setUserGroupId(0);
                WorkflowUtils.updateMessageId((Object)userEntity);
                if (userEntity.getUserGroupId() == 0) {
                    logger.error("invalid user group [" + userEntity.getUserGroupName() + "]");
                    continue;
                }
                wF_InteractionUsers_t.groupId.set(Integer.valueOf(((UserGroupEntity)e).getUserGroupId()));
            }
            if (e instanceof ExternalGroupEntity) {
                userEntity = (ExternalGroupEntity)e;
                userEntity.setGroupId(0);
                WorkflowUtils.updateMessageId((Object)userEntity);
                if (userEntity.getGroupId() == 0) {
                    logger.error("invalid external group [" + userEntity.getExternalGroupName() + "]");
                    continue;
                }
                wF_InteractionUsers_t.extGroupId.set(Integer.valueOf(((ExternalGroupEntity)e).getGroupId()));
            }
            try {
                wF_InteractionUsers_t.save();
            }
            catch (CTEDBException cTEDBException) {
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to add entry to WF_InteractionUsers table for interaction id [" + wF_Interaction_t.InteractionId.get() + "]", (Throwable)cTEDBException);
                activityContext.setFailureReason(new EvMessageContainer(cTEDBException.getMessage()));
            }
        }
    }

    protected void sendEmail(ActivityContext activityContext, WF_Interaction_t wF_Interaction_t) throws EvFailureException {
        Collection<Object> collection;
        if (this.email == null) {
            logger.debug(Long.valueOf(activityContext.getJobId()), "interaction does not contain and email to send to authenticated users");
        }
        if (this.email.getRepeatInterval() != null) {
            if (this.email.getRepeatInterval() >= 0) {
                this.repeatInterval = this.email.getRepeatInterval();
                activityContext.setCustomFlag(DateUtilities.getNow());
                activityContext.save();
            } else {
                logger.warn(Long.valueOf(activityContext.getJobId()), "repeat interval for email is configured with a negative value [%s]", new Object[]{this.email.getRepeatInterval()});
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = "{call WFGetInteractionUsers(?)}";
        try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getCommCellConnection().createReservation();){
            collection = cTEDBReservation.createCallableStatement(string);
            collection.setInt(1, activityContext.getSubJobId().intValue());
            ResultSet resultSet = collection.executeQuery();
            while (resultSet.next()) {
                if (resultSet.getString("email") != null || resultSet.getString("email").length() > 0) {
                    stringBuilder.append(resultSet.getString("email")).append(";");
                    continue;
                }
                logger.warn("no email address found for user [%s]", new Object[]{resultSet.getString("userName")});
            }
            resultSet.close();
        }
        if (this.email.getTo() != null) {
            stringBuilder.append(this.email.getTo());
        }
        if (stringBuilder.toString().length() == 0) {
            logger.warn("no recipients found to send interaction email to");
            return;
        }
        collection = null;
        if (this.email.getAttachments() != null) {
            collection = this.email.getAttachments() instanceof Binary || this.email.getAttachments() instanceof File ? Arrays.asList(this.email.getAttachments()) : (this.email.getAttachments() instanceof Collection ? (Collection)this.email.getAttachments() : WorkflowUtils.split((String)String.valueOf(this.email.getAttachments())));
        }
        if (this.approvalEnabled.booleanValue()) {
            this.subject = this.subject + " " + this.emailKey;
            this.email.setSubject(this.email.getSubject() + " " + this.emailKey);
            this.email.setReplyTo(Mailbox.getInstance().getReplyTo());
        }
        if (this.email.getSubject() != null) {
            this.email.setSubject(this.email.getSubject().replaceAll(REGEX_INTERACTION_ID, String.valueOf(this.interactionId)));
        }
        if (this.email.getBody() != null) {
            this.email.setBody(this.email.getBody().replaceAll(REGEX_INTERACTION_ID, String.valueOf(this.interactionId)));
        }
        try {
            this.mail.send((WorkflowContext)activityContext, WorkflowUtils.split((String)stringBuilder.toString()), this.email);
        }
        catch (EvFailureException evFailureException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to send email for interaction");
            throw evFailureException;
        }
    }

    public String embed(String string) throws Exception {
        return this.mail.embed(string);
    }

    public String embed(File file) throws Exception {
        return this.mail.embed(file);
    }

    public String embed(Binary binary) throws Exception {
        return this.mail.embed(binary);
    }

    public void validate(ActivityDefinition activityDefinition) throws EvFailureException {
        WorkflowElement workflowElement;
        if (activityDefinition.getInputs().size() == 0) {
            String string = String.format("interaction activity is missing required inputs", new Object[0]);
            logger.error(string);
            throw new EvFailureException(new EvMessageContainer(string));
        }
        try {
            workflowElement = WorkflowElement.parse((String)((String)activityDefinition.getInputs().get(0)));
        }
        catch (EvFailureException evFailureException) {
            throw new EvFailureException(evFailureException.getMessageContainer());
        }
        List list = workflowElement.getChildren("interactionUsers");
        if (list.size() == 0) {
            String string = String.format("interaction activity is missing authorized users input", new Object[0]);
            logger.error(string);
            throw new EvFailureException(new EvMessageContainer(string));
        }
        WorkflowElement workflowElement2 = workflowElement.getChild("subject");
        if (workflowElement2 == null || workflowElement2.getText().trim().length() == 0) {
            String string = String.format("interaction activity is missing required subject", new Object[0]);
            logger.error(string);
            throw new EvFailureException(new EvMessageContainer(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(InteractiveRequest interactiveRequest, WorkflowContext workflowContext) throws EvFailureException {
        Object object = workflowContext.getLock();
        synchronized (object) {
            this.interactiveResponse = true;
            GenericResp genericResp = this.processRequest(((UserInteractionRequest)interactiveRequest).getInputXml(), interactiveRequest.getAction(), interactiveRequest.getProcessingInstructionInfo().getUser().getUserId(), (ActivityContext)workflowContext);
            if (genericResp.getErrorCode() != 0) {
                logger.error(Long.valueOf(workflowContext.getJobId()), "error while processing interactive request [" + genericResp.getErrorMessage() + "]");
                throw new EvFailureException(new EvMessageContainer(genericResp.getErrorMessage()));
            }
            workflowContext.getLock().notifyAll();
        }
    }

    public void onInteractiveSessionClosed() {
    }

    protected abstract void setInteraction(ActivityContext var1, WF_Interaction_t var2) throws EvFailureException;

    protected abstract void onEmailApprovalRequest(WorkflowMessage var1, ActivityContext var2);

    protected abstract AttemptStatus performInteraction(ActivityContext var1, WF_Interaction_t var2, UserEntity var3) throws EvFailureException;
}

