/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.CommCellEntity;

public class ImpersonateCommCell
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ImpersonateCommCell.class);
    @Input
    public CommCellEntity commCell;
    @Output
    public String token;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.commCell == null) {
            logger.info(Long.valueOf(activityContext.getJobId()), "no commcell was inputted to switch impersonation to");
            return AttemptStatus.SUCCESS;
        }
        try {
            logger.info(Long.valueOf(activityContext.getJobId()), "switching impersonated user [%s] to commCell [%s]", new Object[]{activityContext.getContext().getUserName(), this.commCell.getCommCellName()});
            this.token = activityContext.impersonateCommCell(this.commCell.getCommCellName());
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

