/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.common.xml.XMLDecoder;
import commvault.cte.common.xml.XMLEncoder;
import commvault.cte.db.CTEDBReservation;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.App.CredentialRecordInfo;
import commvault.msgs.App.GetCredentialRecordInfoReq;
import commvault.msgs.App.GetCredentialRecordResp;
import commvault.msgs.App.ListPropertyLevels;
import commvault.msgs.CvEntities.CredentialEntity;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import workflow.types.EncryptedString;

public class GetCredentialsActivity
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(GetCredentialsActivity.class);
    @Input(documentation="the credential id")
    public CredentialEntity credential;
    @Output(documentation="the user name for the credential id")
    public String userName;
    @Output(documentation="the encrypted password for the credential id")
    public EncryptedString password;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        block14: {
            Object object;
            CredentialEntity credentialEntity2;
            List<CredentialEntity> list;
            if (this.credential == null || this.credential.getCredentialName().length() == 0) {
                logger.warn(Long.valueOf(activityContext.getJobId()), "no credential information provided to activity");
                return AttemptStatus.SUCCESS;
            }
            if (!activityContext.getContext().isLoggedIn()) {
                logger.error(Long.valueOf(activityContext.getJobId()), "user is not logged in");
                activityContext.setFailureReason(new EvMessageContainer("user is not logged in"));
                return AttemptStatus.FAILED;
            }
            try {
                this.credential.setCredentialId(this.getCredentialId(activityContext));
            }
            catch (EvFailureException evFailureException) {
                activityContext.setFailureReason(new EvMessageContainer(evFailureException.getMessage()));
                return AttemptStatus.FAILED;
            }
            try {
                list = this.getCredentials(activityContext);
            }
            catch (EvFailureException evFailureException) {
                activityContext.setFailureReason(evFailureException.getMessageContainer());
                return AttemptStatus.FAILED;
            }
            boolean bl = false;
            for (CredentialEntity credentialEntity2 : list) {
                if (!credentialEntity2.getCredentialName().equalsIgnoreCase(this.credential.getCredentialName())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                logger.error("user [" + activityContext.getContext().getUserName() + "] does not have capability to use credential [" + this.credential.getCredentialName() + "]");
                object = EventMessage.getContainer((String)"GUIMSG_SECURITY_USER_CAPABILITY", (Object[])new Object[]{activityContext.getContext().getUserName(), "Use Credential", this.credential.getCredentialName()});
                activityContext.setFailureReason((EvMessageContainer)object);
                return AttemptStatus.FAILED;
            }
            object = "SET NOCOUNT ON\nexec AppGetAssocToCMCredentials 0,?";
            credentialEntity2 = WorkflowProperties.getInstance().getCommCellConnection().createReservation();
            try {
                PreparedStatement preparedStatement = credentialEntity2.createStatement((String)object);
                preparedStatement.setInt(1, this.credential.getCredentialId());
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    this.userName = resultSet.getString("userName");
                    this.password = new EncryptedString(resultSet.getString("password"));
                    break block14;
                }
                logger.error("stored procedure [AppGetAssocToCMCredentials] did not return a result, input [" + this.credential.getCredentialId() + "]");
                EvMessageContainer evMessageContainer = new EvMessageContainer("failed to retrieve credentials");
                activityContext.setFailureReason(evMessageContainer);
                AttemptStatus attemptStatus = AttemptStatus.FAILED;
                return attemptStatus;
            }
            catch (Exception exception) {
                logger.error("failed to execute sp [AppGetAssocToCMCredentials] with input [" + this.credential.getCredentialId() + "]", (Throwable)exception);
                activityContext.setFailureReason(new EvMessageContainer(exception.getMessage()));
                AttemptStatus attemptStatus = AttemptStatus.FAILED;
                return attemptStatus;
            }
            finally {
                credentialEntity2.close();
            }
        }
        return AttemptStatus.SUCCESS;
    }

    private int getCredentialId(ActivityContext activityContext) throws EvFailureException {
        String string = "Select credentialId From APP_Credentials Where credentialName = ?";
        try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getCommCellConnection().createReservation();){
            PreparedStatement preparedStatement = cTEDBReservation.createStatement(string);
            preparedStatement.setString(1, this.credential.getCredentialName());
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                return n;
            }
            try {
                logger.error("credential [" + this.credential.getCredentialName() + "] does not exist");
                throw new EvFailureException(new EvMessageContainer("credential [" + this.credential.getCredentialName() + "] does not exist"));
            }
            catch (Exception exception) {
                logger.error("failed to retrieve credential id for [" + this.credential.getCredentialName() + "]", (Throwable)exception);
                throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private List<CredentialEntity> getCredentials(ActivityContext var1_1) throws EvFailureException {
        var2_2 = new GetCredentialRecordInfoReq();
        var2_2.setPropertyLevel(ListPropertyLevels.ListOnly);
        var2_2.getProcessingInstructionInfo().setUser(var1_1.getContext().getUser());
        var3_3 = null;
        var4_4 = "{call AppViewCMCredentials(?)}";
        var5_5 = WorkflowProperties.getInstance().getCommCellConnection().createReservation();
        try {
            var3_3 = XMLEncoder.encode((Object)var2_2).replaceAll("\\<\\?xml(.+?)\\?\\>", "").trim();
            var6_6 = var5_5.createCallableStatement(var4_4);
            var6_6.setString(1, var3_3);
            var7_8 = var6_6.executeQuery();
            if (!var7_8.next()) ** GOTO lbl29
            var8_9 = var7_8.getString(1);
            if (var8_9 == null) ** GOTO lbl27
            var9_10 = XMLDecoder.decode((String)var8_9);
            if (var9_10 instanceof GetCredentialRecordResp) {
                var10_11 = new ArrayList<CredentialEntity>();
                for (CredentialRecordInfo var12_13 : ((GetCredentialRecordResp)var9_10).getCredentialRecordInfo()) {
                    var10_11.add(var12_13.getCredentialRecord());
                }
                var11_12 = var10_11;
                return var11_12;
            }
            try {
                GetCredentialsActivity.logger.error("stored procedure [AppViewCMCredentials] returned message [" + var8_9 + "], input [" + var3_3 + "]");
                throw new EvFailureException(new EvMessageContainer("failed to retrieve credentials"));
lbl27:
                // 1 sources

                GetCredentialsActivity.logger.error("stored procedure [AppViewCMCredentials] returned a NULL result, input [" + var3_3 + "]");
                throw new EvFailureException(new EvMessageContainer("failed to retrieve credentials"));
lbl29:
                // 1 sources

                GetCredentialsActivity.logger.error("stored procedure [AppViewCMCredentials] did not return a result, input [" + var3_3 + "]");
                throw new EvFailureException(new EvMessageContainer("failed to retrieve credentials"));
            }
            catch (Exception var6_7) {
                GetCredentialsActivity.logger.error("failed to execute sp [AppViewCMCredentials] with inputXml [" + var3_3 + "]", (Throwable)var6_7);
                throw new EvFailureException(new EvMessageContainer(var6_7.getMessage()));
            }
        }
        finally {
            var5_5.close();
        }
    }
}

