/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.WorkflowTransition;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.activity.PhaseHandler;
import commvault.cte.workflow.eval.ExpressionUtils;
import commvault.cte.workflow.handler.ExecuteActivity;
import commvault.cte.workflow.handler.ProcessHandler;
import commvault.cte.workflow.handler.ProcessOnEnter;
import commvault.cte.workflow.handler.ProcessOnExit;
import commvault.cte.workflow.handler.RetrieveOutputs;
import commvault.cte.workflow.logger.CTELogger;

public class ForkActivity
implements Activity,
PhaseHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ForkActivity.class);

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        activityContext.setForkTransitions(true);
        if (activityContext.getOutboundTransitions() != null) {
            for (WorkflowTransition workflowTransition : activityContext.getOutboundTransitions()) {
                if (workflowTransition.getCondition() != null) {
                    try {
                        Object object = activityContext.getEvaluator().evaluate(workflowTransition.getCondition());
                        if (ExpressionUtils.parseBoolean((Object)object)) {
                            logger.debug(Long.valueOf(activityContext.getJobId()), "adding transition [%s] because condition [%s] is true", new Object[]{workflowTransition.getTargetActivity(), workflowTransition.getCondition()});
                            activityContext.addTransitionTo(workflowTransition);
                            continue;
                        }
                        logger.trace(Long.valueOf(activityContext.getJobId()), "condition [%s] returned false value [%s]", new Object[]{workflowTransition.getCondition(), object});
                    }
                    catch (EvFailureException evFailureException) {
                        logger.error(Long.valueOf(activityContext.getJobId()), "error evaluating transition condition [" + workflowTransition.getCondition() + "]");
                    }
                    continue;
                }
                logger.debug(Long.valueOf(activityContext.getJobId()), "adding transition [%s] because an empty condition is true", new Object[]{workflowTransition.getTargetActivity()});
                activityContext.addTransitionTo(workflowTransition);
            }
        }
        return AttemptStatus.SUCCESS;
    }

    public ProcessHandler[] getExecutionPhases() {
        return new ProcessHandler[]{new ProcessOnEnter(), new ExecuteActivity(), new ProcessOnExit(), new RetrieveOutputs()};
    }
}

