/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.activities.IterableActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import java.util.ArrayList;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

public class ForEachJSONActivity
extends IterableActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ForEachJSONActivity.class);
    @Input
    public String json;
    @Input
    public String path;
    @Input(defaultValue="1")
    public Integer numberOfParallelExecutions;
    @Input(defaultValue="false")
    public Boolean continueOnFailure;
    @Output
    public String value;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        JsonPath jsonPath;
        ArrayList<String> arrayList = new ArrayList<String>();
        DocumentContext documentContext = JsonPath.parse((String)this.json);
        Object object = documentContext.read(jsonPath = JsonPath.compile((String)this.path, (Predicate[])new Predicate[0]));
        if (object == null) {
            logger.info("no rows returned from json path [" + jsonPath + "]");
            return AttemptStatus.SUCCESS;
        }
        if (object instanceof Map) {
            arrayList.add(new JSONObject((Map)object).toJSONString());
        } else if (object instanceof JSONObject) {
            arrayList.add(((JSONObject)object).toJSONString());
        } else if (object instanceof JSONArray) {
            JSONArray jSONArray = (JSONArray)object;
            for (int i = 0; i < jSONArray.size(); ++i) {
                if (jSONArray.get(i) instanceof Map) {
                    arrayList.add(new JSONObject((Map)jSONArray.get(i)).toJSONString());
                    continue;
                }
                arrayList.add(String.valueOf(jSONArray.get(i)));
            }
        } else {
            arrayList.add(String.valueOf(object));
        }
        return super.execute(activityContext, "value", arrayList, this.numberOfParallelExecutions, this.continueOnFailure);
    }
}

