/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.common.xml.XMLDecoder;
import commvault.cte.db.CTEDBException;
import commvault.cte.util.DateUtilities;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.ExecutionState;
import commvault.cte.workflow.ProcessContext;
import commvault.cte.workflow.ProcessManager;
import commvault.cte.workflow.SuperProcess;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.activity.ExpressionHandler;
import commvault.cte.workflow.activity.XMLOutput;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.db.engine.WF_ProcessSteps_t;
import commvault.cte.workflow.db.engine.WF_Steps_t;
import commvault.cte.workflow.db.engine.WF_SuperProcess_t;
import commvault.cte.workflow.dom.OutputElement;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.eval.WorkflowEvaluator;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.Workflow.ScriptDefinition;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Element;

public class ExecuteSuperProcess
implements Activity,
XMLOutput,
ExpressionHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ExecuteSuperProcess.class);
    @Input
    public WorkflowElement inputs;
    @Input
    public WorkflowElement processBlock;
    @Input
    public WorkflowElement outputs;
    private String processBlockName;
    private WF_Steps_t superProcessStep;
    private WF_SuperProcess_t superProcessRow;
    private ExecutionProcess execution;
    private WorkflowElement activityOutputs;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        WorkflowEvaluator workflowEvaluator = new WorkflowEvaluator(activityContext.getEvaluator());
        if (this.processBlock == null || this.processBlock.getText().length() == 0) {
            String string = String.format("activity has no process block defined to execute", new Object[0]);
            logger.warn(Long.valueOf(activityContext.getJobId()), string);
            return AttemptStatus.SUCCESS;
        }
        try {
            this.processBlockName = workflowEvaluator.parseString(this.processBlock.getText());
        }
        catch (EvFailureException evFailureException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to evaluate process block input");
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        try {
            this.superProcessStep = activityContext.getDataAccess().getStep(this.processBlockName, activityContext.getDeploymentId());
        }
        catch (CTEDBException cTEDBException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to select from WF_Steps for UniqueName [" + this.processBlockName + "], DeploymentId [" + activityContext.getDeploymentId() + "]", (Throwable)cTEDBException);
            activityContext.setFailureReason(new EvMessageContainer(cTEDBException.getMessage()));
            return AttemptStatus.FAILED;
        }
        if (this.superProcessStep == null) {
            logger.warn(Long.valueOf(activityContext.getJobId()), "could not find process block activity from WF_Steps for UniqueName [%s], DeploymentId [%s]", new Object[]{this.processBlockName, activityContext.getDeploymentId()});
            return AttemptStatus.SUCCESS;
        }
        if (this.inputs == null) {
            this.inputs = new WorkflowElement("inputs");
        } else {
            try {
                workflowEvaluator.processElement(this.inputs);
            }
            catch (EvFailureException evFailureException) {
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to process expressions for inputs into activity");
                activityContext.setFailureReason(evFailureException.getMessageContainer());
                return AttemptStatus.FAILED;
            }
        }
        activityContext.setActivityInputs(this.inputs);
        try {
            this.executeScript(activityContext, this.superProcessStep.OnEnter.get());
        }
        catch (EvFailureException evFailureException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "error executing onStart script for process block [" + this.superProcessStep.Name.get() + "]");
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        try {
            this.executeSuperProcess(activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }

    private void executeScript(ActivityContext activityContext, String string) throws EvFailureException {
        ScriptDefinition scriptDefinition = null;
        if (string != null && string.length() > 0) {
            try {
                scriptDefinition = (ScriptDefinition)XMLDecoder.decode((String)string, (Object)new ScriptDefinition());
            }
            catch (Exception exception) {
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to decode Workflow::ScriptDefinition from xml [" + string + "]", (Throwable)exception);
                throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
            }
        }
        if (scriptDefinition != null) {
            activityContext.getEvaluator().evaluate(scriptDefinition);
        }
    }

    private void executeSuperProcess(ActivityContext activityContext) throws EvFailureException {
        List list;
        boolean bl = false;
        try {
            list = activityContext.getDataAccess().getSuperProcesses(activityContext.getProcessStepId().intValue());
        }
        catch (CTEDBException cTEDBException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to select from table [WF_SuperProcess]", (Throwable)cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        if (list.size() > 0) {
            if (list.size() > 1) {
                logger.warn(Long.valueOf(activityContext.getJobId()), "more then one super process row was found for ProcessStepId [%s]", new Object[]{activityContext.getProcessStepId()});
            } else {
                logger.debug(Long.valueOf(activityContext.getJobId()), "retrieved existing [WF_SuperProcess] record for ProcessStepId [%s]", new Object[]{activityContext.getProcessStepId()});
            }
            this.superProcessRow = (WF_SuperProcess_t)list.get(0);
        } else {
            logger.debug(Long.valueOf(activityContext.getJobId()), "creating new [WF_SuperProcess] record for ProcessStepId [%s]", new Object[]{activityContext.getProcessStepId()});
            this.superProcessRow = activityContext.getDataAccess().newSuperProcess();
            this.superProcessRow.ProcessStepId.set(activityContext.getProcessStepId());
            this.superProcessRow.State.set(Integer.valueOf(ExecutionState.STARTING.toInt()));
            this.superProcessRow.Started.set(Integer.valueOf(DateUtilities.getNow()));
            bl = true;
        }
        this.superProcessRow.jobId.set(Long.valueOf(activityContext.getJobId()));
        try {
            this.execution = new ExecutionProcess(activityContext, this.superProcessRow);
        }
        catch (EvFailureException evFailureException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to load super process entry for process step id [" + activityContext.getProcessStepId() + "]", (Throwable)evFailureException);
            throw new EvFailureException(new EvMessageContainer(evFailureException.getMessage()));
        }
        if (this.execution.getExecutionState() == ExecutionState.COMPLETED) {
            logger.info(Long.valueOf(activityContext.getJobId()), "process block for super process id [%s], has already completed", new Object[]{this.execution.getSuperProcessId()});
            return;
        }
        OutputElement outputElement = new OutputElement(this.superProcessStep.UniqueName.get());
        if (this.inputs != null) {
            logger.info(Long.valueOf(activityContext.getJobId()), "initializing process block with inputs [%s]", new Object[]{this.inputs});
            for (Object object : this.inputs.getChildren()) {
                outputElement.addContent(object.clone());
            }
        } else {
            logger.info(Long.valueOf(activityContext.getJobId()), "initializing process block with inputs []");
        }
        this.execution.setProcessXml((WorkflowElement)outputElement);
        try {
            this.superProcessRow.save();
        }
        catch (CTEDBException cTEDBException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "error saving super process", (Throwable)cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        SuperProcessManager superProcessManager = new SuperProcessManager((ProcessContext)this.execution);
        superProcessManager.worker();
        if (activityContext.getStatus() == ProcessStatus.RUNNING && superProcessManager.getSize() == 0) {
            Object object;
            this.execution.complete();
            this.activityOutputs = new WorkflowElement(activityContext.getName());
            try {
                object = activityContext.getDataAccess().getProcessSteps(this.execution.getSuperProcessId().intValue());
            }
            catch (CTEDBException cTEDBException) {
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to retrieve process steps for super process id [" + this.execution.getSuperProcessId() + "]");
                throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
            }
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                WF_ProcessSteps_t wF_ProcessSteps_t = (WF_ProcessSteps_t)iterator.next();
                WorkflowElement workflowElement = WorkflowElement.parse((Element)wF_ProcessSteps_t.Outputs.get());
                if (workflowElement == null) continue;
                this.activityOutputs.addContent(workflowElement);
            }
            try {
                this.executeScript(activityContext, this.superProcessStep.OnExit.get());
            }
            catch (EvFailureException evFailureException) {
                logger.error(Long.valueOf(activityContext.getJobId()), "error executing onComplete script for process block [" + this.superProcessStep.Name.get() + "]");
                throw evFailureException;
            }
        }
        if (activityContext.getStatus() == ProcessStatus.SUSPEND_PENDING || activityContext.getStatus() == ProcessStatus.SUSPENDED) {
            activityContext.setStatus(ProcessStatus.SUSPENDED);
            activityContext.setCurrentPhase(-1);
        } else {
            logger.debug(Long.valueOf(activityContext.getJobId()), "process block for super process id [%s], exiting with status [%s], step count [%s]", new Object[]{this.execution.getSuperProcessId(), activityContext.getStatus().toString(), superProcessManager.getSize()});
            activityContext.repeat(Integer.valueOf(0));
        }
    }

    public String getOutputs() {
        if (this.activityOutputs == null) {
            return null;
        }
        return this.activityOutputs.toString();
    }

    public void processExpressions(ActivityContext activityContext, WorkflowElement workflowElement) throws Exception {
    }

    private class SuperProcessManager
    extends ProcessManager {
        public SuperProcessManager(ProcessContext processContext) {
            super(processContext);
        }

        protected void worker() {
            super.worker();
        }
    }

    private class ExecutionProcess
    extends SuperProcess {
        public ExecutionProcess(ActivityContext activityContext, WF_SuperProcess_t wF_SuperProcess_t) throws EvFailureException {
            super(activityContext, wF_SuperProcess_t);
        }

        public String getProcessName() {
            return this.getDisplayName();
        }

        public WF_Steps_t getStartStep() throws EvFailureException {
            WF_Steps_t wF_Steps_t;
            try {
                wF_Steps_t = this.getDataAccess().getStartStep(this.getDeploymentId(), ((ExecuteSuperProcess)ExecuteSuperProcess.this).superProcessStep.StepId.get());
            }
            catch (CTEDBException cTEDBException) {
                logger.error(Long.valueOf(this.getJobId()), "error retrieving process start activity", (Throwable)cTEDBException);
                throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
            }
            if (wF_Steps_t == null) {
                logger.error(Long.valueOf(this.getJobId()), "could not find process start activity for super process [" + this.getName() + "], step id [" + ((ExecuteSuperProcess)ExecuteSuperProcess.this).superProcessStep.StepId.get() + "]");
                EvMessageContainer evMessageContainer = EventMessage.getContainer((String)"JM_WORKFLOW_FAILED_RETRIEVE_START", (Object[])new Object[0]);
                throw new EvFailureException(evMessageContainer);
            }
            return wF_Steps_t;
        }

        public String getMaskedStep() {
            return ExecuteSuperProcess.this.processBlockName;
        }
    }
}

