/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.WorkflowContext;
import commvault.cte.workflow.WorkflowMail;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.activity.PhaseHandler;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.handler.DetermineInputs;
import commvault.cte.workflow.handler.DetermineTransitions;
import commvault.cte.workflow.handler.ExecuteActivity;
import commvault.cte.workflow.handler.ProcessHandler;
import commvault.cte.workflow.handler.ProcessInputs;
import commvault.cte.workflow.handler.ProcessOnEnter;
import commvault.cte.workflow.handler.ProcessOnExit;
import commvault.cte.workflow.handler.RepeatActivity;
import commvault.cte.workflow.handler.RetrieveOutputs;
import commvault.cte.workflow.handler.SetActivityInputs;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.WorkflowUtils;
import java.io.File;
import java.util.List;
import workflow.types.Binary;
import workflow.types.Email;

public class EmailActivity
implements Activity,
PhaseHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(EmailActivity.class);
    private static final String CID_IMAGE_TAG = "<img src=\"cid:%s\">";
    private static Boolean ALLOW_EMPTY_TO_RECIPIENTS;
    @Input(autoLink=false)
    public Email email;
    @Output
    public Boolean emailSent = false;
    @Output
    public String errorMessage = "";
    private WorkflowMail mail = new WorkflowMail();

    private static boolean isAllowEmptyToRecipients() {
        if (ALLOW_EMPTY_TO_RECIPIENTS == null) {
            ALLOW_EMPTY_TO_RECIPIENTS = WorkflowRegistry.getInstance().isAllowEmptyToRecipients();
        }
        return ALLOW_EMPTY_TO_RECIPIENTS;
    }

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.email == null) {
            String string;
            logger.error(Long.valueOf(activityContext.getJobId()), "email configuration is incomplete");
            EvMessageContainer evMessageContainer = EventMessage.getContainer((String)"JM_WORKFLOW_FAILED_CONFIGURE_EMAIL", (Object[])new Object[0]);
            activityContext.setFailureReason(evMessageContainer);
            this.errorMessage = string = EventMessage.getInstance().formatMessage(evMessageContainer, 0);
            return AttemptStatus.FAILED;
        }
        List list = WorkflowUtils.split((String)this.email.getTo());
        if (list.size() == 0 && !EmailActivity.isAllowEmptyToRecipients()) {
            logger.info("did not find any recipients for email, adding workflow executor [%s]", new Object[]{activityContext.getExecutor()});
            list.add(activityContext.getExecutor());
        }
        try {
            this.mail.send((WorkflowContext)activityContext, list, this.email);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            this.errorMessage = evFailureException.getMessage();
            return AttemptStatus.FAILED;
        }
        this.emailSent = true;
        return AttemptStatus.SUCCESS;
    }

    public String embed(String string) throws Exception {
        return this.mail.embed(string);
    }

    public String embed(File file) throws Exception {
        return this.mail.embed(file);
    }

    public String embed(Binary binary) throws Exception {
        return this.mail.embed(binary);
    }

    public ProcessHandler[] getExecutionPhases() {
        return new ProcessHandler[]{new initializeMail(), new DetermineInputs(), new ProcessInputs(), new SetActivityInputs(), new ProcessOnEnter(), new ExecuteActivity(), new ProcessOnExit(), new RetrieveOutputs(), new RepeatActivity(), new DetermineTransitions()};
    }

    private class initializeMail
    implements ProcessHandler {
        private initializeMail() {
        }

        public void executeHandler(ActivityContext activityContext) throws InterruptedException {
            EmailActivity.this.mail = new WorkflowMail();
        }
    }
}

