/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.EdgeDrive.FileOperations;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.EdgeDrive.AbstractHttpClientActivity;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.XMLQuery;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import workflow.types.NameValue;
import workflow.types.SimpleType;
import workflow.types.WebMethod;
import workflow.types.WebRequest;

public class ViewPropofFileorFolder
extends AbstractHttpClientActivity
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ViewPropofFileorFolder.class);
    @Input(documentation="The path or GUID to the file or folder", required=true)
    public String fileOrfolderPathOrGUID;
    @Input(documentation="The share ID")
    public String shareId;
    @Input(documentation="IsPublicShare", defaultValue="false")
    public Boolean isPublicShare;
    @Output(documentation="name of the file or folder")
    public String name;
    @Output(documentation="GUID of the file or folder")
    public String GUID;
    @Output(documentation="size of the file or folder")
    public String sizeinBytes;
    @Output(documentation="parent GUID")
    public String parentGuid;
    @Output(documentation="parent Path")
    public String parentPath;
    @Output(documentation="parent Path")
    public String downloadURL;
    @Output(documentation="Modified time of the file")
    public String modifiedTime;
    @Output(documentation="Latest Version of the file")
    public String versionGUID;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        WebRequest webRequest = new WebRequest();
        String string = null;
        string = this.shareId.isEmpty() ? "/SearchSvc/CVWebService.svc/drive" : (this.isPublicShare != false ? "/SearchSvc/CVWebService.svc/drive/publicshare/" + this.shareId : "/SearchSvc/CVWebService.svc/drive/share/" + this.shareId);
        if (this.fileOrfolderPathOrGUID.matches("[0-9a-fA-F]{8}[0-9a-fA-F]{4}[0-9a-fA-F]{4}[0-9a-fA-F]{4}[0-9a-fA-F]{12}")) {
            string = string.concat("/file/" + this.fileOrfolderPathOrGUID);
        } else {
            try {
                this.fileOrfolderPathOrGUID = URLEncoder.encode(this.fileOrfolderPathOrGUID, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                logger.error("URL Encoding failed with exception: " + unsupportedEncodingException.toString());
            }
            string = string.concat("/action/metadata?path=" + this.fileOrfolderPathOrGUID);
        }
        String string2 = "QSDKONLY " + activityContext.getContext().getToken();
        ArrayList<NameValue> arrayList = new ArrayList<NameValue>();
        if (!this.isPublicShare.booleanValue()) {
            arrayList.add(new NameValue("Authtoken", string2));
        }
        arrayList.add(new NameValue("Accept", "application/xml"));
        webRequest.setUrl(string);
        webRequest.setHeaders(arrayList);
        webRequest.setMethod(WebMethod.GET);
        logger.debug("sending request to server");
        AttemptStatus attemptStatus = super.executeRequest(webRequest, activityContext);
        if (attemptStatus == AttemptStatus.SUCCESS) {
            if (this.statusCode != 200) {
                logger.error("Server return with message : " + this.output.toString());
                activityContext.setFailureReason("Server returned an unexpected message. Please check logs for more info about the failure.");
                return AttemptStatus.FAILED;
            }
            String string3 = this.output.toString();
            String string4 = ".//@name";
            String string5 = ".//@GUID";
            String string6 = ".//@parentGuid";
            String string7 = ".//@parentPath";
            String string8 = ".//@downloadUrl";
            String string9 = ".//@modifiedTime";
            String string10 = ".//@versionGUID";
            String string11 = ".//@sizeinBytes";
            try {
                this.name = (String)XMLQuery.query((String)string3, (String)string4, (SimpleType)SimpleType.String, (boolean)false);
                this.GUID = (String)XMLQuery.query((String)string3, (String)string5, (SimpleType)SimpleType.String, (boolean)false);
                this.parentGuid = (String)XMLQuery.query((String)string3, (String)string6, (SimpleType)SimpleType.String, (boolean)false);
                this.parentPath = (String)XMLQuery.query((String)string3, (String)string7, (SimpleType)SimpleType.String, (boolean)false);
                this.downloadURL = (String)XMLQuery.query((String)string3, (String)string8, (SimpleType)SimpleType.String, (boolean)false);
                this.modifiedTime = (String)XMLQuery.query((String)string3, (String)string9, (SimpleType)SimpleType.String, (boolean)false);
                this.versionGUID = (String)XMLQuery.query((String)string3, (String)string10, (SimpleType)SimpleType.String, (boolean)false);
                this.sizeinBytes = (String)XMLQuery.query((String)string3, (String)string11, (SimpleType)SimpleType.String, (boolean)false);
            }
            catch (EvFailureException evFailureException) {
                logger.error("Could not retrieve parameters from response");
            }
        }
        return attemptStatus;
    }
}

