/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.EdgeDrive.FileOperations;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.EdgeDrive.AbstractHttpClientActivity;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.XMLQuery;
import java.util.ArrayList;
import workflow.types.NameValue;
import workflow.types.SimpleType;
import workflow.types.WebMethod;
import workflow.types.WebPostType;
import workflow.types.WebRequest;

public class RenameFileorFolder
extends AbstractHttpClientActivity
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(RenameFileorFolder.class);
    @Input(documentation="The complete path or GUID to the file or folder to be Renamed", required=true)
    public String fileOrFolderPathOrGUID;
    @Input(documentation="The new name for the file or folder", required=true)
    public String newName;
    @Input(documentation="The share ID")
    public String shareId;
    @Output(documentation="The errorcode of the operation")
    public String errorCode;
    @Output(documentation="The errorMessage of the operation")
    public String errorMessage;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        WebRequest webRequest = new WebRequest();
        String string = "";
        String string2 = null;
        string2 = this.shareId.isEmpty() ? "/SearchSvc/CVWebService.svc/drive" : "/SearchSvc/CVWebService.svc/drive/share/" + this.shareId;
        if (this.fileOrFolderPathOrGUID.matches("[0-9a-fA-F]{8}[0-9a-fA-F]{4}[0-9a-fA-F]{4}[0-9a-fA-F]{4}[0-9a-fA-F]{12}")) {
            string2 = string2.concat("/file/" + this.fileOrFolderPathOrGUID + "/action/rename");
            string = "<App_FileResourceInfo name=\"" + this.newName + "\"/>";
            webRequest.setMethod(WebMethod.PUT);
        } else {
            string2 = string2.concat("/action/rename");
            string = "<App_FileResourceInfo path=\"" + this.fileOrFolderPathOrGUID + "\" name=\"" + this.newName + "\" />";
            webRequest.setMethod(WebMethod.POST);
        }
        String string3 = "QSDKONLY " + activityContext.getContext().getToken();
        ArrayList<NameValue> arrayList = new ArrayList<NameValue>();
        arrayList.add(new NameValue("Authtoken", string3));
        arrayList.add(new NameValue("Accept", "application/xml"));
        webRequest.setUrl(string2);
        webRequest.setHeaders(arrayList);
        webRequest.setPostType(WebPostType.Raw);
        webRequest.setPostContent((Object)string);
        logger.debug("sending request to server with XML content: " + string);
        AttemptStatus attemptStatus = super.executeRequest(webRequest, activityContext);
        if (attemptStatus == AttemptStatus.SUCCESS) {
            if (this.statusCode != 200) {
                logger.error("Server return with message : " + this.output.toString());
                activityContext.setFailureReason("Server returned an unexpected message. Please check logs for more info about the failure.");
                this.errorCode = "1";
                this.errorMessage = "Operation Failed";
                return AttemptStatus.FAILED;
            }
            String string4 = this.output.toString();
            String string5 = ".//@errorCode";
            String string6 = ".//@errorMessage";
            try {
                this.errorCode = (String)XMLQuery.query((String)string4, (String)string5, (SimpleType)SimpleType.String, (boolean)false);
                this.errorMessage = (String)XMLQuery.query((String)string4, (String)string6, (SimpleType)SimpleType.String, (boolean)false);
            }
            catch (EvFailureException evFailureException) {
                logger.error("Could not retrieve errorCode from XML");
            }
        }
        return attemptStatus;
    }
}

