/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.EdgeDrive.FileOperations;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.EdgeDrive.AbstractHttpClientActivity;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.XMLQuery;
import java.util.ArrayList;
import workflow.types.NameValue;
import workflow.types.SimpleType;
import workflow.types.WebMethod;
import workflow.types.WebPostType;
import workflow.types.WebRequest;

public class CreateFolder
extends AbstractHttpClientActivity
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CreateFolder.class);
    @Input(documentation="The name of the new folder", required=true)
    public String folderName;
    @Input(documentation="The path or GUID to the parent folder", required=true)
    public String parentPathOrGUID;
    @Input(documentation="The share ID")
    public String shareId;
    @Output(documentation="The GUID of the new folder")
    public String GUID;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        WebRequest webRequest = new WebRequest();
        String string = "";
        String string2 = null;
        string2 = this.shareId.isEmpty() ? "/SearchSvc/CVWebService.svc/drive" : "/SearchSvc/CVWebService.svc/drive/share/" + this.shareId;
        if (this.parentPathOrGUID.matches("[0-9a-fA-F]{8}[0-9a-fA-F]{4}[0-9a-fA-F]{4}[0-9a-fA-F]{4}[0-9a-fA-F]{12}")) {
            string2 = string2.concat("/file/" + this.parentPathOrGUID);
            string = "<App_FileResourceInfo name=\"" + this.folderName + "\"/>";
        } else {
            string2 = string2.concat("/action/createfolder");
            string = "<App_FileResourceInfo name=\"" + this.folderName + "\" parentPath=\"" + this.parentPathOrGUID + "\" />";
        }
        String string3 = "QSDKONLY " + activityContext.getContext().getToken();
        ArrayList<NameValue> arrayList = new ArrayList<NameValue>();
        arrayList.add(new NameValue("Authtoken", string3));
        arrayList.add(new NameValue("Accept", "application/xml"));
        webRequest.setUrl(string2);
        webRequest.setHeaders(arrayList);
        webRequest.setMethod(WebMethod.POST);
        webRequest.setPostType(WebPostType.Raw);
        webRequest.setPostContent((Object)string);
        logger.debug("sending request to server with XML content: " + string);
        AttemptStatus attemptStatus = super.executeRequest(webRequest, activityContext);
        if (attemptStatus == AttemptStatus.SUCCESS) {
            if (this.statusCode != 201) {
                logger.error("Server return with message : " + this.output.toString());
                activityContext.setFailureReason("Server returned an unexpected message. Please check logs for more info about the failure.");
                this.GUID = "0";
                return AttemptStatus.FAILED;
            }
            String string4 = this.output.toString();
            String string5 = ".//fileResource/@GUID";
            try {
                this.GUID = (String)XMLQuery.query((String)string4, (String)string5, (SimpleType)SimpleType.String, (boolean)false);
            }
            catch (EvFailureException evFailureException) {
                logger.error("Could not retrieve GUID from XML");
            }
        }
        return attemptStatus;
    }
}

