/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.EdgeDrive.FileIO;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.AbstractHttpClientActivity;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.XMLQuery;
import java.util.ArrayList;
import workflow.types.Binary;
import workflow.types.NameValue;
import workflow.types.OutputFormat;
import workflow.types.SimpleType;
import workflow.types.WebMethod;
import workflow.types.WebPostType;
import workflow.types.WebRequest;

public class UploadFileChunk
extends AbstractHttpClientActivity
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(UploadFileChunk.class);
    @Input(documentation="The file chunk to be uploaded", required=true)
    public Binary fileChunk;
    @Input(documentation="The unique identifier for the current upload session", required=true)
    public String requestId;
    @Input(documentation="Specifies whether the end of file has reached")
    public String fileEOF;
    @Input(documentation="The share ID")
    public String shareId;
    @Input
    public OutputFormat outputFormatofResponse;
    @Output(documentation="Output XML")
    public String outputXml;
    @Output(documentation="Number of uploaded bytes")
    public String chunkOffset;
    @Output(documentation="GUID of the complete file")
    public String GUID;
    @Output(documentation="errorcode of the complete file")
    public String errorCode;

    public UploadFileChunk(String string, String string2) {
        this.requestId = string;
        this.shareId = string2;
    }

    public void setFile(Binary binary) {
        this.fileChunk = binary;
    }

    public void setEOF(boolean bl) {
        this.fileEOF = bl ? "1" : "0";
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        this.outputFormatofResponse = outputFormat;
    }

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        WebRequest webRequest = new WebRequest();
        String string = null;
        string = this.shareId.isEmpty() ? "/SearchSvc/CVWebService.svc/drive/file/action/upload" : "/SearchSvc/CVWebService.svc/drive/share/" + this.shareId + "/file/action/upload";
        String string2 = "QSDKONLY " + activityContext.getContext().getToken();
        ArrayList<NameValue> arrayList = new ArrayList<NameValue>();
        arrayList.add(new NameValue("uploadType", "chunkedFile"));
        arrayList.add(new NameValue("requestId", this.requestId));
        ArrayList<NameValue> arrayList2 = new ArrayList<NameValue>();
        arrayList2.add(new NameValue("FileEOF", this.fileEOF));
        if (this.outputFormatofResponse == OutputFormat.json) {
            arrayList2.add(new NameValue("Accept", "application/json"));
        } else {
            arrayList2.add(new NameValue("Accept", "application/xml"));
        }
        arrayList2.add(new NameValue("Authtoken", string2));
        webRequest.setUrl(string);
        webRequest.setHeaders(arrayList2);
        webRequest.setParameters(arrayList);
        webRequest.setMethod(WebMethod.POST);
        webRequest.setPostType(WebPostType.Raw);
        webRequest.setPostContent((Object)this.fileChunk);
        webRequest.setPostContentType(null);
        logger.debug("sending request to server");
        AttemptStatus attemptStatus = super.executeRequest(webRequest, activityContext);
        if (attemptStatus == AttemptStatus.SUCCESS) {
            if (this.statusCode != 200) {
                logger.error("Server return with message : " + this.output.toString());
                activityContext.setFailureReason("Server returned an unexpected message. Please check logs for more info about the failure.");
                this.outputXml = this.output.toString();
                this.chunkOffset = "0";
                this.GUID = "0";
                return AttemptStatus.FAILED;
            }
            this.outputXml = this.output.toString();
            if (this.outputFormatofResponse == OutputFormat.xml) {
                String string3 = ".//@fileGUID";
                String string4 = ".//@chunkOffset";
                String string5 = ".//@errorCode";
                try {
                    this.chunkOffset = (String)XMLQuery.query((String)this.outputXml, (String)string4, (SimpleType)SimpleType.String, (boolean)false);
                    this.GUID = (String)XMLQuery.query((String)this.outputXml, (String)string3, (SimpleType)SimpleType.String, (boolean)false);
                    this.errorCode = (String)XMLQuery.query((String)this.outputXml, (String)string5, (SimpleType)SimpleType.String, (boolean)false);
                }
                catch (EvFailureException evFailureException) {
                    logger.error("Could not retrieve GUID from XML");
                }
            } else {
                try {
                    JsonParser jsonParser = new JsonParser();
                    JsonObject jsonObject = jsonParser.parse(this.outputXml).getAsJsonObject();
                    this.GUID = jsonObject.get("fileGUID").getAsString();
                    this.chunkOffset = jsonObject.get("chunkOffset").getAsString();
                    this.errorCode = jsonObject.get("errorCode").getAsString();
                }
                catch (NullPointerException nullPointerException) {
                    logger.error("Could not retrieve GUID or errorcode from response");
                }
            }
            return AttemptStatus.SUCCESS;
        }
        return attemptStatus;
    }
}

