/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import workflow.types.DelayInterval;

public class DelayActivity
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(DelayActivity.class);
    @Input(documentation="the length of the delay")
    public Integer delayLength;
    @Input(documentation="the interval of the delay", defaultValue="Minutes")
    public DelayInterval delayInterval;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.delayLength != null && this.delayLength > 0) {
            int n;
            if (this.delayInterval == null) {
                this.delayInterval = DelayInterval.Minutes;
            }
            switch (this.delayInterval) {
                case Seconds: {
                    logger.info(Long.valueOf(activityContext.getJobId()), "delaying the workflow for [%s] second(s)", new Object[]{this.delayLength});
                    n = 1;
                    break;
                }
                case Hours: {
                    n = 3600;
                    logger.info(Long.valueOf(activityContext.getJobId()), "delaying the workflow for [%s] hour(s)", new Object[]{this.delayLength});
                    break;
                }
                default: {
                    n = 60;
                    logger.info(Long.valueOf(activityContext.getJobId()), "delaying the workflow for [%s] minute(s)", new Object[]{this.delayLength});
                }
            }
            int n2 = 0;
            int n3 = this.delayLength * n;
            while (true) {
                Object object = activityContext.getLock();
                synchronized (object) {
                    activityContext.getLock().wait(1000L);
                    if (++n2 >= n3) {
                        return AttemptStatus.SUCCESS;
                    }
                    if (activityContext.getStatus() != ProcessStatus.RUNNING) {
                        logger.info(Long.valueOf(activityContext.getJobId()), "exiting activity since it has a status of [%s]", new Object[]{activityContext.getStatus()});
                        activityContext.repeat(Integer.valueOf(0));
                        return AttemptStatus.SUCCESS;
                    }
                    if (!activityContext.isRunning()) {
                        logger.info(Long.valueOf(activityContext.getJobId()), "exiting activity since the workflow is shutting down");
                        activityContext.repeat(Integer.valueOf(0));
                        return AttemptStatus.SUCCESS;
                    }
                }
            }
        }
        logger.info(Long.valueOf(activityContext.getJobId()), "no supplied delay interval");
        return AttemptStatus.SUCCESS;
    }
}

