/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.WorkflowTransition;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.activity.ActivityValidator;
import commvault.cte.workflow.activity.ExpressionHandler;
import commvault.cte.workflow.activity.PhaseHandler;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.handler.DetermineInputs;
import commvault.cte.workflow.handler.ExecuteActivity;
import commvault.cte.workflow.handler.ProcessHandler;
import commvault.cte.workflow.handler.ProcessInputs;
import commvault.cte.workflow.handler.ProcessOnEnter;
import commvault.cte.workflow.handler.ProcessOnExit;
import commvault.cte.workflow.handler.RetrieveOutputs;
import commvault.cte.workflow.handler.SetActivityInputs;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.Workflow.ActivityDefinition;
import commvault.msgs.Workflow.ScriptDefinition;
import commvault.msgs.Workflow.ScriptLanguage;
import commvault.msgs.Workflow.TransitionDefinition;
import workflow.types.ScriptType;

public class DecisionActivity
implements Activity,
PhaseHandler,
ExpressionHandler,
ActivityValidator {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(DecisionActivity.class);
    @Input(documentation="java expression to determine transition")
    public String expression;
    @Input(defaultValue="JAVA")
    public ScriptType scriptType;
    private Boolean result = null;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        Object object;
        if (this.scriptType == null) {
            this.scriptType = ScriptType.JAVA;
        }
        ScriptDefinition scriptDefinition = new ScriptDefinition();
        scriptDefinition.setLanguage(ScriptLanguage.valueOf((String)this.scriptType.name()));
        scriptDefinition.setScript(this.expression);
        try {
            object = activityContext.getEvaluator().evaluate(scriptDefinition);
        }
        catch (EvFailureException evFailureException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "error executing script type [" + this.scriptType + "], script [" + this.expression + "]");
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            activityContext.setFailureReason(new EvMessageContainer(evFailureException.getMessage()));
            return AttemptStatus.FAILED;
        }
        logger.info(Long.valueOf(activityContext.getJobId()), "result of decision expression is [%s]", new Object[]{String.valueOf(object)});
        if (object == null) {
            logger.warn(Long.valueOf(activityContext.getJobId()), "null result from script type [%s], expression [%s]", new Object[]{this.scriptType, this.expression});
        } else {
            this.result = object instanceof Boolean ? (Boolean)object : Boolean.valueOf(object.toString());
        }
        return AttemptStatus.SUCCESS;
    }

    public ProcessHandler[] getExecutionPhases() {
        return new ProcessHandler[]{new DetermineInputs(), new ProcessInputs(), new SetActivityInputs(), new ProcessOnEnter(), new ExecuteActivity(), new ProcessOnExit(), new RetrieveOutputs(), new DetermineTransition()};
    }

    public void processExpressions(ActivityContext activityContext, WorkflowElement workflowElement) {
    }

    public void validate(ActivityDefinition activityDefinition) throws EvFailureException {
        if (activityDefinition.getTransition().size() == 2) {
            boolean bl = false;
            boolean bl2 = false;
            for (TransitionDefinition transitionDefinition : activityDefinition.getTransition()) {
                if (transitionDefinition.getValue() == null || transitionDefinition.getValue().length() <= 0) continue;
                if (Boolean.valueOf(transitionDefinition.getValue()).booleanValue()) {
                    bl = true;
                    continue;
                }
                bl2 = true;
            }
            if (!bl || !bl2) {
                EvMessageContainer evMessageContainer;
                if (!bl) {
                    logger.error("Decision activity [" + activityDefinition.getUniqueName() + "] is missing a True transition");
                    evMessageContainer = new EvMessageContainer("Decision activity [%s] is missing a True transition", new Object[]{activityDefinition.getUniqueName()});
                } else {
                    logger.error("Decision activity [" + activityDefinition.getUniqueName() + "] is missing a False transition");
                    evMessageContainer = new EvMessageContainer("Decision activity [%s] is missing a False transition", new Object[]{activityDefinition.getUniqueName()});
                }
                throw new EvFailureException(evMessageContainer);
            }
        } else {
            logger.error("Decision activity [" + activityDefinition.getUniqueName() + "] does not contain exactly two transitions, one for true and one for false");
            EvMessageContainer evMessageContainer = new EvMessageContainer("Decision activity [%s] must contain two transitions one for true and one for false", new Object[]{activityDefinition.getUniqueName()});
            throw new EvFailureException(evMessageContainer);
        }
    }

    private class DetermineTransition
    implements ProcessHandler {
        private DetermineTransition() {
        }

        public void executeHandler(ActivityContext activityContext) throws InterruptedException {
            if (activityContext.getOutboundTransitions().length == 0) {
                logger.info(Long.valueOf(activityContext.getJobId()), "no transitions to evaluate");
                return;
            }
            if (DecisionActivity.this.result != null) {
                for (WorkflowTransition workflowTransition : activityContext.getOutboundTransitions()) {
                    if (workflowTransition.getValue() != null && Boolean.valueOf(workflowTransition.getValue()).booleanValue() == DecisionActivity.this.result.booleanValue()) {
                        logger.info(Long.valueOf(activityContext.getJobId()), "taking transition [%s] because result [%s] matches inputed condition", new Object[]{workflowTransition.getTargetActivity(), DecisionActivity.this.result});
                        activityContext.addTransitionTo(workflowTransition);
                        return;
                    }
                    logger.debug(Long.valueOf(activityContext.getJobId()), "skipping transition [%s] because value [%s] does not match [%s]", new Object[]{workflowTransition.getTargetActivity(), workflowTransition.getValue(), DecisionActivity.this.result});
                }
            }
            logger.error(Long.valueOf(activityContext.getJobId()), "could not determine conditional transition");
            activityContext.setFailureReason("could not determine conditional transition");
            activityContext.setStatus(ProcessStatus.PENDING);
        }
    }
}

