/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.common.xml.CTEProcessingModel;
import commvault.cte.common.xml.XMLDecoder;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.SessionManager;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;

public class CustomResponse
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CustomResponse.class);
    @Input(documentation="the xml message to return to the caller")
    public String xml;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        try {
            if (!activityContext.isDebug()) {
                SessionManager.getInstance().close(activityContext.getSessionId(), (CTEProcessingModel)XMLDecoder.decode((String)this.xml));
            } else {
                logger.info("skip closing session with message since we are in debug mode [%s]", new Object[]{this.xml});
            }
        }
        catch (Exception exception) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to decode xml message [" + this.xml + "]", (Throwable)exception);
            activityContext.setFailureReason(new EvMessageContainer(exception.getMessage()));
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

