/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.common.xml.XMLDecoder;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.activities.CommandActivity;
import commvault.cte.workflow.activity.ExpressionHandler;
import commvault.cte.workflow.activity.XMLInput;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.eval.ExpressionUtils;
import commvault.cte.workflow.eval.WorkflowEvaluator;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import commvault.msgs.Workflow.CustomRemoteCommandDefinition;
import commvault.qnet.sys.CVPassword;
import java.util.Map;
import workflow.types.EncryptedString;

public class CustomRemoteCommandActivity
extends CommandActivity
implements XMLInput,
ExpressionHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CustomRemoteCommandActivity.class);
    private String inputs;
    private Map<String, Object> inputMap;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        EncryptedString encryptedString;
        String string;
        String string2;
        Object object;
        String string3;
        String string4;
        String string5;
        CustomRemoteCommandDefinition customRemoteCommandDefinition;
        if (activityContext.getDefinition() == null || activityContext.getDefinition().length() == 0) {
            String string6 = String.format("missing input definition for custom activity", new Object[0]);
            logger.error(Long.valueOf(activityContext.getJobId()), string6);
            activityContext.setFailureReason(new EvMessageContainer(string6));
            return AttemptStatus.FAILED;
        }
        try {
            customRemoteCommandDefinition = (CustomRemoteCommandDefinition)XMLDecoder.decode((String)activityContext.getDefinition());
        }
        catch (Exception exception) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to decode input definition [" + activityContext.getDefinition() + "]", (Throwable)exception);
            activityContext.setFailureReason(new EvMessageContainer(exception.getMessage()));
            return AttemptStatus.FAILED;
        }
        WorkflowEvaluator workflowEvaluator = new WorkflowEvaluator(activityContext.getEvaluator());
        try {
            this.inputMap = workflowEvaluator.getObjectMap(this.inputs, activityContext.getSchema().getInputs());
        }
        catch (EvFailureException evFailureException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to build input map for activity");
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        logger.debug("Input Map: %s", new Object[]{this.inputMap});
        try {
            string5 = workflowEvaluator.parseString(customRemoteCommandDefinition.getStartUpPath());
        }
        catch (EvFailureException evFailureException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to parse start up path for custom activity");
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        try {
            string4 = workflowEvaluator.parseString(customRemoteCommandDefinition.getCommand());
        }
        catch (EvFailureException evFailureException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to parse command for custom activity");
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        try {
            string3 = workflowEvaluator.parseString(customRemoteCommandDefinition.getArguments());
        }
        catch (EvFailureException evFailureException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to parse arguments for custom activity");
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        if (customRemoteCommandDefinition.getHost().length() > 0) {
            if (ExpressionUtils.isObjectExpression((String)customRemoteCommandDefinition.getHost())) {
                try {
                    object = activityContext.getEvaluator().evaluate(customRemoteCommandDefinition.getHost());
                }
                catch (EvFailureException evFailureException) {
                    logger.error(Long.valueOf(activityContext.getJobId()), "failed to evaluate host for custom activity");
                    activityContext.setFailureReason(evFailureException.getMessageContainer());
                    return AttemptStatus.FAILED;
                }
                string2 = object != null ? (object instanceof ClientEntity ? (((ClientEntity)object).getClientName().length() > 0 ? ((ClientEntity)object).getClientName() : WorkflowProperties.getInstance().getClient().getClientName()) : String.valueOf(object)) : WorkflowProperties.getInstance().getClient().getClientName();
            } else {
                string2 = customRemoteCommandDefinition.getHost();
            }
        } else {
            string2 = WorkflowProperties.getInstance().getClient().getClientName();
        }
        if (customRemoteCommandDefinition.getUser().length() > 0) {
            if (ExpressionUtils.isObjectExpression((String)customRemoteCommandDefinition.getHost())) {
                try {
                    object = activityContext.getEvaluator().evaluate(customRemoteCommandDefinition.getUser());
                }
                catch (EvFailureException evFailureException) {
                    logger.error(Long.valueOf(activityContext.getJobId()), "failed to evaluate user for custom activity");
                    activityContext.setFailureReason(evFailureException.getMessageContainer());
                    return AttemptStatus.FAILED;
                }
                string = String.valueOf(object);
            } else {
                string = customRemoteCommandDefinition.getUser();
            }
        } else {
            logger.debug(Long.valueOf(activityContext.getJobId()), "no user name was provided in definition for custom activity");
            string = "";
        }
        if (customRemoteCommandDefinition.getPassword().length() > 0) {
            if (ExpressionUtils.isObjectExpression((String)customRemoteCommandDefinition.getPassword())) {
                try {
                    object = activityContext.getEvaluator().evaluate(customRemoteCommandDefinition.getPassword());
                }
                catch (EvFailureException evFailureException) {
                    logger.error(Long.valueOf(activityContext.getJobId()), "failed to evaluate password for custom activity");
                    activityContext.setFailureReason(evFailureException.getMessageContainer());
                    return AttemptStatus.FAILED;
                }
                if (object != null) {
                    if (object instanceof EncryptedString) {
                        encryptedString = (EncryptedString)object;
                    } else {
                        logger.debug(Long.valueOf(activityContext.getJobId()), "encrypting password");
                        CVPassword cVPassword = new CVPassword();
                        encryptedString = new EncryptedString(cVPassword.encrypt(String.valueOf(object)));
                    }
                } else {
                    logger.warn(Long.valueOf(activityContext.getJobId()), "could not retrieve password from definition in custom activity");
                    encryptedString = null;
                }
            } else {
                logger.debug(Long.valueOf(activityContext.getJobId()), "encrypting password");
                object = new CVPassword();
                encryptedString = new EncryptedString(object.encrypt(customRemoteCommandDefinition.getPassword()));
            }
        } else {
            if (string.length() > 0) {
                logger.warn(Long.valueOf(activityContext.getJobId()), "no password was provided in definition for user [%s]", new Object[]{string});
            }
            encryptedString = null;
        }
        try {
            return this.executeCommand(activityContext, string2, string, encryptedString, string5, string4, "", null, string3, true);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
    }

    public Object getInput(String string) {
        return this.inputMap.get(string);
    }

    public void setInputs(String string) {
        this.inputs = string;
    }

    public void processExpressions(ActivityContext activityContext, WorkflowElement workflowElement) throws Exception {
    }
}

