/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.common.xml.XMLDecoder;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.WorkflowContext;
import commvault.cte.workflow.activities.AbstractHttpClientActivity;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.activity.ExpressionHandler;
import commvault.cte.workflow.activity.XMLActivity;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.eval.EvalManager;
import commvault.cte.workflow.eval.WorkflowEvaluator;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.Workflow.ActivitySchema;
import commvault.msgs.Workflow.CustomOperationDefinition;
import java.util.HashMap;
import java.util.Map;
import workflow.types.WebRequest;
import workflow.types.XML;
import workflow.types.XPathQuery;

public class CustomHttpClientActivity
extends AbstractHttpClientActivity
implements XMLActivity,
ExpressionHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CustomHttpClientActivity.class);
    private String inputs;
    private Map<String, Object> inputMap;
    private Map<String, Object> outputMap = new HashMap<String, Object>();
    private WorkflowElement xmlResponse;
    private String stringResponse;
    private WorkflowElement outputsXml;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        WorkflowElement workflowElement;
        WebRequest webRequest;
        WorkflowElement workflowElement2;
        CustomOperationDefinition customOperationDefinition;
        if (activityContext.getDefinition() == null || activityContext.getDefinition().length() == 0) {
            String string = String.format("missing operation definition for custom activity", new Object[0]);
            logger.error(Long.valueOf(activityContext.getJobId()), string);
            activityContext.setFailureReason(new EvMessageContainer(string));
            return AttemptStatus.FAILED;
        }
        try {
            customOperationDefinition = (CustomOperationDefinition)XMLDecoder.decode((String)activityContext.getDefinition());
        }
        catch (Exception exception) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to decode operation definition for custom activity", (Throwable)exception);
            activityContext.setFailureReason(new EvMessageContainer(exception.getMessage()));
            return AttemptStatus.FAILED;
        }
        try {
            workflowElement2 = WorkflowElement.parse((String)customOperationDefinition.getOperation());
        }
        catch (EvFailureException evFailureException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to parse custom activity definition [" + customOperationDefinition.getOperation() + "]");
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        if (workflowElement2 == null) {
            String string = String.format("missing input definition for custom activity", new Object[0]);
            logger.error(Long.valueOf(activityContext.getJobId()), string);
            activityContext.setFailureReason(new EvMessageContainer(string));
            return AttemptStatus.FAILED;
        }
        WorkflowEvaluator workflowEvaluator = new WorkflowEvaluator(activityContext.getEvaluator());
        try {
            this.inputMap = workflowEvaluator.getObjectMap(this.inputs, activityContext.getSchema().getInputs());
        }
        catch (EvFailureException evFailureException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to build input map for activity");
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        logger.debug("Input Map: %s", new Object[]{this.inputMap});
        try {
            workflowEvaluator.processElement(workflowElement2);
        }
        catch (EvFailureException evFailureException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to process expressions for activity, xml [" + activityContext.getDefinition() + "]");
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        try {
            webRequest = (WebRequest)activityContext.getMarshaller().decode(workflowElement2, WebRequest.class);
        }
        catch (Exception exception) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to decode input definition for custom activity", (Throwable)exception);
            activityContext.setFailureReason(new EvMessageContainer(exception.getMessage()));
            return AttemptStatus.FAILED;
        }
        if (super.executeRequest(webRequest, activityContext) == AttemptStatus.FAILED) {
            logger.debug(Long.valueOf(activityContext.getJobId()), "execute call in base class return failed");
            return AttemptStatus.FAILED;
        }
        logger.info(Long.valueOf(activityContext.getJobId()), "recieved response from website [%s]", new Object[]{this.output});
        this.xmlResponse = WorkflowElement.parseQuite((String)this.output);
        Object object = this.xmlResponse != null ? new EvalManager((WorkflowContext)activityContext, (Activity)this, (XPathQuery)this.xmlResponse) : activityContext.getEvaluator();
        WorkflowEvaluator workflowEvaluator2 = new WorkflowEvaluator(object);
        logger.debug(Long.valueOf(activityContext.getJobId()), "Executing Script [%s]", new Object[]{customOperationDefinition.getScript()});
        try {
            object.evaluate(customOperationDefinition.getScript());
        }
        catch (EvFailureException evFailureException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to evaluate script for custom activity");
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        logger.debug(Long.valueOf(activityContext.getJobId()), "Object Map: %s", new Object[]{this.outputMap});
        try {
            workflowElement = workflowEvaluator.buildXml(this.outputMap);
        }
        catch (EvFailureException evFailureException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to build output xml from object map [" + this.outputMap + "]");
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        logger.debug(Long.valueOf(activityContext.getJobId()), "Object XML: [%s]", new Object[]{workflowElement});
        try {
            this.outputsXml = WorkflowElement.parse((String)customOperationDefinition.getOutputs());
        }
        catch (EvFailureException evFailureException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to parse output definition for custom activity");
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        if (this.outputsXml == null) {
            this.outputsXml = new WorkflowElement("outputs");
        }
        logger.debug(Long.valueOf(activityContext.getJobId()), "Output Definition: [%s]", new Object[]{customOperationDefinition.getOutputs()});
        try {
            workflowEvaluator2.processElement(this.outputsXml);
        }
        catch (EvFailureException evFailureException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to process expressions in output xml for custom activity");
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        logger.debug(Long.valueOf(activityContext.getJobId()), "Parsed Outputs: [%s]", new Object[]{this.outputsXml});
        for (WorkflowElement workflowElement3 : this.outputsXml.getChildren()) {
            WorkflowElement workflowElement4 = workflowElement.getChild(workflowElement3.getName());
            if (workflowElement4 == null) continue;
            this.outputsXml.removeContent(workflowElement3);
            this.outputsXml.addContent(workflowElement4.clone());
        }
        logger.debug(Long.valueOf(activityContext.getJobId()), "Output XML: [%s]", new Object[]{this.outputsXml});
        return AttemptStatus.SUCCESS;
    }

    public Object getInput(String string) {
        return this.inputMap.get(string);
    }

    public void setOutput(String string, Object object) {
        this.outputMap.put(string, object);
    }

    public String getResponse() {
        return this.stringResponse;
    }

    public XML getXmlResponse() {
        return this.xmlResponse;
    }

    public void setInputs(String string) {
        this.inputs = string;
    }

    public String getOutputs() {
        return this.outputsXml.toString();
    }

    public ActivitySchema getSchema(String string) {
        return null;
    }

    public void processExpressions(ActivityContext activityContext, WorkflowElement workflowElement) throws Exception {
    }
}

