/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.common.xml.XMLDecoder;
import commvault.cte.db.CTEDBConnInfo;
import commvault.cte.db.CTEDBException;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.Capability;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EvSecurity;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.SecurityContext;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.activity.ActivityValidator;
import commvault.cte.workflow.activity.ExpressionHandler;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.db.GenericQuery;
import commvault.cte.workflow.db.WorkflowConnection;
import commvault.cte.workflow.db.cs.APP_CommCellInfo_t;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.eval.EvalContext;
import commvault.cte.workflow.eval.WorkflowEvaluator;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.WorkflowUtils;
import commvault.msgs.CvEntities.CommCellEntity;
import commvault.msgs.Workflow.ActivityDefinition;
import commvault.msgs.Workflow.SqlDefinition;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamReader;
import workflow.types.SQLParameter;
import workflow.types.XML;
import workflow.types.data.DataRow;
import workflow.types.data.DataSet;

public class CommServDBQuery
implements Activity,
ActivityValidator,
ExpressionHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CommServDBQuery.class);
    private static Boolean AUTO_ESCAPE_SQL_STRINGS;
    @Input
    public List<Object> commCell;
    @Input
    public String query;
    @Input(visible=false)
    public List<SQLParameter> parameters;
    @Input
    public XML sql;
    @Output
    public List<DataSet> resultSets;
    @Output
    public int errorCode;
    @Output
    public String errorMessage;
    private String xml;

    private static boolean isEscapeSQLStrings() {
        if (AUTO_ESCAPE_SQL_STRINGS == null) {
            AUTO_ESCAPE_SQL_STRINGS = WorkflowRegistry.getInstance().isEscapeSQLStrings();
        }
        return AUTO_ESCAPE_SQL_STRINGS;
    }

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        this.errorCode = 0;
        this.errorMessage = "";
        if (!activityContext.getContext().isLoggedIn()) {
            this.errorCode = 1;
            this.errorMessage = "user is not logged in";
            logger.error(Long.valueOf(activityContext.getJobId()), "user is not logged in");
            activityContext.setFailureReason(new EvMessageContainer("user is not logged in"));
            return AttemptStatus.FAILED;
        }
        SqlDefinition sqlDefinition = new SqlDefinition();
        if (this.sql != null) {
            try {
                sqlDefinition = (SqlDefinition)XMLDecoder.decode((XMLStreamReader)new commvault.cte.workflow.dom.XMLStreamReader((WorkflowElement)this.sql), (Object)new SqlDefinition());
            }
            catch (Exception exception) {
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to decode script definition [" + this.sql + "]", (Throwable)exception);
            }
        }
        if (this.query == null || this.query.length() == 0) {
            if (sqlDefinition.getQuery().length() > 0) {
                this.query = sqlDefinition.getQuery();
            } else {
                logger.info(Long.valueOf(activityContext.getJobId()), "no query provided to execute");
                return AttemptStatus.SUCCESS;
            }
        }
        if (this.commCell == null) {
            this.commCell = new ArrayList<Object>();
        }
        if (this.commCell.size() == 0) {
            if (sqlDefinition.getCommCell().length() > 0) {
                this.commCell.add(sqlDefinition.getCommCell());
            } else {
                this.commCell.add(activityContext.getContext().getCommCell().getCommCellName());
            }
        }
        this.resultSets = new ArrayList<DataSet>();
        boolean bl = false;
        for (Object object : this.commCell) {
            String string = object instanceof CommCellEntity ? ((CommCellEntity)object).getCommCellName() : String.valueOf(object);
            List<DataSet> list = null;
            try {
                list = this.performQuery(activityContext, string);
            }
            catch (EvFailureException evFailureException) {
                activityContext.setFailureReason(evFailureException.getMessageContainer());
                bl = true;
                continue;
            }
            if (list != null) {
                if (this.resultSets.size() == 0) {
                    this.resultSets.addAll(list);
                    continue;
                }
                for (int i = 0; i < this.resultSets.size(); ++i) {
                    if (list.size() >= i) {
                        DataSet dataSet = this.resultSets.get(i);
                        DataSet dataSet2 = list.get(i);
                        if (dataSet2.getCommCell() != null) {
                            dataSet.getCommCells().add(dataSet2.getCommCell());
                        }
                        for (DataRow dataRow : dataSet2.getRows()) {
                            dataSet.add(new DataRow(dataSet.getMetaData(), dataRow.getColumns()));
                        }
                        continue;
                    }
                    logger.warn(Long.valueOf(activityContext.getJobId()), "could not find result set index [%s] for commCell [%s]", new Object[]{i, string});
                }
                continue;
            }
            logger.debug(Long.valueOf(activityContext.getJobId()), "no result sets where returned from commcell [%s]", new Object[]{string});
        }
        if (bl) {
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }

    private List<DataSet> performQuery(ActivityContext activityContext, String string) throws EvFailureException, InterruptedException {
        GenericQuery genericQuery;
        APP_CommCellInfo_t aPP_CommCellInfo_t;
        if (string.equalsIgnoreCase(activityContext.getContext().getCommCell().getCommCellName())) {
            try {
                if (!EvSecurity.isAdministrativeCapabilityRetry((int)activityContext.getContext().getCommCell().getCommCellId(), (SecurityContext)activityContext.getContext())) {
                    this.errorCode = -1;
                    this.errorMessage = String.format("impersonated user [%s] does not have required capability [%s]", activityContext.getContext().getUserName(), Capability.ADMINISTRATIVE_MANAGEMENT.getDisplayName());
                    logger.error(Long.valueOf(activityContext.getJobId()), this.errorMessage);
                    EvMessageContainer evMessageContainer = EventMessage.getContainer((String)"GUIMSG_SECURITY_USER_CAPABILITY", (Object[])new Object[]{activityContext.getContext().getUserName(), Capability.ADMINISTRATIVE_MANAGEMENT.getDisplayName(), WorkflowProperties.getInstance().getCommCell().getCommCellName()});
                    throw new EvFailureException(evMessageContainer);
                }
            }
            catch (CTEDBException cTEDBException) {
                this.errorCode = -1;
                this.errorMessage = cTEDBException.getMessage();
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to check if user [" + activityContext.getContext().getUserName() + "] has capability [" + Capability.ADMINISTRATIVE_MANAGEMENT.getDisplayName() + "] on commCell [" + string + "]", (Throwable)cTEDBException);
                throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
            }
            aPP_CommCellInfo_t = activityContext.getContext().getConnInfo();
            String string2 = WorkflowConnection.getDatabaseURL((CTEDBConnInfo)aPP_CommCellInfo_t, (String)"CommServ");
            genericQuery = new GenericQuery(activityContext.getContext().getCommCell(), string2, aPP_CommCellInfo_t.getUserId(), aPP_CommCellInfo_t.getPassword());
        } else {
            aPP_CommCellInfo_t = new APP_CommCellInfo_t();
            String string3 = String.format("commcellId in (Select id from APP_CommCell Where aliasName = '%s')", string);
            try {
                if (!aPP_CommCellInfo_t.fill(string3)) {
                    this.errorCode = -1;
                    this.errorMessage = String.format("failed to find commCell information for [%s]", string);
                    logger.error(Long.valueOf(activityContext.getJobId()), "failed to find commCell information for [" + string + "] from [APP_CommCellInfo] table");
                    throw new EvFailureException(new EvMessageContainer("unknown commcell [%s]", new Object[]{string}));
                }
            }
            catch (CTEDBException cTEDBException) {
                this.errorCode = -1;
                this.errorMessage = cTEDBException.getMessage();
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to select from [APP_CommCellInfo] using where clause [" + string3 + "]", (Throwable)cTEDBException);
                throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
            }
            try {
                if (!EvSecurity.isAdministrativeCapabilityRetry((int)aPP_CommCellInfo_t.commcellId.get(), (SecurityContext)activityContext.getContext().getMasterImpersonation())) {
                    this.errorCode = -1;
                    this.errorMessage = String.format("impersonated user [%s] does not have required capability [%s] for commCell [%s]", activityContext.getContext().getUserName(), Capability.ADMINISTRATIVE_MANAGEMENT.getDisplayName(), string);
                    logger.error(Long.valueOf(activityContext.getJobId()), this.errorMessage);
                    EvMessageContainer evMessageContainer = EventMessage.getContainer((String)"GUIMSG_SECURITY_USER_CAPABILITY", (Object[])new Object[]{activityContext.getContext().getUserName(), Capability.ADMINISTRATIVE_MANAGEMENT.getDisplayName(), string});
                    throw new EvFailureException(evMessageContainer);
                }
            }
            catch (CTEDBException cTEDBException) {
                this.errorCode = -1;
                this.errorMessage = cTEDBException.getMessage();
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to check if user [" + activityContext.getContext().getUserName() + "] has capability [" + Capability.ADMINISTRATIVE_MANAGEMENT.getDisplayName() + "] on commCell [" + string + "]", (Throwable)cTEDBException);
                throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
            }
            catch (EvFailureException evFailureException) {
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to check if user [" + activityContext.getContext().getUserName() + "] has capability [" + Capability.ADMINISTRATIVE_MANAGEMENT.getDisplayName() + "] on commCell [" + string + "]");
                throw evFailureException;
            }
            CommCellEntity commCellEntity = new CommCellEntity();
            commCellEntity.setCommCellId(aPP_CommCellInfo_t.commcellId.get().intValue());
            commCellEntity.setCommCellName(string);
            CTEDBConnInfo cTEDBConnInfo = WorkflowUtils.getDatabaseConnection((APP_CommCellInfo_t)aPP_CommCellInfo_t);
            String string4 = WorkflowConnection.getDatabaseURL((CTEDBConnInfo)cTEDBConnInfo, (String)"CommServ");
            genericQuery = new GenericQuery(commCellEntity, string4, cTEDBConnInfo.getUserId(), cTEDBConnInfo.getPassword());
        }
        logger.debug(Long.valueOf(activityContext.getJobId()), "executing sql query [%s]", new Object[]{this.query});
        try {
            return genericQuery.executeBatch(this.query, this.parameters);
        }
        catch (CTEDBException cTEDBException) {
            this.errorCode = cTEDBException.getErrorCode();
            this.errorMessage = cTEDBException.getMessage();
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to create statment for query [" + this.query + "] on commCell [" + string + "]");
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
    }

    public void validate(ActivityDefinition activityDefinition) throws EvFailureException {
        if (activityDefinition.getInputs().size() == 0) {
            return;
        }
        WorkflowElement workflowElement = WorkflowElement.parse((String)((String)activityDefinition.getInputs().get(0)));
        if (workflowElement == null) {
            return;
        }
        WorkflowElement workflowElement2 = workflowElement.getChild("query");
        if (workflowElement2 == null) {
            return;
        }
        String string = workflowElement2.getText();
        if (!string.toLowerCase().contains("set nocount") && !string.toLowerCase().contains("@@rowcount")) {
            workflowElement2.setText("SET NOCOUNT ON\n" + string);
            activityDefinition.getInputs().clear();
            activityDefinition.getInputs().add(workflowElement.toString());
        }
    }

    public void processExpressions(ActivityContext activityContext, WorkflowElement workflowElement) throws Exception {
        logger.debug(Long.valueOf(activityContext.getJobId()), "begin processing expressions for sql inputs [%s]", new Object[]{workflowElement});
        WorkflowEvaluator workflowEvaluator = WorkflowRegistry.getInstance().isAutoEscapeSQLString() ? new SQLEncoderEvalutor(activityContext.getEvaluator()) : new WorkflowEvaluator(activityContext.getEvaluator());
        workflowEvaluator.processElement(workflowElement);
    }

    public class SQLEncoderEvalutor
    extends WorkflowEvaluator {
        public SQLEncoderEvalutor(EvalContext evalContext) {
            super(evalContext);
        }

        protected String getStringValue(Object object) {
            if (CommServDBQuery.isEscapeSQLStrings()) {
                return String.valueOf(object).replace("'", "''");
            }
            return super.getStringValue(object);
        }
    }
}

