/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.common.xml.XMLEncoder;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.activities.AbstractHttpClientActivity;
import commvault.cte.workflow.activities.AssignValues;
import commvault.cte.workflow.logger.CTELogger;
import workflow.types.WebMethod;
import workflow.types.WebPostType;
import workflow.types.WebRequest;

public abstract class BaseApiActivity
extends AbstractHttpClientActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(AssignValues.class);

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        WebRequest webRequest = new WebRequest();
        if (this.getWebMethod().equalsIgnoreCase("put")) {
            webRequest.setMethod(WebMethod.PUT);
        }
        if (this.getWebMethod().equalsIgnoreCase("post")) {
            webRequest.setMethod(WebMethod.POST);
        }
        webRequest.setUrl(this.getWebApi());
        try {
            webRequest.setPostContent((Object)XMLEncoder.encode((Object)this.getRequestMessage()));
        }
        catch (Exception exception) {
            logger.error("failed to encode message type [" + this.getRequestMessage().getClass() + "]", (Throwable)exception);
            activityContext.setFailureReason(new EvMessageContainer(exception.getMessage()));
            return AttemptStatus.FAILED;
        }
        webRequest.setPostContentType("application/xml");
        webRequest.setPostType(WebPostType.Raw);
        logger.info(">>>>>>>>>> method: " + webRequest.getMethod());
        logger.info(">>>>>>>>>> api: " + webRequest.getUrl());
        logger.info(">>>>>>>>>> message: " + webRequest.getPostContent());
        return AttemptStatus.SUCCESS;
    }

    protected abstract Object getRequestMessage();

    protected abstract String getWebApi();

    protected abstract String getWebMethod();
}

