/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.dfa;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.regex.tregex.matchers.CharMatcher;
import com.oracle.truffle.regex.tregex.nodes.dfa.AllTransitionsInOneTreeMatcher;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAAbstractStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFASimpleCG;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFASimpleCGTransition;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputIndexOfNode;
import com.oracle.truffle.regex.tregex.util.DebugUtil;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonArray;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import java.util.Arrays;

public class DFAStateNode
extends DFAAbstractStateNode {
    private static final byte FLAG_FINAL_STATE = 1;
    private static final byte FLAG_ANCHORED_FINAL_STATE = 2;
    private static final byte FLAG_HAS_BACKWARD_PREFIX_STATE = 4;
    private final byte flags;
    @Node.Child
    LoopOptimizationNode loopOptimizationNode;
    @Node.Children
    protected final CharMatcher[] matchers;
    private final DFASimpleCG simpleCG;
    private final AllTransitionsInOneTreeMatcher allTransitionsInOneTreeMatcher;
    private final BranchProfile stateReachedProfile = BranchProfile.create();

    DFAStateNode(DFAStateNode nodeSplitCopy, short copyID) {
        this(copyID, nodeSplitCopy.flags, nodeSplitCopy.loopOptimizationNode.nodeSplitCopy(), Arrays.copyOf(nodeSplitCopy.getSuccessors(), nodeSplitCopy.getSuccessors().length), nodeSplitCopy.getMatchers(), nodeSplitCopy.simpleCG, nodeSplitCopy.allTransitionsInOneTreeMatcher);
    }

    public DFAStateNode(short id, byte flags, LoopOptimizationNode loopOptimizationNode, short[] successors, CharMatcher[] matchers, DFASimpleCG simpleCG, AllTransitionsInOneTreeMatcher allTransitionsInOneTreeMatcher) {
        super(id, successors);
        assert (id > 0);
        this.flags = flags;
        this.loopOptimizationNode = loopOptimizationNode;
        this.matchers = matchers;
        this.simpleCG = simpleCG;
        this.allTransitionsInOneTreeMatcher = allTransitionsInOneTreeMatcher;
    }

    public static byte buildFlags(boolean finalState, boolean anchoredFinalState, boolean hasBackwardPrefixState) {
        byte flags = 0;
        if (finalState) {
            flags = (byte)(flags | 1);
        }
        if (anchoredFinalState) {
            flags = (byte)(flags | 2);
        }
        if (hasBackwardPrefixState) {
            flags = (byte)(flags | 4);
        }
        return flags;
    }

    public static LoopOptimizationNode buildLoopOptimizationNode(short loopTransitionIndex, char[] indexOfChars) {
        return new LoopOptimizationNode(loopTransitionIndex, indexOfChars);
    }

    @Override
    public DFAStateNode createNodeSplitCopy(short copyID) {
        return new DFAStateNode(this, copyID);
    }

    public final CharMatcher[] getMatchers() {
        return this.matchers;
    }

    public BranchProfile getStateReachedProfile() {
        return this.stateReachedProfile;
    }

    public boolean isFinalState() {
        return this.flagIsSet((byte)1);
    }

    public boolean isAnchoredFinalState() {
        return this.flagIsSet((byte)2);
    }

    public boolean hasBackwardPrefixState() {
        return this.flagIsSet((byte)4);
    }

    private boolean flagIsSet(byte flag) {
        return (this.flags & flag) != 0;
    }

    public boolean hasLoopToSelf() {
        return this.loopOptimizationNode != null;
    }

    boolean isLoopToSelf(int transitionIndex) {
        return this.hasLoopToSelf() && transitionIndex == this.getLoopToSelf();
    }

    short getLoopToSelf() {
        assert (this.hasLoopToSelf());
        return this.loopOptimizationNode.loopTransitionIndex;
    }

    boolean treeTransitionMatching() {
        return this.allTransitionsInOneTreeMatcher != null;
    }

    AllTransitionsInOneTreeMatcher getTreeMatcher() {
        return this.allTransitionsInOneTreeMatcher;
    }

    boolean sameResultAsRegularMatchers(TRegexDFAExecutorNode executor, char c, boolean compactString, int allTransitionsMatcherResult) {
        CompilerAsserts.neverPartOfCompilation();
        if (executor.isRegressionTestMode()) {
            for (int i = 0; i < this.matchers.length; ++i) {
                if (!this.matchers[i].execute(c, compactString)) continue;
                return i == allTransitionsMatcherResult;
            }
            return allTransitionsMatcherResult == -1;
        }
        return true;
    }

    @Override
    public void executeFindSuccessor(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, boolean compactString) {
        CompilerAsserts.partialEvaluationConstant((Object)this);
        CompilerAsserts.partialEvaluationConstant((boolean)compactString);
        if (this.hasLoopToSelf()) {
            if (executor.isForward() && this.loopOptimizationNode.indexOfChars != null) {
                this.runIndexOf(locals, executor, compactString);
            } else {
                while (executor.hasNext(locals)) {
                    if (executor.isSimpleCG()) {
                        this.checkFinalState(locals, executor, this.curIndex(locals));
                    }
                    if (this.checkMatch(locals, executor, compactString)) continue;
                    if (!executor.isSimpleCG()) {
                        this.checkFinalState(locals, executor, this.prevIndex(locals));
                    }
                    return;
                }
                locals.setSuccessorIndex(this.atEnd(locals, executor));
            }
        } else {
            if (!executor.hasNext(locals)) {
                locals.setSuccessorIndex(this.atEnd(locals, executor));
                return;
            }
            this.checkFinalState(locals, executor, this.curIndex(locals));
            this.checkMatch(locals, executor, compactString);
        }
    }

    private void runIndexOf(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, boolean compactString) {
        int preLoopIndex = locals.getIndex();
        int indexOfResult = this.loopOptimizationNode.getIndexOfNode().execute(locals.getInput(), preLoopIndex, locals.getCurMaxIndex(), this.loopOptimizationNode.indexOfChars);
        if (indexOfResult < 0) {
            if (this.simpleCG != null && locals.getCurMaxIndex() > preLoopIndex) {
                this.applySimpleCGTransition(this.simpleCG.getTransitions()[this.getLoopToSelf()], locals, locals.getCurMaxIndex() - 1);
            }
            locals.setIndex(locals.getCurMaxIndex());
            locals.setSuccessorIndex(this.atEnd(locals, executor));
        } else {
            if (this.simpleCG != null && indexOfResult > preLoopIndex) {
                this.applySimpleCGTransition(this.simpleCG.getTransitions()[this.getLoopToSelf()], locals, indexOfResult - 1);
            }
            this.checkFinalState(locals, executor, indexOfResult);
            if (this.successors.length == 2) {
                int successor = (this.getLoopToSelf() + 1) % 2;
                CompilerAsserts.partialEvaluationConstant((int)successor);
                if (this.simpleCG != null) {
                    this.applySimpleCGTransition(this.simpleCG.getTransitions()[successor], locals, indexOfResult);
                }
                locals.setIndex(indexOfResult + 1);
                locals.setSuccessorIndex(successor);
            } else {
                locals.setIndex(indexOfResult);
                this.checkMatch(locals, executor, compactString);
            }
        }
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    private boolean checkMatch(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, boolean compactString) {
        char c = executor.getChar(locals);
        executor.advance(locals);
        if (this.treeTransitionMatching()) {
            int successor = this.getTreeMatcher().checkMatchTree(locals, executor, this, c);
            assert (this.sameResultAsRegularMatchers(executor, c, compactString, successor)) : this.toString();
            locals.setSuccessorIndex(successor);
            return this.isLoopToSelf(successor);
        }
        for (int i = 0; i < this.matchers.length; ++i) {
            if (!this.matchers[i].execute(c, compactString)) continue;
            CompilerAsserts.partialEvaluationConstant((int)i);
            locals.setSuccessorIndex(i);
            this.successorFound(locals, executor, i);
            return this.isLoopToSelf(i);
        }
        locals.setSuccessorIndex(-1);
        return false;
    }

    protected void checkFinalState(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, int index) {
        CompilerAsserts.partialEvaluationConstant((Object)this);
        if (this.isFinalState()) {
            this.storeResult(locals, executor, index, false);
            if (this.simpleCG != null) {
                this.applySimpleCGFinalTransition(this.simpleCG.getTransitionToFinalState(), executor, locals, index);
            }
        }
    }

    int atEnd(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor) {
        boolean anchored;
        CompilerAsserts.partialEvaluationConstant((Object)this);
        boolean bl = anchored = this.isAnchoredFinalState() && executor.atEnd(locals);
        if (this.isFinalState() || anchored) {
            this.storeResult(locals, executor, this.curIndex(locals), anchored);
            if (this.simpleCG != null) {
                if (this.isAnchoredFinalState()) {
                    this.applySimpleCGFinalTransition(this.simpleCG.getTransitionToAnchoredFinalState(), executor, locals, this.curIndex(locals));
                } else if (this.isFinalState()) {
                    this.applySimpleCGFinalTransition(this.simpleCG.getTransitionToFinalState(), executor, locals, this.curIndex(locals));
                }
            }
        }
        return -1;
    }

    void successorFound(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, int i) {
        if (this.simpleCG != null) {
            this.applySimpleCGTransition(this.simpleCG.getTransitions()[i], locals, this.prevIndex(locals));
        }
    }

    void storeResult(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, int index, boolean anchored) {
        CompilerAsserts.partialEvaluationConstant((Object)this);
        if (executor.isSimpleCG()) {
            if (executor.getProperties().isSimpleCGMustCopy()) {
                System.arraycopy(locals.getCGData().results, 0, locals.getCGData().currentResult, 0, locals.getCGData().currentResult.length);
            }
            locals.setResultInt(0);
        } else {
            locals.setResultInt(index);
        }
    }

    static int[] simpleCGFinalTransitionTargetArray(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor) {
        return executor.getProperties().isSimpleCGMustCopy() ? locals.getCGData().currentResult : locals.getCGData().results;
    }

    int curIndex(TRegexDFAExecutorLocals locals) {
        CompilerAsserts.partialEvaluationConstant((Object)this);
        return locals.getIndex();
    }

    int prevIndex(TRegexDFAExecutorLocals locals) {
        CompilerAsserts.partialEvaluationConstant((Object)this);
        return locals.getIndex() - 1;
    }

    int nextIndex(TRegexDFAExecutorLocals locals) {
        CompilerAsserts.partialEvaluationConstant((Object)this);
        return locals.getIndex() + 1;
    }

    void applySimpleCGTransition(DFASimpleCGTransition transition, TRegexDFAExecutorLocals locals, int index) {
        transition.apply(locals.getCGData().results, index);
    }

    void applySimpleCGFinalTransition(DFASimpleCGTransition transition, TRegexDFAExecutorNode executor, TRegexDFAExecutorLocals locals, int index) {
        transition.apply(DFAStateNode.simpleCGFinalTransitionTargetArray(locals, executor), index);
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        StringBuilder sb = new StringBuilder();
        DebugUtil.appendNodeId(sb, this.getId()).append(": ");
        if (!this.treeTransitionMatching()) {
            sb.append(this.matchers.length).append(" successors");
        }
        if (this.isAnchoredFinalState()) {
            sb.append(", AFS");
        }
        if (this.isFinalState()) {
            sb.append(", FS");
        }
        sb.append(":\n");
        if (this.treeTransitionMatching()) {
            sb.append("      ").append(this.getTreeMatcher()).append("\n      successors: ").append(Arrays.toString(this.successors)).append("\n");
        } else {
            for (int i = 0; i < this.matchers.length; ++i) {
                sb.append("      ").append(i).append(": ").append((Object)this.matchers[i]).append(" -> ");
                DebugUtil.appendNodeId(sb, this.getSuccessors()[i]).append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        JsonArray transitions = Json.array(new JsonConvertible[0]);
        if (this.matchers != null) {
            for (int i = 0; i < this.matchers.length; ++i) {
                transitions.append(Json.obj(Json.prop("matcher", this.matchers[i].toString()), Json.prop("target", this.successors[i])));
            }
        }
        return Json.obj(Json.prop("id", this.getId()), Json.prop("anchoredFinalState", this.isAnchoredFinalState()), Json.prop("finalState", this.isFinalState()), Json.prop("loopToSelf", this.hasLoopToSelf()), Json.prop("transitions", transitions));
    }

    public static class LoopOptimizationNode
    extends Node {
        private final short loopTransitionIndex;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final char[] indexOfChars;
        @Node.Child
        private InputIndexOfNode indexOfNode;

        public LoopOptimizationNode(short loopTransitionIndex, char[] indexOfChars) {
            this.loopTransitionIndex = loopTransitionIndex;
            this.indexOfChars = indexOfChars;
        }

        private LoopOptimizationNode nodeSplitCopy() {
            return new LoopOptimizationNode(this.loopTransitionIndex, this.indexOfChars);
        }

        public char[] getIndexOfChars() {
            return this.indexOfChars;
        }

        public InputIndexOfNode getIndexOfNode() {
            if (this.indexOfNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.indexOfNode = (InputIndexOfNode)this.insert(InputIndexOfNode.create());
            }
            return this.indexOfNode;
        }
    }
}

