/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.matchers;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.regex.charset.SortedListOfRanges;
import com.oracle.truffle.regex.tregex.matchers.InvertibleCharMatcher;
import com.oracle.truffle.regex.tregex.matchers.SingleRangeMatcherNodeGen;

public abstract class SingleRangeMatcher
extends InvertibleCharMatcher {
    private final char lo;
    private final char hi;

    SingleRangeMatcher(boolean invert, char lo, char hi) {
        super(invert);
        this.lo = lo;
        this.hi = hi;
    }

    public static SingleRangeMatcher create(boolean invert, char lo, char hi) {
        return SingleRangeMatcherNodeGen.create(invert, lo, hi);
    }

    public char getLo() {
        return this.lo;
    }

    public char getHi() {
        return this.hi;
    }

    @Specialization
    boolean match(char c, boolean compactString) {
        return this.result((!compactString || this.lo < '\u0100') && this.lo <= c && this.hi >= c);
    }

    @Override
    public int estimatedCost() {
        return 2;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.modifiersToString() + SortedListOfRanges.rangeToString(this.lo, this.hi);
    }
}

