/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.charset;

import com.oracle.truffle.regex.charset.RangesBuffer;
import com.oracle.truffle.regex.charset.SortedListOfRanges;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;

public interface ImmutableSortedListOfRanges
extends SortedListOfRanges {
    public <T extends SortedListOfRanges> T createEmpty();

    public <T extends SortedListOfRanges> T createFull();

    public <T extends SortedListOfRanges> T create(RangesBuffer var1);

    public <T extends SortedListOfRanges> T createInverse();

    public RangesBuffer getBuffer1(CompilationBuffer var1);

    public RangesBuffer getBuffer2(CompilationBuffer var1);

    public RangesBuffer getBuffer3(CompilationBuffer var1);

    public RangesBuffer createTempBuffer();

    public boolean equalsBuffer(RangesBuffer var1);

    default public <T extends ImmutableSortedListOfRanges> T createIntersection(T o, CompilationBuffer compilationBuffer) {
        return this.createIntersection(o, this.getBuffer1(compilationBuffer));
    }

    default public <T extends ImmutableSortedListOfRanges> T createIntersection(T o, RangesBuffer target) {
        target.clear();
        for (int ia = 0; ia < this.size(); ++ia) {
            int firstIntersection;
            int search = o.binarySearch(this.getLo(ia));
            if (o.binarySearchExactMatch(search, this, ia)) {
                this.addRangeTo(target, ia);
                continue;
            }
            for (int ib = firstIntersection = o.binarySearchGetFirstIntersecting(search, this, ia); ib < o.size() && !o.rightOf(ib, this, ia); ++ib) {
                if (!1.$assertionsDisabled && !this.intersects(ia, o, ib)) {
                    throw new AssertionError();
                }
                target.appendRange(Math.max(this.getLo(ia), o.getLo(ib)), Math.min(this.getHi(ia), o.getHi(ib)));
            }
        }
        if (this.equalsBuffer(target)) {
            return (T)this;
        }
        if (o.equalsBuffer(target)) {
            return o;
        }
        return (T)((ImmutableSortedListOfRanges)this.create(target));
    }

    default public <T extends SortedListOfRanges> T subtract(T o, CompilationBuffer compilationBuffer) {
        RangesBuffer subtractionRanges = this.getBuffer1(compilationBuffer);
        boolean unchanged = true;
        for (int ia = 0; ia < this.size(); ++ia) {
            int search = o.binarySearch(this.getLo(ia));
            if (o.binarySearchExactMatch(search, this, ia)) {
                unchanged = false;
                continue;
            }
            int firstIntersection = o.binarySearchGetFirstIntersecting(search, this, ia);
            if (o.binarySearchNoIntersectingFound(firstIntersection)) {
                this.addRangeTo(subtractionRanges, ia);
                continue;
            }
            unchanged = false;
            int tmpLo = this.getLo(ia);
            int tmpHi = this.getHi(ia);
            boolean rest = true;
            for (int ib = firstIntersection; ib < o.size() && !o.rightOf(ib, tmpLo, tmpHi); ++ib) {
                if (!o.intersects(ib, tmpLo, tmpHi)) continue;
                if (o.contains(ib, tmpLo, tmpHi)) {
                    rest = false;
                    break;
                }
                if (o.containedBy(ib, tmpLo, tmpHi) && tmpLo != o.getLo(ib) && tmpHi != o.getHi(ib)) {
                    subtractionRanges.appendRange(tmpLo, o.getLo(ib) - 1);
                    tmpLo = o.getHi(ib) + 1;
                    continue;
                }
                if (tmpLo < o.getLo(ib)) {
                    tmpHi = o.getLo(ib) - 1;
                    continue;
                }
                tmpLo = o.getHi(ib) + 1;
            }
            if (!rest) continue;
            subtractionRanges.appendRange(tmpLo, tmpHi);
        }
        if (unchanged) {
            if (!1.$assertionsDisabled && !this.equalsBuffer(subtractionRanges)) {
                throw new AssertionError();
            }
            return (T)this;
        }
        return this.create(subtractionRanges);
    }

    default public <T extends ImmutableSortedListOfRanges> IntersectAndSubtractResult<T> intersectAndSubtract(T o, CompilationBuffer compilationBuffer) {
        RangesBuffer intersectionRanges;
        RangesBuffer subtractedB;
        RangesBuffer subtractedA;
        block25: {
            boolean noIntersection;
            int ib;
            int ia;
            block24: {
                if (this.matchesNothing() || o.matchesNothing()) {
                    return new IntersectAndSubtractResult<ImmutableSortedListOfRanges>(this, o, (ImmutableSortedListOfRanges)this.createEmpty());
                }
                subtractedA = this.getBuffer1(compilationBuffer);
                subtractedB = this.getBuffer2(compilationBuffer);
                intersectionRanges = this.getBuffer3(compilationBuffer);
                ia = 0;
                ib = 0;
                noIntersection = false;
                while (true) {
                    if (this.leftOf(ia, o, ib)) {
                        if (++ia < this.size()) continue;
                        noIntersection = true;
                        break block24;
                    }
                    if (!o.leftOf(ib, this, ia)) break block24;
                    if (++ib >= o.size()) break;
                }
                noIntersection = true;
            }
            if (noIntersection) {
                return new IntersectAndSubtractResult<ImmutableSortedListOfRanges>(this, o, (ImmutableSortedListOfRanges)this.createEmpty());
            }
            this.appendRangesTo(subtractedA, 0, ia);
            o.appendRangesTo(subtractedB, 0, ib);
            int raLo = this.getLo(ia);
            int raHi = this.getHi(ia);
            int rbLo = o.getLo(ib);
            int rbHi = o.getHi(ib);
            if (!1.$assertionsDisabled && !SortedListOfRanges.intersects(raLo, raHi, rbLo, rbHi)) {
                throw new AssertionError();
            }
            ++ia;
            ++ib;
            while (true) {
                if (SortedListOfRanges.leftOf(raLo, raHi, rbLo, rbHi)) {
                    subtractedA.appendRange(raLo, raHi);
                    if (ia < this.size()) {
                        raLo = this.getLo(ia);
                        raHi = this.getHi(ia);
                        ++ia;
                        continue;
                    }
                    subtractedB.appendRange(rbLo, rbHi);
                    o.appendRangesTo(subtractedB, ib, o.size());
                    break block25;
                }
                if (SortedListOfRanges.leftOf(rbLo, rbHi, raLo, raHi)) {
                    subtractedB.appendRange(rbLo, rbHi);
                    if (ib < o.size()) {
                        rbLo = o.getLo(ib);
                        rbHi = o.getHi(ib);
                        ++ib;
                        continue;
                    }
                    subtractedA.appendRange(raLo, raHi);
                    this.appendRangesTo(subtractedA, ia, this.size());
                    break block25;
                }
                if (!1.$assertionsDisabled && !SortedListOfRanges.intersects(raLo, raHi, rbLo, rbHi)) {
                    throw new AssertionError();
                }
                int intersectionLo = raLo;
                if (raLo < rbLo) {
                    intersectionLo = rbLo;
                    subtractedA.appendRange(raLo, intersectionLo - 1);
                } else if (raLo != rbLo) {
                    subtractedB.appendRange(rbLo, intersectionLo - 1);
                }
                int intersectionHi = raHi;
                if (raHi > rbHi) {
                    intersectionHi = rbHi;
                    intersectionRanges.appendRange(intersectionLo, intersectionHi);
                    raLo = intersectionHi + 1;
                    if (ib < o.size()) {
                        rbLo = o.getLo(ib);
                        rbHi = o.getHi(ib);
                        ++ib;
                        continue;
                    }
                    subtractedA.appendRange(raLo, raHi);
                    this.appendRangesTo(subtractedA, ia, this.size());
                    break block25;
                }
                if (raHi < rbHi) {
                    intersectionRanges.appendRange(intersectionLo, intersectionHi);
                    rbLo = intersectionHi + 1;
                    if (ia < this.size()) {
                        raLo = this.getLo(ia);
                        raHi = this.getHi(ia);
                        ++ia;
                        continue;
                    }
                    subtractedB.appendRange(rbLo, rbHi);
                    o.appendRangesTo(subtractedB, ib, o.size());
                    break block25;
                }
                if (!1.$assertionsDisabled && raHi != rbHi) {
                    throw new AssertionError();
                }
                intersectionRanges.appendRange(intersectionLo, intersectionHi);
                if (ia >= this.size()) {
                    o.appendRangesTo(subtractedB, ib, o.size());
                    break block25;
                }
                raLo = this.getLo(ia);
                raHi = this.getHi(ia);
                ++ia;
                if (ib >= o.size()) break;
                rbLo = o.getLo(ib);
                rbHi = o.getHi(ib);
                ++ib;
            }
            subtractedA.appendRange(raLo, raHi);
            this.appendRangesTo(subtractedA, ia, this.size());
        }
        if (subtractedA.isEmpty()) {
            if (!1.$assertionsDisabled && !this.equalsBuffer(intersectionRanges)) {
                throw new AssertionError();
            }
            return new IntersectAndSubtractResult<ImmutableSortedListOfRanges>((ImmutableSortedListOfRanges)this.createEmpty(), (ImmutableSortedListOfRanges)this.create(subtractedB), this);
        }
        if (subtractedB.isEmpty()) {
            if (!1.$assertionsDisabled && !o.equalsBuffer(intersectionRanges)) {
                throw new AssertionError();
            }
            return new IntersectAndSubtractResult<ImmutableSortedListOfRanges>((ImmutableSortedListOfRanges)this.create(subtractedA), (ImmutableSortedListOfRanges)this.createEmpty(), o);
        }
        return new IntersectAndSubtractResult<ImmutableSortedListOfRanges>((ImmutableSortedListOfRanges)this.create(subtractedA), (ImmutableSortedListOfRanges)this.create(subtractedB), (ImmutableSortedListOfRanges)this.create(intersectionRanges));
    }

    default public <T extends ImmutableSortedListOfRanges> T union(T o) {
        return this.union(o, this.createTempBuffer());
    }

    default public <T extends ImmutableSortedListOfRanges> T union(T o, CompilationBuffer compilationBuffer) {
        return this.union(o, this.getBuffer1(compilationBuffer));
    }

    default public <T extends ImmutableSortedListOfRanges> T union(T o, RangesBuffer target) {
        if (this.matchesNothing() || o.matchesEverything()) {
            return o;
        }
        if (this.matchesEverything() || o.matchesNothing()) {
            return (T)this;
        }
        SortedListOfRanges.union(this, o, target);
        if (this.equalsBuffer(target)) {
            return (T)this;
        }
        if (o.equalsBuffer(target)) {
            return o;
        }
        return (T)((ImmutableSortedListOfRanges)this.create(target));
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static final class IntersectAndSubtractResult<T extends ImmutableSortedListOfRanges> {
        public final T subtractedA;
        public final T subtractedB;
        public final T intersection;

        public IntersectAndSubtractResult(T subtractedA, T subtractedB, T intersected) {
            this.subtractedA = subtractedA;
            this.subtractedB = subtractedB;
            this.intersection = intersected;
        }
    }
}

