/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.supplemental.net;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.supplemental.io.IOActivity;
import commvault.cte.workflow.supplemental.net.TransferType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import workflow.types.EncryptedString;

public class SCPActivity
extends IOActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(SCPActivity.class);
    @Input
    public String hostName;
    @Input(defaultValue="22")
    public Integer port;
    @Input
    public String userName;
    @Input
    public EncryptedString password;
    @Input
    public String localFile;
    @Input
    public String remoteFile;
    @Input(defaultValue="SEND")
    public TransferType transferType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttemptStatus executeOperation(ActivityContext activityContext) throws InterruptedException {
        block14: {
            Session session;
            if (this.port == null) {
                this.port = 22;
            }
            JSch jSch = new JSch();
            try {
                session = jSch.getSession(this.userName, this.hostName, this.port.intValue());
            }
            catch (JSchException jSchException) {
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to get jsch session for host [" + this.hostName + "], port [" + this.port + "]");
                activityContext.setFailureReason(jSchException.getMessage());
                return AttemptStatus.FAILED;
            }
            session.setPassword(this.password.getPlainText());
            session.setConfig("StrictHostKeyChecking", "no");
            try {
                session.connect();
            }
            catch (JSchException jSchException) {
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to authenticate to remote SSH host with username [" + this.userName + "]", (Throwable)jSchException);
                activityContext.setFailureReason(jSchException.getMessage());
                return AttemptStatus.FAILED;
            }
            try {
                if (this.transferType == TransferType.SEND) {
                    try {
                        this.sendFile(session);
                        break block14;
                    }
                    catch (Exception exception) {
                        logger.error(Long.valueOf(activityContext.getJobId()), "failed to send file [" + this.localFile + "]", (Throwable)exception);
                        activityContext.setFailureReason(exception.getMessage());
                        AttemptStatus attemptStatus = AttemptStatus.FAILED;
                        session.disconnect();
                        return attemptStatus;
                    }
                }
                try {
                    this.recieveFile(session);
                }
                catch (Exception exception) {
                    logger.error(Long.valueOf(activityContext.getJobId()), "failed to recieve file [" + this.remoteFile + "]", (Throwable)exception);
                    activityContext.setFailureReason(exception.getMessage());
                    AttemptStatus attemptStatus = AttemptStatus.FAILED;
                    session.disconnect();
                    return attemptStatus;
                }
            }
            finally {
                session.disconnect();
            }
        }
        return AttemptStatus.SUCCESS;
    }

    private void recieveFile(Session session) throws Exception {
        int n;
        FileOutputStream fileOutputStream = null;
        String string = null;
        if (new File(this.localFile).isDirectory()) {
            string = this.localFile + File.separator;
        }
        String string2 = "scp -f " + this.remoteFile;
        Channel channel = session.openChannel("exec");
        ((ChannelExec)channel).setCommand(string2);
        OutputStream outputStream = channel.getOutputStream();
        InputStream inputStream = channel.getInputStream();
        channel.connect();
        byte[] byArray = new byte[1024];
        byArray[0] = 0;
        outputStream.write(byArray, 0, 1);
        outputStream.flush();
        while ((n = SCPActivity.checkAck(inputStream)) == 67) {
            inputStream.read(byArray, 0, 5);
            long l = 0L;
            while (inputStream.read(byArray, 0, 1) >= 0 && byArray[0] != 32) {
                l = l * 10L + (long)(byArray[0] - 48);
            }
            String string3 = null;
            int n2 = 0;
            while (true) {
                inputStream.read(byArray, n2, 1);
                if (byArray[n2] == 10) break;
                ++n2;
            }
            string3 = new String(byArray, 0, n2);
            byArray[0] = 0;
            outputStream.write(byArray, 0, 1);
            outputStream.flush();
            fileOutputStream = new FileOutputStream(string == null ? this.localFile : string + string3);
            do {
                n2 = (long)byArray.length < l ? byArray.length : (int)l;
                if ((n2 = inputStream.read(byArray, 0, n2)) < 0) break;
                fileOutputStream.write(byArray, 0, n2);
            } while ((l -= (long)n2) != 0L);
            fileOutputStream.close();
            fileOutputStream = null;
            if (SCPActivity.checkAck(inputStream) != 0) {
                throw new Exception("checkAck return non zero code");
            }
            byArray[0] = 0;
            outputStream.write(byArray, 0, 1);
            outputStream.flush();
        }
        session.disconnect();
    }

    private void sendFile(Session session) throws Exception {
        int n;
        FileInputStream fileInputStream = null;
        boolean bl = true;
        String string = "scp " + (bl ? "-p" : "") + " -t " + this.remoteFile;
        Channel channel = session.openChannel("exec");
        ((ChannelExec)channel).setCommand(string);
        OutputStream outputStream = channel.getOutputStream();
        InputStream inputStream = channel.getInputStream();
        channel.connect();
        if (SCPActivity.checkAck(inputStream) != 0) {
            throw new Exception("checkAck return non zero code");
        }
        File file = new File(this.localFile);
        if (bl) {
            string = "T " + file.lastModified() / 1000L + " 0";
            string = string + " " + file.lastModified() / 1000L + " 0\n";
            outputStream.write(string.getBytes());
            outputStream.flush();
            if (SCPActivity.checkAck(inputStream) != 0) {
                throw new Exception("checkAck return non zero code");
            }
        }
        long l = file.length();
        string = "C0644 " + l + " ";
        string = this.localFile.lastIndexOf(47) > 0 ? string + this.localFile.substring(this.localFile.lastIndexOf(47) + 1) : string + this.localFile;
        string = string + "\n";
        outputStream.write(string.getBytes());
        outputStream.flush();
        if (SCPActivity.checkAck(inputStream) != 0) {
            throw new Exception("checkAck return non zero code");
        }
        fileInputStream = new FileInputStream(this.localFile);
        byte[] byArray = new byte[1024];
        while ((n = fileInputStream.read(byArray, 0, byArray.length)) > 0) {
            outputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        fileInputStream = null;
        byArray[0] = 0;
        outputStream.write(byArray, 0, 1);
        outputStream.flush();
        if (SCPActivity.checkAck(inputStream) != 0) {
            throw new Exception("checkAck return non zero code");
        }
        outputStream.close();
        channel.disconnect();
    }

    static int checkAck(InputStream inputStream) throws Exception {
        int n = inputStream.read();
        if (n == 0) {
            return n;
        }
        if (n == -1) {
            return n;
        }
        if (n == 1 || n == 2) {
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            do {
                n2 = inputStream.read();
                stringBuffer.append((char)n2);
            } while (n2 != 10);
            throw new Exception("checkAck failed with error code [" + n + "], data [" + stringBuffer.toString() + "]");
        }
        return n;
    }
}

