/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.supplemental.net;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.WorkflowContext;
import commvault.cte.workflow.WorkflowMail;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.db.cs.UMUsers_t;
import commvault.cte.workflow.logger.CTELogger;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import workflow.types.Email;

public class ImageEmailActivity
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ImageEmailActivity.class);
    private static final String REGEX_FILE = "(?i)imageFile:\\{[\\S\\s]*}";
    private static final String REGEX_URL = "(?i)imageUrl:\\{[\\S\\s]*}";
    private static final String CID_IMAGE_TAG = "<img src=\"cid:%s\">";
    @Input(autoLink=false)
    public Email email;
    @Output
    public Boolean emailSent = false;
    @Output
    public String errorMessage;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        Object object;
        Object object22;
        this.emailSent = false;
        this.errorMessage = "";
        if (this.email == null) {
            String string;
            logger.error(Long.valueOf(activityContext.getJobId()), "email configuration is incomplete");
            EvMessageContainer evMessageContainer = new EvMessageContainer("JM_WORKFLOW_FAILED_CONFIGURE_EMAIL");
            activityContext.setFailureReason(evMessageContainer);
            this.errorMessage = string = EventMessage.getInstance().formatMessage(evMessageContainer, 0);
            return AttemptStatus.FAILED;
        }
        List list = WorkflowMail.split((String)this.email.getTo());
        if (list.size() == 0) {
            logger.info("did not find any recipients for email, adding workflow executor [%s]", new Object[]{activityContext.getExecutor()});
            list.add(activityContext.getExecutor());
        }
        if (!this.email.getHtml().booleanValue()) {
            WorkflowMail workflowMail = new WorkflowMail((WorkflowContext)activityContext);
            try {
                workflowMail.send(this.email.getFrom(), list, WorkflowMail.split((String)this.email.getCc()), WorkflowMail.split((String)this.email.getBcc()), this.email.getSubject(), this.email.getBody(), (Collection)WorkflowMail.split((String)String.valueOf(this.email.getAttachments())), this.email.getHtml().booleanValue());
            }
            catch (EvFailureException evFailureException) {
                logger.error(Long.valueOf(activityContext.getJobId()), "error sending email message");
                activityContext.setFailureReason(evFailureException.getMessageContainer());
                this.errorMessage = evFailureException.getMessage();
                return AttemptStatus.FAILED;
            }
            this.emailSent = true;
            return AttemptStatus.SUCCESS;
        }
        final HtmlEmail htmlEmail = new HtmlEmail();
        htmlEmail.setHostName(activityContext.getJobSettings().getSmtpServer());
        htmlEmail.setSmtpPort(activityContext.getJobSettings().getSmtpPort());
        if (activityContext.getJobSettings().isSmtpCredentialsReq()) {
            htmlEmail.setAuthentication(activityContext.getJobSettings().getSmtpUsername(), activityContext.getJobSettings().getSmtpPassword());
        }
        if (activityContext.getJobSettings().isSmtpSSL()) {
            htmlEmail.setSSLOnConnect(true);
        }
        try {
            if (this.email.getFrom() != null && this.email.getFrom().length() > 0) {
                htmlEmail.setFrom(this.email.getFrom());
            } else {
                htmlEmail.setFrom(activityContext.getJobSettings().getSmtpSender());
            }
        }
        catch (EmailException emailException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to set the from address", (Throwable)emailException);
            activityContext.setFailureReason(emailException.getMessage());
            this.errorMessage = emailException.getMessage();
            return AttemptStatus.FAILED;
        }
        for (Object object22 : list) {
            try {
                object = this.findEmailUser((String)object22);
                htmlEmail.addTo((String)object);
            }
            catch (Exception exception) {
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to add to address [" + (String)object22 + "]", (Throwable)exception);
                activityContext.setFailureReason(exception.getMessage());
                this.errorMessage = exception.getMessage();
                return AttemptStatus.FAILED;
            }
        }
        for (Object object22 : WorkflowMail.split((String)this.email.getCc())) {
            try {
                object = this.findEmailUser((String)object22);
                htmlEmail.addCc((String)object);
            }
            catch (Exception exception) {
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to add cc address [" + (String)object22 + "]", (Throwable)exception);
                activityContext.setFailureReason(exception.getMessage());
                this.errorMessage = exception.getMessage();
                return AttemptStatus.FAILED;
            }
        }
        for (Object object22 : WorkflowMail.split((String)this.email.getBcc())) {
            try {
                object = this.findEmailUser((String)object22);
                htmlEmail.addBcc((String)object);
            }
            catch (Exception exception) {
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to add bcc address [" + (String)object22 + "]", (Throwable)exception);
                activityContext.setFailureReason(exception.getMessage());
                this.errorMessage = exception.getMessage();
                return AttemptStatus.FAILED;
            }
        }
        htmlEmail.setSubject(this.email.getSubject());
        for (Object object22 : WorkflowMail.split((String)String.valueOf(this.email.getAttachments()))) {
            try {
                htmlEmail.attach(new File((String)object22));
            }
            catch (EmailException emailException) {
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to add attachment [" + (String)object22 + "]", (Throwable)emailException);
                activityContext.setFailureReason(emailException.getMessage());
                this.errorMessage = emailException.getMessage();
                return AttemptStatus.FAILED;
            }
        }
        Object object3 = this.email.getBody();
        object22 = new PatternHandler(){

            @Override
            public String getCid(String string) throws Exception {
                logger.info("embedding file [%s]", new Object[]{string});
                return htmlEmail.embed(new File(string));
            }
        };
        object = new PatternHandler(){

            @Override
            public String getCid(String string) throws Exception {
                logger.info("embedding url [%s]", new Object[]{string});
                return htmlEmail.embed(new URL(string), string);
            }
        };
        try {
            object3 = this.embedImages((String)object3, REGEX_FILE, (PatternHandler)object22);
        }
        catch (Exception exception) {
            activityContext.setFailureReason(exception.getMessage());
            logger.error("failed to embed images", (Throwable)exception);
            this.errorMessage = exception.getMessage();
            return AttemptStatus.FAILED;
        }
        try {
            object3 = this.embedImages((String)object3, REGEX_URL, (PatternHandler)object);
        }
        catch (Exception exception) {
            activityContext.setFailureReason(exception.getMessage());
            logger.error("failed to embed images", (Throwable)exception);
            this.errorMessage = exception.getMessage();
            return AttemptStatus.FAILED;
        }
        try {
            htmlEmail.setHtmlMsg((String)object3);
        }
        catch (EmailException emailException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to set body html message", (Throwable)emailException);
            activityContext.setFailureReason(emailException.getMessage());
            this.errorMessage = emailException.getMessage();
            return AttemptStatus.FAILED;
        }
        try {
            htmlEmail.setTextMsg("Your email client does not support HTML messages");
        }
        catch (EmailException emailException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to set body text message", (Throwable)emailException);
            activityContext.setFailureReason(emailException.getMessage());
            this.errorMessage = emailException.getMessage();
            return AttemptStatus.FAILED;
        }
        try {
            htmlEmail.send();
        }
        catch (EmailException emailException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to send message, host [" + activityContext.getJobSettings().getSmtpServer() + "], port [" + activityContext.getJobSettings().getSmtpPort() + "]", (Throwable)emailException);
            activityContext.setFailureReason(emailException.getMessage());
            this.errorMessage = emailException.getMessage();
            return AttemptStatus.FAILED;
        }
        this.emailSent = true;
        return AttemptStatus.SUCCESS;
    }

    private String findEmailUser(String string) throws Exception {
        UMUsers_t uMUsers_t = new UMUsers_t();
        String string2 = String.format("login = '%s'", string);
        if (uMUsers_t.fill(string2)) {
            if (uMUsers_t.email.isNull() || uMUsers_t.email.get().length() == 0) {
                throw new Exception("email address for commcell user [" + string + "] is empty");
            }
            return uMUsers_t.email.get();
        }
        return string;
    }

    public String embedImages(String string, String string2, PatternHandler patternHandler) throws Exception {
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string3;
            String string4 = matcher.group();
            String string5 = ImageEmailActivity.getExpression(string4);
            try {
                string3 = patternHandler.getCid(string5);
            }
            catch (Exception exception) {
                throw new Exception("failed to embed image source [" + string5 + "]", exception);
            }
            String string6 = String.format(CID_IMAGE_TAG, string3);
            logger.info("replacing image expression [%s] with cid tag [%s]", new Object[]{string4, string6});
            matcher.appendReplacement(stringBuffer, string6);
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private static String getExpression(String string) {
        return string.substring(string.indexOf("{") + 1, string.lastIndexOf("}"));
    }

    public static interface PatternHandler {
        public String getCid(String var1) throws Exception;
    }
}

