/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.supplemental.net;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.supplemental.io.IOActivity;
import commvault.cte.workflow.supplemental.net.FTPConnection;
import commvault.cte.workflow.supplemental.net.FTPUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.net.ftp.FTPClient;

public class FTPGetActivity
extends IOActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(FTPGetActivity.class);
    @Input
    public String localFile;
    @Input
    public String remoteFile;
    @Input(defaultValue="false")
    public Boolean binaryTransfer;
    @Input(defaultValue="true")
    public Boolean passiveMode;
    @Input
    public FTPConnection connection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttemptStatus executeOperation(ActivityContext activityContext) throws InterruptedException {
        FileOutputStream fileOutputStream;
        FTPClient fTPClient;
        block30: {
            if (this.connection == null) {
                logger.error(Long.valueOf(activityContext.getJobId()), "invalid connection specified");
                activityContext.setFailureReason("invalid connection specified");
                return AttemptStatus.FAILED;
            }
            if (this.binaryTransfer == null) {
                this.binaryTransfer = false;
            }
            if (this.passiveMode == null) {
                this.passiveMode = true;
            }
            fTPClient = FTPUtil.createClient(this.connection);
            try {
                FTPUtil.initClient(fTPClient, this.connection, activityContext.getJobId());
            }
            catch (EvFailureException evFailureException) {
                activityContext.setFailureReason(evFailureException.getMessageContainer());
                AttemptStatus attemptStatus = AttemptStatus.FAILED;
                if (fTPClient.isConnected()) {
                    try {
                        fTPClient.disconnect();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return attemptStatus;
            }
            if (this.binaryTransfer.booleanValue()) {
                fTPClient.setFileType(2);
            } else {
                fTPClient.setFileType(0);
            }
            if (this.passiveMode.booleanValue()) {
                fTPClient.enterLocalPassiveMode();
            } else {
                fTPClient.enterLocalActiveMode();
            }
            fileOutputStream = new FileOutputStream(this.localFile);
            if (fTPClient.retrieveFile(this.remoteFile, (OutputStream)fileOutputStream)) break block30;
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to initiate transfer");
            activityContext.setFailureReason("failed to initiate transfer");
            AttemptStatus attemptStatus = AttemptStatus.FAILED;
            if (fTPClient.isConnected()) {
                try {
                    fTPClient.disconnect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return attemptStatus;
        }
        try {
            try {
                ((OutputStream)fileOutputStream).close();
            }
            catch (Exception exception) {
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to initiate transfer", (Throwable)exception);
                activityContext.setFailureReason(exception.getMessage());
                AttemptStatus attemptStatus = AttemptStatus.FAILED;
                if (fTPClient.isConnected()) {
                    try {
                        fTPClient.disconnect();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return attemptStatus;
            }
        }
        finally {
            if (fTPClient.isConnected()) {
                try {
                    fTPClient.disconnect();
                }
                catch (IOException iOException) {}
            }
        }
        return AttemptStatus.SUCCESS;
    }
}

