/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.supplemental.job;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.WorkflowEngine;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.schema.SchemaManager;
import commvault.cte.workflow.supplemental.job.JobUtil;
import java.util.List;

public class SynchronizeWorkflowActivity
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(SynchronizeWorkflowActivity.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        while (true) {
            SchemaManager schemaManager = null;
            try {
                schemaManager = SchemaManager.newInstance();
            }
            catch (EvFailureException evFailureException) {
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to load schema type system");
                activityContext.setFailureReason(evFailureException.getMessageContainer());
                return AttemptStatus.FAILED;
            }
            try {
                List<Long> list;
                try {
                    list = JobUtil.getRunningInstances(activityContext);
                }
                catch (EvFailureException evFailureException) {
                    activityContext.setFailureReason(evFailureException.getMessageContainer());
                    AttemptStatus attemptStatus = AttemptStatus.FAILED;
                    schemaManager.close();
                    return attemptStatus;
                }
                if (list.size() == 0) {
                    logger.info(Long.valueOf(activityContext.getJobId()), "no other instances of workflow [%s] is running", new Object[]{activityContext.getWorkflowName()});
                    AttemptStatus attemptStatus = AttemptStatus.SUCCESS;
                    return attemptStatus;
                }
            }
            finally {
                schemaManager.close();
            }
            if (activityContext.getStatus() != ProcessStatus.RUNNING) {
                logger.info(Long.valueOf(activityContext.getJobId()), "exiting activity [%s] since it has a status of [%s]", new Object[]{activityContext.getFriendlyName(), activityContext.getStatus()});
                activityContext.repeat(Integer.valueOf(0));
                return AttemptStatus.SUCCESS;
            }
            if (!WorkflowEngine.getInstance().isRunning()) {
                logger.info(Long.valueOf(activityContext.getJobId()), "exiting activity [%s] since the workflow engine is shutting down", new Object[]{activityContext.getFriendlyName()});
                activityContext.repeat(Integer.valueOf(0));
                return AttemptStatus.SUCCESS;
            }
            Thread.sleep(60000L);
        }
    }
}

