/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.supplemental.io;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.supplemental.io.IOActivity;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class MakeDirectoryActivity
extends IOActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(MakeDirectoryActivity.class);
    @Input
    public String directory;

    @Override
    public AttemptStatus executeOperation(ActivityContext activityContext) throws InterruptedException {
        File file = new File(this.directory);
        try {
            FileUtils.forceMkdir((File)file);
        }
        catch (IOException iOException) {
            logger.error("failed to make directory [" + this.directory + "]", (Throwable)iOException);
            activityContext.setFailureReason(iOException.getMessage());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

