/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.supplemental.io;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.supplemental.io.IOActivity;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class ListFilesActivity
extends IOActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ListFilesActivity.class);
    @Input
    public String directory;
    @Input(documentation="comma delimetted list of extensions (java,xml)")
    public String extensions;
    @Input(defaultValue="false")
    public Boolean searchSubFolders;
    @Output
    public List<String> files;

    @Override
    public AttemptStatus executeOperation(ActivityContext activityContext) throws InterruptedException {
        File file = new File(this.directory);
        String[] stringArray = null;
        if (this.extensions != null) {
            stringArray = this.extensions.split(",");
        }
        if (this.searchSubFolders == null) {
            this.searchSubFolders = false;
        }
        this.files = new ArrayList<String>();
        Collection collection = FileUtils.listFiles((File)file, (String[])stringArray, (boolean)this.searchSubFolders);
        for (File file2 : collection) {
            this.files.add(file2.getAbsolutePath());
        }
        return AttemptStatus.SUCCESS;
    }
}

