/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.supplemental.io;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.supplemental.io.IOActivity;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.FileUtils;

public class CopyURLActivity
extends IOActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CopyURLActivity.class);
    @Input
    public String url;
    @Input
    public String localFile;

    @Override
    public AttemptStatus executeOperation(ActivityContext activityContext) throws InterruptedException {
        URL uRL;
        try {
            uRL = new URL(this.url);
        }
        catch (MalformedURLException malformedURLException) {
            logger.error("invalid url specified [" + this.url + "]", (Throwable)malformedURLException);
            activityContext.setFailureReason(malformedURLException.getMessage());
            return AttemptStatus.FAILED;
        }
        File file = new File(this.localFile);
        try {
            FileUtils.copyURLToFile((URL)uRL, (File)file);
        }
        catch (IOException iOException) {
            logger.error("error copying from url [" + this.url + "] to local file [" + this.localFile + "]", (Throwable)iOException);
            activityContext.setFailureReason(iOException.getMessage());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

