/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.supplemental.io;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.supplemental.io.IOActivity;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class CopyFileActivity
extends IOActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CopyFileActivity.class);
    @Input
    public String sourceFile;
    @Input
    public String destination;
    @Input(defaultValue="false")
    public Boolean destinationIsFile;
    @Input(defaultValue="false")
    public Boolean preserveFileDate;

    @Override
    public AttemptStatus executeOperation(ActivityContext activityContext) throws InterruptedException {
        File file = new File(this.sourceFile);
        File file2 = new File(this.destination);
        if (this.destinationIsFile == null) {
            this.destinationIsFile = false;
        }
        if (this.preserveFileDate == null) {
            this.preserveFileDate = false;
        }
        try {
            if (this.destinationIsFile.booleanValue()) {
                FileUtils.copyFile((File)file, (File)file2, (boolean)this.preserveFileDate);
            } else {
                FileUtils.copyFileToDirectory((File)file, (File)file2, (boolean)this.preserveFileDate);
            }
        }
        catch (IOException iOException) {
            logger.error("error copying file [" + this.sourceFile + "] to destination [" + this.destination + "]", (Throwable)iOException);
            activityContext.setFailureReason(iOException.getMessage());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

