/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.supplemental.io;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.supplemental.io.IOActivity;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;

public class CopyDirectoryActivity
extends IOActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CopyDirectoryActivity.class);
    @Input
    public String sourceDirectory;
    @Input
    public String destinationDirectory;
    @Input
    public String filter;
    @Input(defaultValue="false")
    public Boolean preserveFileDate;

    @Override
    public AttemptStatus executeOperation(ActivityContext activityContext) throws InterruptedException {
        File file = new File(this.sourceDirectory);
        File file2 = new File(this.destinationDirectory);
        if (this.preserveFileDate == null) {
            this.preserveFileDate = false;
        }
        try {
            if (this.filter == null || this.filter.length() == 0) {
                FileUtils.copyDirectory((File)file, (File)file2, (boolean)this.preserveFileDate);
            } else {
                IOFileFilter iOFileFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFileFilter.FILE, FileFilterUtils.suffixFileFilter((String)this.filter)});
                FileUtils.copyDirectory((File)file, (File)file2, (FileFilter)iOFileFilter, (boolean)this.preserveFileDate);
            }
        }
        catch (IOException iOException) {
            logger.error("error copying directory [" + this.sourceDirectory + "] to destination [" + this.destinationDirectory + "] with filter [" + this.filter + "]", (Throwable)iOException);
            activityContext.setFailureReason(iOException.getMessage());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

