--@querytype    CSV

if EXISTS (select 1 from GXGlobalParam where name = 'enableFeatureTrackingFramework' and CAST(value AS VARCHAR(32)) = '1')
begin
	/* 
	**********************
	*  1. Initialization *
	**********************
	*/
	SET NOCOUNT ON
	SET QUOTED_IDENTIFIER ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

	IF OBJECT_ID('tempdb..#AToZFeatureDetails') IS NOT NULL
		DROP TABLE #AToZFeatureDetails
	CREATE TABLE #AToZFeatureDetails
	(
		AToZFeatureId INT NOT NULL,
		AttrName NVARCHAR(512),
		AttrType NVARCHAR(512),
		AttrVal NVARCHAR(MAX),
		CollectionTime datetime
	)

	IF OBJECT_ID('tempdb..#encodeTableIntoAtoZ') IS NOT NULL
		DROP PROCEDURE #encodeTableIntoAtoZ
	DECLARE @sqlCreateEncode NVARCHAR(MAX) = 'create procedure #encodeTableIntoAtoZ
	@tableName    varchar(max),
	@resultStr			varchar(max) output
	as
	declare @queryTbl varchar(max) = ''
	declare @resultXml varchar(max) = ''''''''
	declare @FeatureId int = 254
	DECLARE resultCur CURSOR FOR
	SELECT * from '' + @tableName

	declare @fetchList varchar(max) = ''''
	declare @columnList varchar(max) = ''''
	declare @COLUMN_NAME varchar(max) = ''''
	declare @DATA_TYPE varchar(max) = ''''
	declare @declareList varchar(max) = ''''

	DECLARE resultCur CURSOR FOR
	SELECT cols.name as COLUMN_NAME,ty.name as DATA_TYPE
	FROM tempdb.sys.columns cols join sys.types ty on cols.system_type_id = ty.system_type_id 
	WHERE [object_id] = OBJECT_ID(N''tempdb..'' + @tableName)

	OPEN resultCur
	FETCH FROM resultCur INTO @COLUMN_NAME, @DATA_TYPE
	WHILE @@FETCH_STATUS = 0
	BEGIN
		if @DATA_TYPE = ''sysname''
		begin
			FETCH FROM resultCur INTO @COLUMN_NAME, @DATA_TYPE
			continue
		end
		if @DATA_TYPE = ''varchar''
			set @DATA_TYPE = ''varchar(max)''
		if @DATA_TYPE = ''nvarchar''
			set @DATA_TYPE = ''nvarchar(max)''
			
		set @fetchList = @fetchList + '',@'' + @COLUMN_NAME

		set @declareList = @declareList + ''
		declare @'' + @COLUMN_NAME + '' '' + @DATA_TYPE

		set @columnList = @columnList + ''
		set @recordXml = (SELECT @FeatureId AS ''''@AToZFeatureId'''',
				'''''' + @tableName + ''.'' + @COLUMN_NAME + ''.''''+cast (@RowCounter as varchar(max)) AS ''''@AttrName'''',
				'''''' + @DATA_TYPE + '''''' AS ''''@AttrType'''',
				@'' + @COLUMN_NAME + '' AS ''''@AttrVal'''',
				getdate() AS ''''@CollectionTime''''
		FOR XML PATH(''''result''''))
			set @resultXml = @resultXml + cast(@recordXml as varchar(max))
			
		''
		FETCH FROM resultCur INTO @COLUMN_NAME, @DATA_TYPE
	END

	if Len(@fetchList) > 0
		set @fetchList = SUBSTRING(@fetchList, 2, Len(@fetchList) - 1)

	CLOSE resultCur
	DEALLOCATE resultCur

	declare @sqlLoop varchar(max) = ''
	declare @RowCounter int = 1
	OPEN resultCur
	FETCH FROM resultCur INTO '' + @fetchList + ''
	WHILE @@FETCH_STATUS = 0
	BEGIN
		declare @recordXml xml'' + @columnList + ''
		set @RowCounter = @RowCounter + 1
		FETCH FROM resultCur INTO '' + @fetchList + ''
	END
	CLOSE resultCur
	DEALLOCATE resultCur
	select @resultStr = @resultXml
	''

	declare @command nvarchar(max) = @declareList + @queryTbl + @sqlLoop

	exec sp_executeSQl @command, N''@resultStr varchar(max) output'', @resultStr output'
	exec sp_executeSQl @sqlCreateEncode


	/*
	**********************
	*  2. Collection     *
	**********************
	*/

		declare @XmlResult xml

		DECLARE @diff INT = DATEDIFF(SECOND, GETUTCDATE(), GETDATE())
		DECLARE @tempCostCategory XML 
		DECLARE @tempCostCategory1 NVARCHAR(MAX) 
		DECLARE @csReleaseId INT = (SELECT releaseId FROM APP_Client WITH (NOLOCK) WHERE id = 2)

		CREATE TABLE #LibraryMA (LibraryId INT, MediaAgent NVARCHAR(256))
		CREATE TABLE #StoragePoolMA (StoragePoolId INT, LibraryId INT, MediaAgentId INT, MediaAgent NVARCHAR(256))
		CREATE TABLE #HyperScaleMediaSide (ApplianceType INT, StoragePoolId INT, LibraryId INT, MediaSideId INT)
		CREATE TABLE #HyperScaleUsage (ApplianceType INT, NumStoragePools INT, NumMediaAgents INT, 
			TotalSpaceMB BIGINT, FreeSpaceMB BIGINT, DataWrittenMB BIGINT, NumClients INT, NumVMs INT)

		CREATE TABLE #StoragePoolRaw (
			StoragePoolId     integer,
			StoragePoolName   nvarchar(255),
			StoragePoolType   integer,
			SIDBStoreId       integer,
			ClientGroupName   nvarchar(512),
			Libraries         varchar(1024),
			LibraryType       integer,
			NumMediaAgents    integer,
			TotalControllers  integer,
			ActiveControllers integer,
			LibOfflineReason  integer,
			MPOfflineReason   integer,
			MAOfflineReason   integer,
			MountPathType     integer,
			StatusCode        integer,
			DeviceTypeId      integer,
			LibrarySubType	  integer
		)

		IF @csReleaseId >= 16
		BEGIN
			DECLARE @procRevision NVARCHAR(20) = ''
			SELECT	@procRevision = revision FROM GxDBVersions WITH(NOLOCK) WHERE name = 'MMGetStoragePools'

			DECLARE	@n INT = 1, @p INT = 1, @q INT = 1
			DECLARE @r VARCHAR(20) = '', @s VARCHAR(20) = ''

			IF @procRevision LIKE 'v%'
			BEGIN
				SET @procRevision = @procRevision+'.'
				SET @q = CHARINDEX('.', @procRevision, @p+1)
				WHILE @q > 0
				BEGIN
					SET @s = SUBSTRING(@procRevision, @p+1, @q-@p-1)
					IF  @n <= 4
						SET @r += (CASE @q-@p-1 WHEN 1 THEN '000' WHEN 2 THEN '00' WHEN 3 THEN '0' ELSE '' END + @s)
					ELSE
						SET @r += (CASE @q-@p-1 WHEN 1 THEN '0' ELSE '' END + @s)
					
					SET @n += 1
					SET @p = @q
					SET @q = CHARINDEX('.', @procRevision, @p+1)
				END
				SET @procRevision = @r
			END

			IF	ISNUMERIC(@procRevision) = 0
				SET @procRevision = '9223372036854775807'
				
			DECLARE @procRevNum BIGINT = CAST(@procRevision AS BIGINT)

			IF  @procRevNum < 00010001000200160000
				ALTER TABLE #StoragePoolRaw DROP COLUMN LibrarySubType
	
			IF  @procRevNum < 00010001000200140000
				ALTER TABLE #StoragePoolRaw DROP COLUMN DeviceTypeId

			IF	@procRevNum < 00010001000200080601
				ALTER TABLE #StoragePoolRaw DROP COLUMN StatusCode
			
			IF	@procRevNum < 00010001000200070000
				ALTER TABLE #StoragePoolRaw DROP COLUMN MountPathType

			INSERT INTO #StoragePoolRaw
			EXEC MMGetStoragePools

			INSERT	INTO #StoragePoolMA
			SELECT	SPL.StoragePoolId, MPL.LibraryId, CL.id, CL.name
			FROM	#StoragePoolRaw SPL
					INNER JOIN MMMasterPool MPL WITH (NOLOCK) ON MPL.LibraryId IN (SELECT * FROM dbo.SplitIDs(SPL.Libraries))
					INNER JOIN MMDrivePool DPL WITH (NOLOCK) ON MPL.MasterPoolId = DPL.MasterPoolId
					INNER JOIN APP_Client CL WITH (NOLOCK) ON DPL.ClientId = CL.id
			ORDER BY SPL.StoragePoolId, CL.name

			INSERT	INTO #HyperScaleMediaSide
			SELECT	DISTINCT AT.ApplianceType, MA.StoragePoolId, MA.LibraryId, MPT.MediaSideId
			FROM	MMMountPath MPT WITH (NOLOCK)
					INNER JOIN #StoragePoolMA MA ON MPT.LibraryId = MA.LibraryId
					INNER JOIN (
						SELECT	EntityId, intVal AS ApplianceType 
						FROM	MMEntityProp WITH (NOLOCK)
						WHERE	propertyName = 'MediaAgentApplianceType' AND EntityType = 10
						) AT ON MA.MediaAgentId = AT.EntityId

			INSERT	INTO #HyperScaleUsage
			SELECT	HS.ApplianceType, 0, 0, SUM(MS.TotalSpaceMB), SUM(MS.FreeBytesMB), SUM(ISNULL(W.DataWrittenMB, 0)), 0, 0
			FROM	MMMediaSide MS WITH (NOLOCK)
					INNER JOIN #HyperScaleMediaSide HS ON MS.MediaSideId = HS.MediaSideId
					LEFT OUTER JOIN (
						SELECT	MediaSideId, SUM(CAST(PhysicalBytesMB AS BIGINT)) AS DataWrittenMB
						FROM	MMVolume WITH (NOLOCK)
						WHERE	SiloStatus <> 3
						GROUP BY MediaSideId
						) W ON HS.MediaSideId = W.MediaSideId
			GROUP BY HS.ApplianceType

			UPDATE	T SET NumStoragePools = S.NumStoragePools, NumMediaAgents = S.NumMediaAgents
			FROM	#HyperScaleUsage T
					INNER JOIN (
						SELECT	HS.ApplianceType, COUNT(DISTINCT HS.StoragePoolId) AS NumStoragePools, COUNT(DISTINCT MA.MediaAgentId) AS NumMediaAgents
						FROM	#HyperScaleMediaSide HS
								INNER JOIN #StoragePoolMA MA ON HS.StoragePoolId = MA.StoragePoolId
						GROUP BY HS.ApplianceType
					) S ON T.ApplianceType = S.ApplianceType

			UPDATE	T SET NumClients = S.NumClients
			FROM	#HyperScaleUsage T
					INNER JOIN (
						SELECT	HS.ApplianceType, COUNT(DISTINCT A.clientId) AS NumClients
						FROM	APP_Application A WITH (NOLOCK)
								INNER JOIN archFile AF WITH (NOLOCK) ON A.id = AF.appId
								INNER JOIN archChunkMapping ACM WITH (NOLOCK) ON AF.id = ACM.archFileId AND AF.commCellId = ACM.commCellId
								INNER JOIN archChunk AC WITH (NOLOCK) ON ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId
								INNER JOIN MMVolume V WITH (NOLOCK) ON AC.volumeId = V.VolumeId
								INNER JOIN #HyperScaleMediaSide HS ON V.MediaSideId = HS.MediaSideId
						WHERE	A.subclientStatus&(2|4) = 0 AND A.appTypeId <> 106 AND ACM.flags&256 = 0
						GROUP BY HS.ApplianceType
					) S ON T.ApplianceType = S.ApplianceType

			UPDATE	T SET NumVMs = S.NumVMs
			FROM	#HyperScaleUsage T
					INNER JOIN (
						SELECT	HS.ApplianceType, COUNT(DISTINCT VM.VMclientId) AS NumVMs
						FROM	APP_VMProp VM WITH (NOLOCK)
								INNER JOIN archChunkMapping ACM WITH (NOLOCK) ON VM.jobId = ACM.jobId AND VM.commCellId = ACM.commCellId
								INNER JOIN archChunk AC WITH (NOLOCK) ON ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId
								INNER JOIN MMVolume V WITH (NOLOCK) ON AC.volumeId = V.VolumeId
								INNER JOIN #HyperScaleMediaSide HS ON V.MediaSideId = HS.MediaSideId
						WHERE	ACM.flags&256 = 0
						GROUP BY HS.ApplianceType
					) S ON T.ApplianceType = S.ApplianceType
		END

		INSERT	INTO #LibraryMA
		SELECT	MPL.LibraryId, CL.name
		FROM	MMMasterPool MPL WITH (NOLOCK)
				INNER JOIN MMDrivePool DPL WITH (NOLOCK) ON MPL.MasterPoolId = DPL.MasterPoolId
				INNER JOIN APP_Client CL WITH (NOLOCK) ON DPL.ClientId = CL.id
		ORDER BY MPL.LibraryId, CL.name

		IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[BLCostCategory]') and OBJECTPROPERTY(id, N'IsTable') = 1)
		BEGIN 
			SET @tempCostCategory = (
			SELECT L.LibraryId AS '@LibraryId',
					L.AliasName AS '@LibraryName', 
					D.DriveID AS '@DriveId',
					D.AliasName AS '@DriveName',
					1 - (DriveSoftState & DriveEnabled & (1 - CleaningRequired) & (1 - DriveBroken)) AS '@Offline',
					D.OfflineReason AS '@OfflineReason',
					CASE WHEN D.OfflineTimeStamp > 0 THEN D.OfflineTimeStamp + @diff ELSE 0 END AS '@OfflineTimeStamp',
					DT.RatedThroughputInMBPerSec AS '@RatedThroughputMbps',
					D.DriveVendor AS '@Manufacturer', 
					D.DriveModel AS '@Model', 
					DT.DriveTypeName AS '@Type',
					D.SerialNumber AS '@SerialNumber',
					D.FirmwareRevision AS '@FirmwareRevision', 
					 CASE WHEN DT.CostCategoryId > 0 THEN C.DisplayName ELSE 'Not Defined' END AS '@CostCategory'
			FROM    MMDrive D WITH (NOLOCK)
					INNER JOIN MMDriveType DT WITH (NOLOCK) ON D.DriveTypeId = DT.DriveTypeId
					INNER JOIN (
						SELECT	DISTINCT DC.DriveID, MP.LibraryId
						FROM	MMDriveController DC WITH (NOLOCK)
							INNER JOIN MMDrivePool DP WITH (NOLOCK) ON DC.DrivePoolID = DP.DrivePoolID
							INNER JOIN MMMasterPool MP WITH (NOLOCK) ON DP.MasterPoolId = MP.MasterPoolID
						) DL ON D.DriveID = DL.DriveID
					INNER JOIN MMLibrary L WITH (NOLOCK) ON L.LibraryId = DL.LibraryId
					INNER JOIN BLCostCategory C WITH (NOLOCK) ON DT.CostCategoryId = C.CostCategoryID
			WHERE   D.DriveTypeId <> 10001 AND L.LibraryId > 0 AND L.LibraryTypeId != 8
			ORDER BY L.LibraryId, D.DriveID
			FOR XML PATH('Drive'), TYPE)    

			SET @tempCostCategory1 = (SELECT DisplayName FROM BLCostCategory
					WHERE CostCategoryID IN (SELECT CostCategoryID FROM MMMediaType WITH (NOLOCK) WHERE MediaTypeId = 10001))
		END
		ELSE
		BEGIN
			SET @tempCostCategory = (
			SELECT  L.LibraryId AS '@LibraryId',
					L.AliasName AS '@LibraryName', 
					D.DriveID AS '@DriveId',
					D.AliasName AS '@DriveName',
					1 - (DriveSoftState & DriveEnabled & (1 - CleaningRequired) & (1 - DriveBroken)) AS '@Offline',
					D.OfflineReason AS '@OfflineReason',
					CASE WHEN D.OfflineTimeStamp > 0 THEN D.OfflineTimeStamp + @diff ELSE 0 END AS '@OfflineTimeStamp',
					DT.RatedThroughputInMBPerSec AS '@RatedThroughputMbps',
					D.DriveVendor AS '@Manufacturer', 
					D.DriveModel AS '@Model', 
					DT.DriveTypeName AS '@Type',
					D.SerialNumber AS '@SerialNumber',
					D.FirmwareRevision AS '@FirmwareRevision', 
					'Not Defined' AS '@CostCategory'
			FROM    MMDrive D WITH (NOLOCK)
					INNER JOIN MMDriveType DT WITH (NOLOCK) ON D.DriveTypeId = DT.DriveTypeId
					INNER JOIN (
						SELECT	DISTINCT DC.DriveID, MP.LibraryId
						FROM	MMDriveController DC WITH (NOLOCK)
							INNER JOIN MMDrivePool DP WITH (NOLOCK) ON DC.DrivePoolID = DP.DrivePoolID
							INNER JOIN MMMasterPool MP WITH (NOLOCK) ON DP.MasterPoolId = MP.MasterPoolID
						) DL ON D.DriveID = DL.DriveID
					INNER JOIN MMLibrary L WITH (NOLOCK) ON L.LibraryId = DL.LibraryId
			WHERE   D.DriveTypeId <> 10001 AND L.LibraryId > 0 AND L.LibraryTypeId != 8
			ORDER BY L.LibraryId, D.DriveID
			FOR XML PATH('Drive'), TYPE)

			SET @tempCostCategory1 = 'Not Defined'
		END

		CREATE TABLE #MediaAgent (MAClientId INT, 
		MediaAgentName NVARCHAR(256), 
		ApplianceType INT, 
			Offline INT, 
			OfflineReason INT, 
			OfflineTimeStamp INT, 
			OSName varchar(256), 
			ReleaseVersion VARCHAR(32), 
			DataWrittenLastWeek BIGINT)
		insert into #MediaAgent
			SELECT MA.ClientId AS '@MAClientId',
					CL.name AS '@MediaAgentName', 
					ISNULL(T.ApplianceType, 0) AS '@ApplianceType',
					1 - (MmHostSoftState & MmHostEnabled) AS '@Offline',
					MA.OfflineReason AS '@OfflineReason',
					CASE WHEN MA.OfflineTimeStamp > 0 THEN MA.OfflineTimeStamp + @diff ELSE 0 END AS '@OfflineTimeStamp',
					dbo.GetClientOSName(CL.id,NULL) AS '@OSName',
					R.release + ' ' + ISNULL(V.Version, '') AS '@ReleaseVersion',
					ISNULL(W.DataWrittenLastWeek, 0) AS '@DataWrittenLastWeek'
			FROM    MMHost MA WITH (NOLOCK)
					INNER JOIN APP_Client CL WITH (NOLOCK) ON CL.id = MA.ClientId AND CL.id > 1
					INNER JOIN simAllGalaxyRel R WITH (NOLOCK) ON R.id = CL.releaseId 
					LEFT OUTER JOIN (
						SELECT ClientID, 
							  (CASE WHEN HighestSP > 0 THEN 'SP' + CAST(HighestSP AS VARCHAR(20)) ELSE '' END 
							  +CASE WHEN SpMinorVersion > 0 THEN CHAR(96 + SpMinorVersion) ELSE '' END) AS Version 
						FROM    simInstalledPackages WITH (NOLOCK)
						WHERE   simPackageID IN (SELECT id FROM simPackage WITH (NOLOCK) WHERE Name = 'MediaAgent')
						) V ON V.ClientId = MA.ClientId
					LEFT OUTER JOIN (
						SELECT  ClientId, SUM(DataWritten) AS DataWrittenLastWeek
						FROM    MMDriveHistory WITH (NOLOCK)
						WHERE   HistoryType = 1
							AND TimeStart > DATEADD(DAY, -7, GETUTCDATE())
						GROUP BY ClientId
						) W ON MA.ClientId = W.ClientId
					 LEFT OUTER JOIN (
						SELECT  EntityId, intVal AS ApplianceType
						FROM    MMEntityProp WITH (NOLOCK)
						WHERE   propertyName = 'MediaAgentApplianceType' AND entityType = 10
						) T ON MA.ClientId = T.EntityId

		CREATE TABLE #Library (LibraryId INT, LibraryName NVARCHAR(128), LibraryTypeId INT, Offline INT, OfflineReason INT, OfflineTimeStamp INT, DataWrittenLastWeek BIGINT, FreeSpaceMB BIGINT, LowWaterMark BIGINT, ScratchPoolsBelowLWM INT, SpareInLibrary INT, SpareTotal INT, Manufacturer varchar(16), Model varchar(32), SerialNumber varchar(32), FirmwareRevision varchar(32), Slots INT, EmptySlots INT, Hidden INT, LibraryInstallTime INT, NumMediaAgents INT, MediaAgents NVARCHAR(1024))
		insert into #Library
			SELECT L.LibraryId AS '@LibraryId',
					L.AliasName AS '@LibraryName',
					CASE WHEN CL.LibraryId IS NULL THEN L.LibraryTypeId ELSE -3 END AS '@LibraryTypeId',
					1 - (L.LibrarySoftState & L.LibraryEnabled & (1 - L.LibraryBroken) & LC.OnLine) AS '@Offline',
					L.LibraryStatusReason AS '@OfflineReason',
					CASE WHEN L.OfflineTimeStamp > 0 THEN L.OfflineTimeStamp + @diff ELSE 0 END AS '@OfflineTimeStamp',
					ISNULL(W.DataWrittenLastWeek, 0) AS '@DataWrittenLastWeek',
					ISNULL(F.FreeBytesMB, -1) AS '@FreeSpaceMB',
					L.LowWaterMarkMB AS '@LowWaterMark',
					ISNULL(SG.ScratchPoolsBelowLWM, 0) AS '@ScratchPoolsBelowLWM',
					ISNULL(S.SpareInLibrary, 0) AS '@SpareInLibrary',
					ISNULL(S.SpareTotal, 0) AS '@SpareTotal',
					L.LibraryVendor AS '@Manufacturer', 
					L.LibraryModel AS '@Model', 
					L.SerialNumber AS '@SerialNumber',
					L.FirmwareRevision AS '@FirmwareRevision',
					ISNULL(TS.Slots, 0) AS '@Slots',
					ISNULL(TS.Slots, 0) - ISNULL(TS.OccupiedSlots, 0) AS '@EmptySlots',
					CASE WHEN (L.ExtendedAttributes & 33554432) /* MMS2_HIDE_LIBRARY*/ = 0 THEN 0 ELSE 1 END AS '@Hidden',
					L.LibraryInstallTime AS '@LibraryInstallTime',
					ISNULL(NM.NumMediaAgents, 0) AS '@NumMediaAgents',
					LTRIM(STUFF((SELECT ', ' + CONVERT(VARCHAR(256), LM.MediaAgent) FROM #LibraryMA LM 
							WHERE LM.LibraryId = L.LibraryId FOR XML PATH ('')), 1, 1, '')) AS '@MediaAgents'
			FROM    MMLibrary L WITH (NOLOCK)
					INNER JOIN (
						SELECT  LibraryId, MAX(LibraryControllerSoftState & LibraryControllerEnabled & LibraryControllerActive) AS OnLine
						FROM    MMLibraryController WITH (NOLOCK)
						GROUP BY LibraryId
						) LC ON L.LibraryId = LC.LibraryId
					LEFT OUTER JOIN (
						SELECT  DISTINCT LibraryId
						FROM    MMMountPath WITH (NOLOCK)
						WHERE   MountPathTypeId = 7 AND MountPathName <> 'CVDiskFolder'
						GROUP BY LibraryId
						) CL ON L.LibraryId = CL.LibraryId
					LEFT OUTER JOIN (
						SELECT  LibraryId, COUNT(SpareGroupId) AS ScratchPoolsBelowLWM
						FROM    MMSpareGroup WITH (NOLOCK)
						WHERE   SpareGroupType IN (1, 2) AND IsLowWaterMark > 0
						GROUP BY LibraryId
						) SG ON L.LibraryId =  SG.LibraryId
					LEFT OUTER JOIN (
						SELECT  M.LibraryId, SUM(CAST(MS.FreeBytesMB AS BIGINT)) AS FreeBytesMB
						FROM    MMMediaSide MS WITH (NOLOCK)
								INNER JOIN MMMedia M WITH (NOLOCK) ON MS.MediaId = M.MediaId
								LEFT OUTER JOIN (
									SELECT  MediaSideId FROM MMVolume WITH (NOLOCK) 
									WHERE VolumeFlags IN (1, 5, 7) AND RecordingFormatId <> 10001
									) V ON MS.MediaSideId = V.MediaSideId
						WHERE   (M.MediaTypeId = 10001 OR V.MediaSideId IS NOT NULL)
						GROUP BY M.LibraryId
						) F ON L.LibraryId = F.LibraryId
					LEFT OUTER JOIN (
						SELECT  MP.LibraryID, SUM(DH.DataWritten) AS DataWrittenLastWeek
						FROM    MMDriveHistory DH WITH (NOLOCK)
								INNER JOIN MMDrive D WITH (NOLOCK) ON DH.DriveID = D.DriveID
								INNER JOIN MMMasterPool MP WITH (NOLOCK) ON D.MasterPoolID = MP.MasterPoolId
						WHERE   DH.HistoryType = 1
							AND DH.TimeStart > DATEADD(DAY, -7, GETUTCDATE())
						GROUP BY MP.LibraryID
						) W ON L.LibraryID = W.LibraryId
					LEFT OUTER JOIN (
						SELECT  LibraryId, COUNT(*) AS SpareTotal, SUM(CASE WHEN MediaLocation IN (1, 2) THEN 1 ELSE 0 END) AS SpareInLibrary
						FROM    MMMedia WITH (NOLOCK)
						WHERE   IsInMediaGroup = 0 
							AND SpareGroupId IN (SELECT SpareGroupId FROM MMSpareGroup WITH (NOLOCK) WHERE SpareGroupType IN (1, 2))
						GROUP BY LibraryId
						) S ON L.LibraryID = S.LibraryId
					LEFT OUTER JOIN (           
						SELECT  B.LibraryId, COUNT(*) AS Slots, SUM(IsOccupied) AS OccupiedSlots
						FROM    MMSlot SL WITH (NOLOCK) INNER JOIN MMBay B WITH (NOLOCK) ON SL.BayId = B.BayId
						WHERE   SL.SlotType = 1
						GROUP BY B.LibraryId
						) TS ON L.LibraryId = TS.LibraryId
					LEFT OUTER JOIN (
						SELECT	LibraryId, COUNT(*) AS NumMediaAgents
						FROM	#LibraryMA
						GROUP BY LibraryId
						) NM ON L.LibraryId = NM.LibraryId
			WHERE   L.LibraryId > 0 AND L.LibraryTypeId != 8

		CREATE TABLE #LibraryController (MAClientId int,
		LibraryId int, 
		ControllerId int, 
			ControllerName varchar(144), 
			Active int, 
			Enabled int, 
			SCSIAddress varchar(32))
		insert into #LibraryController
			SELECT LC.ClientId AS '@MAClientId',
					LC.LibraryId AS '@LibraryId',
					LC.LibraryControllerId AS '@ControllerId',
					LC.LibraryControllerName AS '@ControllerName',
					LC.LibraryControllerActive AS '@Active',
					LC.LibraryControllerEnabled AS '@Enabled',
					LC.SCSIId AS '@SCSIAddress'
			FROM    MMLibraryController LC WITH (NOLOCK)
					INNER JOIN MMLibrary L WITH (NOLOCK) ON L.LibraryId = LC.LibraryId
			WHERE   L.LibraryTypeId NOT IN (3, 8)

		CREATE TABLE #MountPath (LibraryId INT, 
		LibraryName NVARCHAR(128), 
		MountPathId INT, 
			MountPathName NVARCHAR(1024), 
			Offline INT, 
			OfflineReason INT, 
			OfflineTimeStamp INT, 
			CostCategory NVARCHAR(256), 
			TotalSpaceMB BIGINT, 
			FreeSpaceMB BIGINT, 
			ReservedSpaceMB BIGINT, 
			DataWrittenMB BIGINT)
		insert into #MountPath
			SELECT L.LibraryId AS '@LibraryId',
					L.AliasName AS '@LibraryName',
					MP.MountPathId AS '@MountPathId',
					CASE 
						WHEN MP.MountPathTypeId = 1
						THEN ISNULL((SELECT TOP 1 A.FriendlyName 
									FROM MMCenteraInfo A WITH (NOLOCK)
									INNER JOIN MMMountPathToStorageDevice B WITH (NOLOCK) ON A.CenteraId = B.CenteraId 
									WHERE B.MountPathId = MP.MountPathId), 'Unavailable')
						WHEN MP.MountPathTypeId IN (4, 5, 7) AND S.MountPathId IS NOT NULL
						THEN S.Folder
						ELSE MP.MountPathName
					END AS '@MountPathName',
					((1 - MP.IsEnabled) | MP.IsOffline | T.Offline) AS '@Offline',
					CASE WHEN MP.IsEnabled = 0 THEN 2 WHEN T.Offline = 1 THEN 4 ELSE MP.OfflineReason END AS '@OfflineReason',
					CASE WHEN MP.OfflineTimeStamp > 0 THEN MP.OfflineTimeStamp + @diff ELSE 0 END AS '@OfflineTimeStamp',
					@tempCostCategory1 AS '@CostCategory',
					MS.TotalSpaceMB AS '@TotalSpaceMB',
					MS.FreeBytesMB AS '@FreeSpaceMB',
					MP.MagneticSpaceRsrvInMB AS '@ReservedSpaceMB',
					ISNULL(W.DataWrittenMB, 0) AS '@DataWrittenMB'
			FROM    MMMountPath MP WITH (NOLOCK)
					INNER JOIN (
						SELECT  a.MountPathId, 
							MAX((1-b.DeviceControllerEnabled) | (1-b.DeviceAccessible) | (1-c.DeviceEnabled) | c.DeviceBroken) AS Offline
						FROM    MMMountPathToStorageDevice a WITH (NOLOCK)
								INNER JOIN (
									SELECT	DeviceId, MAX(DeviceControllerEnabled) AS DeviceControllerEnabled, MAX(DeviceAccessible) AS DeviceAccessible
									FROM	MMDeviceController  WITH (NOLOCK)
									GROUP BY DeviceId
									) b  ON a.DeviceId = b.DeviceId
								INNER JOIN MMDevice c WITH (NOLOCK) ON b.DeviceId = c.DeviceId
						WHERE   a.DeviceId = b.DeviceId
						GROUP BY a.MountPathId
					) T ON MP.MountPathId = T.MountPathId
					INNER JOIN MMMediaSide MS WITH (NOLOCK) ON MP.MediaSideId = MS.MediaSideId
					LEFT OUTER JOIN (
						SELECT  c.MountPathId, DC.Folder
						FROM    (SELECT a.MountPathId, a.DeviceId
								FROM    MMMountPathToStorageDevice a WITH (NOLOCK),
										MMDeviceController b WITH (NOLOCK)
								WHERE   a.DeviceId = b.DeviceId
								GROUP BY a.MountPathId, a.DeviceId
								HAVING COUNT(b.DeviceControllerId) = 1) c
								INNER JOIN MMDeviceController DC WITH (NOLOCK) ON DC.DeviceId = c.DeviceId
						) S ON S.MountPathId = MP.MountPathId
					INNER JOIN MMLibrary L WITH (NOLOCK) ON MP.LibraryId = L.LibraryId
					LEFT OUTER JOIN (
						SELECT	MediaSideId, SUM(CAST(PhysicalBytesMB AS BIGINT)) AS DataWrittenMB
						FROM	MMVolume WITH (NOLOCK)
						WHERE	SiloStatus <> 3
						GROUP BY MediaSideId
						) W ON MS.MediaSideId = W.MediaSideId
			WHERE   MP.MountPathId > 0 AND MP.MountPathName <> 'CVDiskFolder' AND L.LibraryId > 0 AND L.LibraryTypeId != 8
			ORDER BY L.LibraryId, MP.MountPathId

		CREATE TABLE #DriveController (
			DriveId     integer,
			ControllerId   integer,
			Active   integer)
		insert into #DriveController
		SELECT DC.DriveID AS '@DriveId',
					DC.DriveID AS '@ControllerId',
					MAX(DC.DriveControllerSoftState&DC.DriveControllerSoftState&DC.DriveAccessible) AS '@Active'
			FROM    MMDriveController DC WITH (NOLOCK)
					INNER JOIN MMDrive D WITH (NOLOCK) ON D.DriveID = DC.DriveID
			WHERE   D.DriveTypeId <> 10001
			GROUP BY DC.DriveID

		CREATE TABLE #StoragePool (
			StoragePoolId     integer,
			StoragePoolName   nvarchar(256),
			StoragePoolType   integer,
			LibraryIds         varchar(1024),
			LibraryType       integer,
			ApplianceType	  integer,
			TotalControllers  integer,
			ActiveControllers integer,
			LibOfflineReason  integer,
			MPOfflineReason   integer,
			MAOfflineReason   integer,
			NumMediaAgents    integer,
			MediaAgents		  NVARCHAR(1024),
		)
		insert into #StoragePool
		SELECT PL.StoragePoolId AS 'StoragePoolId',
					PL.StoragePoolName AS 'StoragePoolName',
					PL.StoragePoolType AS 'StoragePoolType',
					PL.Libraries AS 'LibraryIds',
					PL.LibraryType AS 'LibraryType',
					ISNULL(HS.ApplianceType, 0) AS 'ApplianceType',
					PL.TotalControllers AS 'TotalControllers',
					PL.ActiveControllers AS 'ActiveControllers',
					PL.LibOfflineReason AS 'LibOfflineReason',
					PL.MPOfflineReason AS 'MPOfflineReason',
					PL.MAOfflineReason AS 'MAOfflineReason',
					PL.NumMediaAgents AS 'NumMediaAgents',
					LTRIM(STUFF((SELECT ', ' + CONVERT(VARCHAR(256), PM.MediaAgent) FROM #StoragePoolMA PM 
						   WHERE PM.StoragePoolId = PL.StoragePoolId FOR XML PATH ('')), 1, 1, '')) AS 'MediaAgents'
			FROM    #StoragePoolRaw PL
					LEFT OUTER JOIN #HyperScaleMediaSide HS ON PL.StoragePoolId = HS.StoragePoolId

		declare @atozResultStr varchar(max) = ''
		declare @atozAllTablesStr varchar(max) = ''
		exec #encodeTableIntoAtoZ @tableName='#HyperScaleUsage', @resultStr=@atozResultStr OUTPUT
		set @atozAllTablesStr = @atozAllTablesStr + @atozResultStr
		exec #encodeTableIntoAtoZ @tableName='#StoragePool', @resultStr=@atozResultStr OUTPUT
		set @atozAllTablesStr = @atozAllTablesStr + @atozResultStr
		exec #encodeTableIntoAtoZ @tableName='#DriveController', @resultStr=@atozResultStr OUTPUT
		set @atozAllTablesStr = @atozAllTablesStr + @atozResultStr
		exec #encodeTableIntoAtoZ @tableName='#MountPath', @resultStr=@atozResultStr OUTPUT
		set @atozAllTablesStr = @atozAllTablesStr + @atozResultStr
		exec #encodeTableIntoAtoZ @tableName='#LibraryController', @resultStr=@atozResultStr OUTPUT
		set @atozAllTablesStr = @atozAllTablesStr + @atozResultStr
		exec #encodeTableIntoAtoZ @tableName='#Library', @resultStr=@atozResultStr OUTPUT
		set @atozAllTablesStr = @atozAllTablesStr + @atozResultStr
		exec #encodeTableIntoAtoZ @tableName='#MediaAgent', @resultStr=@atozResultStr OUTPUT
		set @atozAllTablesStr = @atozAllTablesStr + @atozResultStr

		DROP TABLE #Library
		DROP TABLE #MountPath
		DROP TABLE #DriveController
		DROP TABLE #MediaAgent
		DROP TABLE #StoragePool
		DROP TABLE #HyperScaleUsage
		DROP TABLE #LibraryController

		DROP TABLE #StoragePoolRaw
		DROP TABLE #LibraryMA
		DROP TABLE #StoragePoolMA
		DROP TABLE #HyperScaleMediaSide

		set @XmlResult = (cast(@atozAllTablesStr as xml))

		--Insert result into #AToZFeatureDetails
		INSERT INTO #AToZFeatureDetails
		(
			AToZFeatureId,
			AttrName,
			AttrType,
			AttrVal,
			CollectionTime
		)
		SELECT
			csInfo.n.value('@AToZFeatureId', 'INT'),
			csInfo.n.value('@AttrName', 'NVARCHAR(512)'),
			csInfo.n.value('@AttrType', 'NVARCHAR(512)'),
			csInfo.n.value('@AttrVal', 'NVARCHAR(MAX)'),
			csInfo.n.value('@CollectionTime', 'DATEtime')
		FROM @XmlResult.nodes('/result') AS csInfo(n)

	/*
	**********************
	*  3. Return result  *
	**********************
	*/
	SELECT QUOTENAME(AToZFeatureId),
		QUOTENAME(AttrName),
		QUOTENAME(AttrType),
		QUOTENAME(isnull(AttrVal,'')),
		QUOTENAME(CONVERT(VARCHAR, CollectionTime, 120))
	FROM #AToZFeatureDetails

	DROP TABLE #AToZFeatureDetails
	DROP PROCEDURE #encodeTableIntoAtoZ

	SET NOCOUNT OFF
end
