--- Please follow the below comments to insert SQL statements.

--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------

SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

DECLARE @LogDate AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @queryId AS INTEGER = 219
DECLARE @surveyXML NVARCHAR(MAX)

--------- END - GENERATED CODE ---------


--------- BEGIN SURVEY QUERY ---------

--------- Insert your SQL statements here 


	IF OBJECT_ID('tempdb.dbo.#ThirdPartySoftwareVersionsTemp') IS NOT NULL DROP TABLE #ThirdPartySoftwareVersionsTemp
	CREATE TABLE #ThirdPartySoftwareVersionsTemp 
	(	VmClientId			INT,
		JobId			    INT,
		ThirdPartySoftware 	NVARCHAR(MAX),
		SoftwareVersion		NVARCHAR(MAX),
		EntityName			NVARCHAR(MAX),
		HostName			NVARCHAR(MAX),
	)

	INSERT INTO #ThirdPartySoftwareVersionsTemp 
	SELECT	 VMHost.vmClientId,
			 LastJob.attrVal,		
			'ESX' AS ThirdPartySoftware, 
			 '',
			'ESX Server(s)' AS EntityName,
			VMHost.attrVal
	FROM APP_VMProp VmHost
		INNER JOIN APP_ClientProp LastJob 
			ON LastJob.attrName = 'Last Backup JobID' AND LastJob.modified = 0 AND LastJob.attrVal = CAST(VmHost.jobId AS NVARCHAR(50))
				AND VmHost.vmClientId = LastJob.componentNameId AND VmHost.attrName = 'vmHost'
		INNER JOIN APP_ClientProp clProp
			ON clProp.componentNameId = vmHost.VMclientId AND clProp.attrName = 'Virtual Machine Instance ID' AND clProp.modified = 0
		INNER JOIN APP_InstanceProp inst 
			ON CAST(inst.componentNameId AS NVARCHAR(50)) = clProp.attrVal AND inst.attrName = 'Virtual Server Instance Type' AND inst.modified = 0 AND inst.attrVal IN ('100', '101')
			
    UPDATE #ThirdPartySoftwareVersionsTemp
            SET SoftwareVersion = VMVersion.attrVal
			FROM APP_VMProp VMVersion
			INNER JOIN #ThirdPartySoftwareVersionsTemp TEMP ON VMVersion.VMclientId = TEMP.vmClientId
			AND VMVersion.jobId = TEMP.JobId
			AND VMVersion.attrName = 'vmHostVersion'

	UPDATE #ThirdPartySoftwareVersionsTemp
			SET SoftwareVersion = VMVersion.attrVal
			FROM APP_ClientProp VMVersion
			INNER JOIN #ThirdPartySoftwareVersionsTemp TEMP ON VMVersion.componentNameId = TEMP.vmClientId
			AND TEMP.SoftwareVersion = ''
			AND VMVersion.attrName = 'Virtual Machine Host Version'
			AND VMVersion.modified = 0
    
    IF OBJECT_ID('tempdb.dbo.#ThirdPartySoftwareVersions') IS NOT NULL DROP TABLE #ThirdPartySoftwareVersions
	CREATE TABLE #ThirdPartySoftwareVersions 
	(
		ThirdPartySoftware 	NVARCHAR(MAX),
		SoftwareVersion		NVARCHAR(MAX),
		EntityName			NVARCHAR(MAX),
		EntityCount			INT
	)
	
    INSERT INTO #ThirdPartySoftwareVersions 
    SELECT t.ThirdPartySoftware,
           t.SoftwareVersion,
           t.EntityName,
           count( distinct t.HostName) as count 
    FROM #ThirdPartySoftwareVersionsTemp t
    GROUP BY t.ThirdPartySoftware,
	         t.SoftwareVersion,
             t.EntityName
 
	SET @surveyXML = (
		SELECT 
			ThirdPartySoftware AS '@software',
			SoftwareVersion AS '@version',
			EntityName AS '@entity',
			EntityCount AS '@count'
		FROM #ThirdPartySoftwareVersions
		FOR XML PATH('Version'), ROOT('ThirdPartySoftwareVersions')
	)

	IF OBJECT_ID('tempdb.dbo.#ThirdPartySoftwareVersions') IS NOT NULL DROP TABLE #ThirdPartySoftwareVersionsTemp
	IF OBJECT_ID('tempdb.dbo.#ThirdPartySoftwareVersions') IS NOT NULL DROP TABLE #ThirdPartySoftwareVersions


--------- END SURVEY QUERY ---------

--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------
--SELECT CAST (@surveyXML AS XML)

DECLARE @EndTime AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
SET @outputXML = 
(
	SELECT
		@queryId AS '@QueryId',
		@EndTime AS '@LogDate',
		(@EndTime - @LogDate) AS '@QueryRunningTime',
		@surveyXML
	FOR XML PATH('Rpt_CSSXMLDATA')
)

SET NOCOUNT OFF

--------- END - GENERATED CODE ---------

