--- Please follow the below comments to insert SQL statements.

--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------

SET NOCOUNT ON

DECLARE @LogDate   INTEGER = dbo.GetUnixTime(GETUTCDATE())
DECLARE @queryId   INTEGER = 92
DECLARE @surveyXML NVARCHAR(MAX)

--------- END - GENERATED CODE ---------



--------- BEGIN SURVEY QUERY ---------
DECLARE	@FromTime INT = dbo.GetUnixTime(GETUTCDATE()) - 30*24*3600


CREATE TABLE #Client (ClientId INT, ClientName NVARCHAR(255), IsVM INT, HasFSAgent INT, IsOneTouch INT)

INSERT	INTO #Client
SELECT	C.id , C.name, CASE WHEN VC.componentNameId IS NULL THEN 0 ELSE 1 END, 0, 0
FROM	APP_Client C LEFT OUTER JOIN 
		(SELECT	DISTINCT componentNameId
		FROM	APP_ClientProp
		WHERE	attrName = 'Virtual Server Discovered Clients' AND attrVal = '1' AND modified = 0) VC ON C.id = VC.componentNameId
WHERE	C.id > 1 AND (VC.componentNameId IS NOT NULL OR (C.status & 2) = 0) 

UPDATE	#Client SET HasFSAgent = 1
FROM	#Client C 
		INNER JOIN APP_IDAName I 
			ON C.ClientId = I.clientId AND (I.status & 2) = 0
			AND I.appTypeId IN (1,11,12,17,18,19,20,21,29,33,34,36,42,43,63,64,74)

UPDATE	#Client SET IsOneTouch = 1
FROM	#Client C 
		INNER JOIN APP_ClientGroupAssoc CGA 
			ON CGA.clientId = C.ClientId
		INNER JOIN APP_ClientGroup CG 
			ON CG.id = CGA.ClientGroupID 
WHERE	CG.name = N'1Touch' 

DELETE	T
FROM	#Client T 
	LEFT OUTER JOIN APP_IDAName I ON T.clientId = I.clientId AND (I.status & 2) = 0
	LEFT OUTER JOIN (
	SELECT	DISTINCT vmClientId
	FROM	APP_VMProp VM INNER JOIN JMBkpStats B 
		ON VM.jobId = B.jobId AND VM.commCellId = B.commCellId AND B.servEndDate > @FromTime
	) S ON T.clientId = S.vmClientId
WHERE	T.IsVM = 1 AND I.clientId IS NULL AND S.vmClientId IS NULL


SET @surveyXML = (
	SELECT	ClientId AS '@ClientId', 
		ClientName AS '@ClientName', 
		IsVM AS '@IsVM', 
		HasFSAgent AS '@HasFSAgent', 
		IsOneTouch AS '@IsOneTouch'
	FROM	#Client
	FOR XML PATH ('RoyaltyStats') 
)

--------- END SURVEY QUERY ---------

--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------


DECLARE @EndTime AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
SET @outputXML = 
(
	SELECT
		@queryId AS '@QueryId',
		@EndTime AS '@LogDate',
		(@EndTime - @LogDate) AS '@QueryRunningTime',
		@surveyXML
	FOR XML PATH('Rpt_CSSXMLDATA')
)

DROP TABLE #Client

SET NOCOUNT OFF

--------- END - GENERATED CODE ---------






