--Name:- Hardware Encryption for Tape Copies
--Description:- Collect tape data paths with UseHardwareEncryption flag.

SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

DECLARE @LogDate AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @queryId AS INTEGER = 175
DECLARE @surveyXML NVARCHAR(MAX)

DECLARE @startTime INT = dbo.GetUnixTime(DATEADD(DAY, -1, GETUTCDATE()))


CREATE TABLE #TapeInfo (CopyId INT, MediaId INT, SizeOnMedia BIGINT, 
	SwEncrypted INT, HwEncrypted INT, NotEncrypted INT, 
	Barcode VARCHAR(256), MediaTypeId INT, LibraryId INT, 
	MediaLocation INT, ExportLocationID INT, LocationName NVARCHAR(1024), IsAged INT,
	JobIDs VARCHAR(MAX), MinJobId INT, MaxJobId INT, CommCellId INT, MinJobStart INT, MaxJobEnd INT)

-- Get encrypted tapes
INSERT INTO #TapeInfo (CopyId, MediaId, SizeOnMedia, SwEncrypted, HwEncrypted, NotEncrypted, MinJobId, MaxJobId, CommCellId)
SELECT	AFC.archCopyId, V.MediaId, 
		SUM(ACM.physicalSize), 
		SUM(CASE WHEN AFC.encKeyType > 0 THEN 1 ELSE 0 END),
		SUM(CASE WHEN AC.hwEncKey  <> '' THEN 1 ELSE 0 END),
		SUM(CASE WHEN AFC.encKeyType = 0 AND AC.hwEncKey = '' THEN 1 ELSE 0 END),
		 MIN(AF.jobId), MAX(AF.jobId), MAX(AF.commCellId)
FROM	archFile AF 
	INNER JOIN archFileCopy AFC ON AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId
	INNER JOIN archChunkMapping ACM ON AFC.archFileId = ACM.archFileId AND AFC.commCellId = ACM.commCellId AND AFC.archCopyId = ACM.archCopyId
	INNER JOIN archChunk AC ON ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId
	INNER JOIN MMVolume V ON AC.volumeId = V.VolumeId AND V.RecordingFormatId <> 10001
WHERE	AF.fileType IN (1, 4)
GROUP BY AFC.archCopyId, V.MediaId
ORDER BY AFC.archCopyId, V.MediaId

CREATE TABLE #NotEncryptedJobs (CopyId INT, MediaId INT, jobId INT, commCellId INT)

INSERT INTO #NotEncryptedJobs
SELECT	AFC.archCopyId, V.MediaId, AF.jobId, AF.commCellId
FROM	archFile AF 
	INNER JOIN archFileCopy AFC ON AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId
	INNER JOIN archChunkMapping ACM ON AFC.archFileId = ACM.archFileId AND AFC.commCellId = ACM.commCellId AND AFC.archCopyId = ACM.archCopyId
	INNER JOIN archChunk AC ON ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId
	INNER JOIN MMVolume V ON AC.volumeId = V.VolumeId AND V.RecordingFormatId <> 10001
WHERE	AF.fileType IN (1, 4) AND AFC.encKeyType = 0 AND AC.hwEncKey = ''
GROUP BY AFC.archCopyId, V.MediaId, AF.jobId, AF.commCellId
ORDER BY V.MediaId, AF.jobId

UPDATE	T
SET		Barcode = M.BarCode, MediaTypeId = M.MediaTypeId, 
		LibraryId = CASE WHEN M.LibraryId > 0 THEN M.LibraryId ELSE M.LastWriteLibraryId END,
		ExportLocationID = M.ExportLocationID, MediaLocation = M.MediaLocation, IsAged = M.IsAged
FROM	#TapeInfo T INNER JOIN MMMedia M ON T.MediaId = M.MediaId

UPDATE	T
SET		LocationName = L.AliasName
FROM	#TapeInfo T INNER JOIN MMLibrary L ON T.LibraryId = L.LibraryId AND T.MediaLocation IN (1,2)

UPDATE	T
SET		LocationName = M.ExportLocation
FROM	#TapeInfo T INNER JOIN MMExportLocation M ON T.ExportLocationID = M.ExportLocationID AND T.MediaLocation = 3

UPDATE	T 
SET		JobIDs = STUFF((SELECT DISTINCT ',' + CAST(jobId AS VARCHAR(10)) FROM #NotEncryptedJobs WHERE MediaId = T.MediaId FOR XML PATH ('')), 1, 1, '')
FROM	#TapeInfo AS T

UPDATE	T
SET		MinJobStart = M.MinJobStart, MaxJobEnd = M.MaxJobEnd
FROM	#TapeInfo T
		INNER JOIN (
			SELECT	MediaId, MIN(servStartDate) AS MinJobStart, MAX(servEndDate) AS MaxJobEnd 
			FROM	#NotEncryptedJobs J INNER JOIN JMBkpStats B ON J.jobId = B.jobId AND J.commCellId = B.commCellId
			GROUP BY MediaId
		) M ON T.MediaId = M.MediaId AND T.NotEncrypted > 0

UPDATE	T
SET		MinJobStart = M.MinJobStart, MaxJobEnd = M.MaxJobEnd
FROM	#TapeInfo T
		INNER JOIN (
			SELECT	MediaId, MIN(servStart) AS MinJobStart, MAX(servEnd) AS MaxJobEnd 
			FROM	#NotEncryptedJobs J INNER JOIN JMAdminJobStatsTable B ON J.jobId = B.jobId AND J.commCellId = B.commCellId
			GROUP BY MediaId
		) M ON T.MediaId = M.MediaId AND T.NotEncrypted > 0

UPDATE	T
SET		MinJobStart = B.servStartDate
FROM	#TapeInfo T INNER JOIN JMBkpStats B ON T.MinJobId = B.jobId AND T.commCellId = B.commCellId AND T.NotEncrypted = 0

UPDATE	T
SET		MaxJobEnd = B.servEndDate
FROM	#TapeInfo T INNER JOIN JMBkpStats B ON T.MinJobId = B.jobId AND T.commCellId = B.commCellId AND T.NotEncrypted = 0

UPDATE	T
SET		MinJobStart = B.servStart
FROM	#TapeInfo T INNER JOIN JMAdminJobStatsTable B ON T.MinJobId = B.jobId AND T.commCellId = B.commCellId AND T.NotEncrypted = 0

UPDATE	T
SET		MaxJobEnd = B.servEnd
FROM	#TapeInfo T INNER JOIN JMAdminJobStatsTable B ON T.MinJobId = B.jobId AND T.commCellId = B.commCellId AND T.NotEncrypted = 0


SET @surveyXML =(SELECT	

	(SELECT	AG.id AS '@PolicyId',
		dbo.NormalizeForXML(AG.name) AS '@PolicyName', 
		AGC.id AS '@CopyId', 
		dbo.NormalizeForXML(AGC.name) AS '@CopyName', 
		CL.id AS '@MediaAgentId', 
		dbo.NormalizeForXML(CL.name) AS '@MediaAgentName', 
		L.LibraryId AS '@LibraryId', 
		dbo.NormalizeForXML(L.AliasName) AS '@LibraryName', 
		UseHwEncryption AS '@UseHwEncryption'
	FROM	
		(SELECT DPT.CopyId, DPT.HostClientId, MPL.LibraryId, MIN(UseHardwareEncryption) AS UseHwEncryption
		FROM	MMDataPath DPT 
			INNER JOIN MMDrivePool DPL ON DPL.DrivePoolId = DPT.DrivePoolId
			INNER JOIN MMMasterPool MPL ON MPL.MasterPoolId = DPL.MasterPoolId
		WHERE	(DPT.Flag & 4) = 4 AND DPT.SpareGroupId > 0
		GROUP BY DPT.CopyId, DPT.HostClientId, MPL.LibraryId
		) T
		INNER JOIN archGroupCopy AGC ON AGC.id = T.CopyId AND AGC.isActive = 1
		INNER JOIN archGroup AG ON AG.id = AGC.archGroupId AND AG.id > 1 AND AG.type <> 2
		INNER JOIN APP_Client CL ON CL.id = T.HostClientId
		INNER JOIN MMLibrary L ON L.LibraryId = T.LibraryId AND L.LibraryTypeId NOT IN (2,3,5)
		INNER JOIN MMLibraryType LT ON LT.LibraryTypeId = L.LibraryTypeId AND LT.LibraryTypeName = 'Tape'
	FOR XML PATH ('HardwareEncryption'), TYPE),

	(SELECT	AG.id AS '@PolicyId',
		dbo.NormalizeForXML(AG.name) AS '@PolicyName', 
		AGC.id AS '@CopyId', 
		dbo.NormalizeForXML(AGC.name) AS '@CopyName', 
		T.MediaId AS '@MediaId',
		T.Barcode AS '@Barcode', 
		MT.MediaTypeName AS '@MediaTypeName', 
		T.MediaLocation AS '@MediaLocation',
		dbo.NormalizeForXML(T.LocationName) AS '@LocationName', 
		T.SizeOnMedia AS '@SizeOnMedia', 
		CASE WHEN T.NotEncrypted > 0 THEN 0 WHEN T.HwEncrypted > 0 THEN 1 ELSE 2 END AS '@Encrypted',
		T.IsAged AS '@IsAged',
		ISNULL(T.JobIDs, '') AS '@JobIDs',
		CASE WHEN T.MinJobStart IS NULL THEN '1970-01-01' ELSE dbo.UTCToCellLocalTime(dbo.GetDateTime(T.MinJobStart), 2) END AS '@MinJobStart',
		CASE WHEN T.MinJobStart IS NULL THEN '1970-01-01' ELSE dbo.UTCToCellLocalTime(dbo.GetDateTime(T.MaxJobEnd), 2) END AS '@MaxJobEnd'
	FROM	#TapeInfo T
		INNER JOIN MMMediaType MT ON T.MediaTypeId = MT.MediaTypeId
		INNER JOIN archGroupCopy AGC ON AGC.id = T.CopyId
		INNER JOIN archGroup AG ON AG.id = AGC.archGroupId AND AG.id > 1 AND AG.type <> 2
	FOR XML PATH('TapesNotEncrypted'), TYPE)

FOR XML PATH ('')
)
	
DROP TABLE #NotEncryptedJobs
DROP TABLE #TapeInfo

--SELECT CAST(@surveyXML AS XML)

DECLARE @EndTime AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
SET @outputXML = 
(
	SELECT
		@queryId AS '@QueryId',
		@EndTime AS '@LogDate',
		(@EndTime - @LogDate) AS '@QueryRunningTime',
		@surveyXML
	FOR XML PATH('Rpt_CSSXMLDATA')
)
	
SET NOCOUNT OFF 
