
--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @LogDate AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @queryId AS INTEGER = 164
DECLARE @surveyXML NVARCHAR(MAX)

--------- BEGIN SURVEY QUERY ---------
DECLARE @nDays INT=10

DECLARE @csTimeZone    NVARCHAR(1024) = ''
SELECT  @csTimeZone = dbo.GetClientTimeZone(2)

IF ISNULL(@csTimeZone, '') = ''
BEGIN
    SELECT @csTimeZone = timeZone FROM APP_CommCell WITH (NOLOCK) WHERE id = 2
    SELECT @csTimeZone = TimeZoneStdName FROM SchedTimeZone WITH (NOLOCK)
    WHERE  TimeZoneName = SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)
END


-- Check if any special group to consider for data collection.
-- Get the list of client group ids if exists
DECLARE @groupStr varchar(256);
DECLARE @groupStrName Nvarchar(MAX)='';
DECLARE @isPrivateRunning varchar(256)='';
DECLARE @freequencyMode	 NVARCHAR(MAX) ='0';

IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#MetricsInputParams'))
BEGIN
    SELECT @freequencyMode = mode from #MetricsInputParams
END
IF EXISTS(SELECT name FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'CommservSurveyRunning')
BEGIN
	SELECT @isPrivateRunning = value from GXGlobalParam WITH (NOLOCK)  where name ='CommservSurveyRunning'
END

IF ((@isPrivateRunning = 'Metrics Reporting')OR  (@freequencyMode ='1'))
BEGIN
	SELECT @groupStr = value from GXGlobalParam WITH (NOLOCK) where name ='CommservSurveyPrivateSpecialClientGroup'
END
ELSE
BEGIN
	SELECT @groupStr = value from GXGlobalParam WITH (NOLOCK) where name ='CommservSurveySpecialClientGroup'
END

SET @groupStr = @groupStr + ',';
declare @includeGroups table(groupID int);
DECLARE @endIndex integer=0
DECLARE @startIndex integer=0
DECLARE @groupId integer        

SET @endIndex = CHARINDEX(',', @groupStr, @startIndex)
  
WHILE(@endIndex IS NOT NULL AND @endIndex <> 0)
BEGIN
	SET @groupId = CAST(SUBSTRING(@groupStr,@startIndex,@endIndex-@startIndex) AS INT)
	if(@groupId > 0)
	BEGIN
		insert into @includeGroups values(@groupId);
		DECLARE @tmpStr NVARCHAR(100);
		SELECT @tmpStr = NAME FROM APP_ClientGroup WITH (NOLOCK) WHERE id = @groupId;
		IF(@tmpStr IS NOT NULL)
			SET @groupStrName = @groupStrName + ', ' + @tmpStr
	END
	SET @startIndex = @endIndex + 1
	SET @endIndex = CHARINDEX(',', @groupStr, @startIndex)
END

DECLARE @specialGroupExists INT  =0
DECLARE @includeClients TABLE (clientId INT);

IF EXISTS ( SELECT id FROM app_clientgroup WITH (NOLOCK) join @includeGroups on id=groupID)
BEGIN
	SET @specialGroupExists =1
	
	INSERT INTO @includeClients
	SELECT DISTINCT CGA.clientId 
	FROM @includeGroups CG INNER JOIN APP_ClientGroupAssoc CGA WITH (NOLOCK) ON CGA.clientGroupId = CG.groupID	
END

DECLARE @ExcludedAppIds TABLE (appId INT)
INSERT INTO @ExcludedAppIds
SELECT componentNameId FROM APP_subclientProp WITH (NOLOCK) WHERE attrName IN ('DDB Backup', 'SILO Copy ID') AND attrVal <> '0' AND modified = 0
UNION
SELECT id FROM APP_Application WITH (NOLOCK) 
WHERE clientId IN (SELECT componentNameId FROM APP_ClientProp WITH (NOLOCK) WHERE attrName = 'Content Index Server' AND attrVal = '1' AND modified = 0)


--Name:- Back Up Job attempt Statistics
--a) collects jobs attempt data for last 24 hours
 
--Description:- 
--DATE TABLE COMPUTATION FOR ndays DAY ONLY 

DECLARE @HourTbl TABLE (DateVal datetime, Hour INT, HourBeginDT DATETIME, HourEndDT DATETIME, HourBegin INT, HourEnd INT)

DECLARE	@i			INT = 0
DECLARE	@j			INT = 0
-- To Get the Hourly calculation no calculation for middle hours
DECLARE @FromTime	DATETIME = DATEADD(HOUR, DATEDIFF(HOUR, 0, GETDATE()-@nDays), 0) 
DECLARE	@dtBegin	DATETIME = dbo.LocalToUTCTime(@FromTime, @csTimeZone)
DECLARE	@dtEnd		DATETIME = DATEADD(HOUR, 1, @dtBegin)
DECLARE	@utBegin	INT = dbo.GetUnixTime(@dtBegin)
DECLARE	@utEnd		INT = dbo.GetUnixTime(@dtEnd)


WHILE @j < @nDays
BEGIN
set @i =0
WHILE @i < 24
BEGIN
	INSERT	INTO @HourTbl
	SELECT	dbo.UTCToLocalTime(@dtBegin, @csTimeZone)  , @i, @dtBegin, @dtEnd, 0, 0

	SET @i = (@i + 1)
	SET	@dtBegin = @dtEnd
	SET @dtEnd = DATEADD(HOUR, 1, @dtBegin)
END
	SET @j = (@j + 1)
	set @FromTime	 = DATEADD(DD, @j, @FromTime)
	set	@dtBegin	 = dbo.LocalToUTCTime(@FromTime, @csTimeZone)
	set @dtEnd		= DATEADD(HOUR, 1, @dtBegin)


END
UPDATE	@HourTbl SET HourBegin = dbo.GetUnixTime(HourBeginDT), HourEnd = dbo.GetUnixTime(HourEndDT)



DECLARE @DailyJobsAttemptInfo table
(
	servStartDate DATETIME,
	hour INT,
	initFrom		INT,
	TotCJobs		BIGINT, --Completed job with multiple attempts
	JobCIn2Attempt  BIGINT,
	JobCIn3Attempt  BIGINT,
	JobCInMoreAttempt  BIGINT
	
)

IF (@specialGroupExists = 0)
BEGIN
	
	INSERT INTO @DailyJobsAttemptInfo
	SELECT	H.DateVal,H.Hour,ISNULL(T.initFrom,0),--COUNT(jobId) AS 'totalSuccess',
		 SUM(CASE WHEN numOfPhases != numOfAttempts THEN 1 ELSE 0 END) AS 'TotalSuccess' , 
		 SUM(CASE WHEN numOfPhases+1 = (numOfAttempts) THEN 1 ELSE 0 END)AS '2Attempt' ,
		 SUM(CASE WHEN numOfPhases+2 = (numOfAttempts) THEN 1 ELSE 0 END)AS '3Attempt' ,
		 SUM(CASE WHEN numOfPhases+2 < (numOfAttempts) THEN 1 ELSE 0 END)AS '3+Attempt' 
		
	FROM	@HourTbl H 
	LEFT OUTER JOIN (SELECT	H.DateVal,H.Hour,B.initFrom,B.jobId, COUNT(DISTINCT A.phase) AS numOfPhases, COUNT(*) AS numOfAttempts
		FROM	@HourTbl H 
		INNER JOIN JMBkpStats B WITH (NOLOCK)
			on B.servEndDate >= HourBegin AND B.servEndDate < HourEnd
		INNER JOIN JMBkpAtmptStats A 
			 ON B.jobId = A.jobId AND B.commCellId = A.commCellId AND B.commCellId = 2 
			AND B.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)			 
			AND B.status IN (1, 3, 14) 
		INNER JOIN APP_Application Ap WITH (NOLOCK) ON B.appId= Ap.id
	WHERE Ap.id NOT IN (SELECT appId FROM @ExcludedAppIds)			
		GROUP BY H.DateVal,H.Hour,B.initFrom, B.jobId) T
	ON H.DateVal = T.DateVal AND H.Hour =T.Hour	
		GROUP BY H.DateVal,H.Hour,T.initFrom
	
END
ELSE
BEGIN
 	
	INSERT INTO @DailyJobsAttemptInfo
	SELECT	H.DateVal,H.Hour,ISNULL(T.initFrom,0),--COUNT(jobId) AS 'totalSuccess',
		 SUM(CASE WHEN numOfPhases != numOfAttempts THEN 1 ELSE 0 END) AS 'TotalSuccess' , 
		 SUM(CASE WHEN numOfPhases+1 = (numOfAttempts) THEN 1 ELSE 0 END)AS '2Attempt' ,
		 SUM(CASE WHEN numOfPhases+2 = (numOfAttempts) THEN 1 ELSE 0 END)AS '3Attempt' ,
		 SUM(CASE WHEN numOfPhases+2 < (numOfAttempts) THEN 1 ELSE 0 END)AS '3+Attempt' 
		
	FROM	@HourTbl H 
	LEFT OUTER JOIN (SELECT	H.DateVal,H.Hour,B.initFrom,B.jobId, COUNT(DISTINCT A.phase) AS numOfPhases, COUNT(*) AS numOfAttempts
		FROM	@HourTbl H 
		INNER JOIN JMBkpStats B WITH (NOLOCK)
			on B.servEndDate >= HourBegin AND B.servEndDate < HourEnd
		INNER JOIN JMBkpAtmptStats A 
			 ON B.jobId = A.jobId AND B.commCellId = A.commCellId AND B.commCellId = 2 
			AND B.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)			 
			AND B.status IN (1, 3, 14) 
		INNER JOIN APP_Application Ap WITH (NOLOCK) ON B.appId= Ap.id
		INNER JOIN @includeClients C ON C.clientId = AP.clientId
	WHERE Ap.id NOT IN (SELECT appId FROM @ExcludedAppIds)			
		GROUP BY H.DateVal,H.Hour,B.initFrom, B.jobId) T
	ON H.DateVal = T.DateVal AND H.Hour =T.Hour	
		GROUP BY H.DateVal,H.Hour,T.initFrom
END

--select initFrom AS 'initFrom',SUM(TotCJobs) AS 'CWithMultiAttempts',SUM(JobCIn2Attempt) AS 'CWith2Attempts',SUM(JobCIn3Attempt) AS 'CWith3Attempts',SUM(JobCInMoreAttempt)  AS 'CWithMoreAttempts' from @DailyJobsAttemptInfo GROUP BY initFrom

DECLARE @curTime	DATETIME = DATEADD(HOUR, DATEDIFF(HOUR, 0, GETDATE()), 0) 

DECLARE @MultiAttemptJobStatsXML XML = (select 
		 dbo.getUnixtime(@curTime )	  AS '@curTime',
          initFrom					AS '@InitFrom',
          SUM(TotCJobs)				AS '@CWithMultiAttempts',
          SUM(JobCIn2Attempt)		AS '@CWith2Attempts',
          SUM(JobCIn3Attempt)		AS '@CWith3Attempts',
          SUM(JobCInMoreAttempt)    AS '@CWithMoreAttempts'
          FROM @DailyJobsAttemptInfo GROUP BY initFrom
FOR xml PATH ('JobAttemptStats'))


--SELECT @MultiAttemptJobStatsXML

SET @surveyXML =
(
SELECT    

@MultiAttemptJobStatsXML
FOR XML PATH('MultiAttemptJobStatsXML' ) 



)


--select cast (@surveyXML as XML)
--------- END SURVEY QUERY ---------

--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------
DECLARE @EndTime AS BIGINT = dbo.GetUnixTime(GETUTCDATE())

SET @outputXML = 
(
	SELECT
		@queryId AS '@QueryId',
		@EndTime AS '@LogDate',
		(@EndTime - @LogDate) AS '@QueryRunningTime',
		@surveyXML
	FOR XML PATH('Rpt_CSSXMLDATA')
)
SET NOCOUNT OFF
--------- END - GENERATED CODE ---------


