
--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @LogDate AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @queryId AS INTEGER = 163
DECLARE @surveyXML NVARCHAR(MAX)

--------- BEGIN SURVEY QUERY ---------

DECLARE @csTimeZone    NVARCHAR(1024) = ''
SELECT  @csTimeZone = dbo.GetClientTimeZone(2)

IF ISNULL(@csTimeZone, '') = ''
BEGIN
    SELECT @csTimeZone = timeZone FROM APP_CommCell WITH (NOLOCK) WHERE id = 2
    SELECT @csTimeZone = TimeZoneStdName FROM SchedTimeZone WITH (NOLOCK)
    WHERE  TimeZoneName = SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)
END


DECLARE @nDays INT=1
DECLARE @nStartTime INT=8 -- give no. of hours to be consider for starting i.e. 8 for 8 AM 23 for 11 PM
--DATE TABLE COMPUTATION FOR 1 DAY ONLY (REQUIRE LOGIC CHANGES FOR MORE THAN ONE DAY)

DECLARE @HourTbl TABLE (DateVal datetime, Hour INT, HourBeginDT DATETIME, HourEndDT DATETIME, HourBegin INT, HourEnd INT, initFrom INT)
DECLARE	@i			INT = 0

-- To Get the Hourly calculation no calculation for middle hours
DECLARE @curTime	DATETIME = DATEADD(HOUR, DATEDIFF(HOUR, 0, GETDATE()), 0) 
DECLARE @FromTime	DATETIME = DATEADD(DD, DATEDIFF(DD, 0, GETDATE()), 0)
SET @FromTime  = DATEADD(HH,@nStartTime,@FromTime)

IF (@curTime<@FromTime)
SET @FromTime =  DATEADD(DD,-1,@FromTime)

DECLARE	@dtBegin	DATETIME = @FromTime
DECLARE	@dtEnd		DATETIME = DATEADD(HOUR, 1, @dtBegin)
DECLARE	@utBegin	INT = dbo.GetUnixTime(@dtBegin)
DECLARE	@utEnd		INT = dbo.GetUnixTime(@dtEnd)


WHILE @i < 24 AND @dtBegin<@curTime
BEGIN
	INSERT	INTO @HourTbl
	SELECT	@dtBegin  , @i, dbo.LocalToUTCTime(@dtBegin,@csTimeZone) ,dbo.LocalToUTCTime(@dtEnd,@csTimeZone), 0, 0,2
	UNION
	SELECT	@dtBegin  , @i, dbo.LocalToUTCTime(@dtBegin,@csTimeZone) ,dbo.LocalToUTCTime(@dtEnd,@csTimeZone), 0, 0,3

	SET @i = (@i + 1)
	SET	@dtBegin = @dtEnd
	SET @dtEnd = DATEADD(HOUR, 1, @dtBegin)
END	
UPDATE	@HourTbl SET HourBegin = dbo.GetUnixTime(HourBeginDT), HourEnd = dbo.GetUnixTime(HourEndDT)

DECLARE @startdate DATETIME =  @FromTime
DECLARE @enddate DATETIME   = DATEADD(DD, 1, @FromTime)

-- Check if any special group to consider for data collection.
-- Get the list of client group ids if exists
DECLARE @groupStr varchar(256);
DECLARE @groupStrName Nvarchar(MAX)='';
DECLARE @isPrivateRunning varchar(256)='';
DECLARE @freequencyMode	 NVARCHAR(MAX) ='0';

IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#MetricsInputParams'))
BEGIN
    SELECT @freequencyMode = mode from #MetricsInputParams
END
IF EXISTS(SELECT name FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'CommservSurveyRunning')
BEGIN
	SELECT @isPrivateRunning = value from GXGlobalParam WITH (NOLOCK)  where name ='CommservSurveyRunning'
END

IF ((@isPrivateRunning = 'Metrics Reporting')OR  (@freequencyMode ='1'))
BEGIN
	SELECT @groupStr = value from GXGlobalParam WITH (NOLOCK) where name ='CommservSurveyPrivateSpecialClientGroup'
END
ELSE
BEGIN
	SELECT @groupStr = value from GXGlobalParam WITH (NOLOCK) where name ='CommservSurveySpecialClientGroup'
END

SET @groupStr = @groupStr + ',';
declare @includeGroups table(groupID int);
DECLARE @endIndex integer=0
DECLARE @startIndex integer=0
DECLARE @groupId integer        

SET @endIndex = CHARINDEX(',', @groupStr, @startIndex)
  
WHILE(@endIndex IS NOT NULL AND @endIndex <> 0)
BEGIN
	SET @groupId = CAST(SUBSTRING(@groupStr,@startIndex,@endIndex-@startIndex) AS INT)
	if(@groupId > 0)
	BEGIN
		insert into @includeGroups values(@groupId);
		DECLARE @tmpStr NVARCHAR(100);
		SELECT @tmpStr = NAME FROM APP_ClientGroup WITH (NOLOCK) WHERE id = @groupId;
		IF(@tmpStr IS NOT NULL)
			SET @groupStrName = @groupStrName + ', ' + @tmpStr
	END
	SET @startIndex = @endIndex + 1
	SET @endIndex = CHARINDEX(',', @groupStr, @startIndex)
END

DECLARE @specialGroupExists INT  =0
DECLARE @includeClients TABLE (clientId INT);

IF EXISTS ( SELECT id FROM app_clientgroup WITH (NOLOCK) join @includeGroups on id=groupID)
BEGIN
	SET @specialGroupExists =1
	
	INSERT INTO @includeClients
	SELECT DISTINCT CGA.clientId 
	FROM @includeGroups CG INNER JOIN APP_ClientGroupAssoc CGA WITH (NOLOCK) ON CGA.clientGroupId = CG.groupID	
END

DECLARE @ExcludedAppIds TABLE (appId INT)
INSERT INTO @ExcludedAppIds
SELECT componentNameId FROM APP_subclientProp WITH (NOLOCK) WHERE attrName IN ('DDB Backup', 'SILO Copy ID') AND attrVal <> '0' AND modified = 0
UNION
SELECT id FROM APP_Application WITH (NOLOCK) 
WHERE clientId IN (SELECT componentNameId FROM APP_ClientProp WITH (NOLOCK) WHERE attrName = 'Content Index Server' AND attrVal = '1' AND modified = 0)

DECLARE @found INT = 0,@DATAfound INT =0
DECLARE @LastSchStats XML  =NULL
IF EXISTS(SELECT name FROM GXGlobalParam WHERE name = 'CommservSurveyDaySchStats')
BEGIN
	SET @LastSchStats = (SELECT TOP 1 CAST(value AS XML) from GXGlobalParam where name ='CommservSurveyDaySchStats')
	SET @found = 1
END


IF (@LastSchStats IS NOT NULL )
BEGIN

	IF  object_id('tempdb.dbo.#LastSchStatsData1') is not null
		DROP TABLE #LastSchStatsData1
		SELECT
		csInfo.n.value('@DateStartVal', 'DATETIME') AS DateStartVal,
		csInfo.n.value('@DateEndVal', 'DATETIME') AS DateEndVal,
		csInfo.n.value('@jobs', 'BIGINT') AS jobs
		INTO #LastSchStatsData1
	FROM
	@LastSchStats.nodes('/LastSchStatsXML/DaySchStats') AS csInfo(n)
	IF EXISTS(SELECT * FROM #LastSchStatsData1 WHERE DateEndVal =@enddate)
		SET @DATAfound = 1
	ELSE
		SET @DATAfound = 0
	--	SELECT * FROM #LastSchStatsData1 
	DROP TABLE #LastSchStatsData1
END
ELSE
	SET @DATAfound = 0


IF (@DATAfound = 0)
BEGIN

--------- BEGIN SECHEDULE QUERY ---------
IF  object_id('tempdb.dbo.#BackupTask') is not null
	DROP TABLE #BackupTask
CREATE TABLE #BackupTask (taskId INT, taskName NVARCHAR(255), taskType INT, disabled INT, subTaskId INT, subTaskName NVARCHAR(255))
INSERT      INTO #BackupTask
SELECT      DISTINCT T.taskId, T.taskName, T.taskType, T.disabled, ST.SubTaskId, ST.subTaskName
FROM  TM_SubTask ST
            INNER JOIN TM_Task T
                  ON T.taskId = ST.taskId AND ST.subTaskType = 2
                  AND T.deleted = 0 AND T.invalid = 0 AND T.uninstalled = 0 
            INNER JOIN TM_SubTaskOptions STO
                  ON STO.subTaskId = ST.SubTaskId
                  AND STO.optionId = 458405394 AND STO.value IN ('1', '2', '3', '4', '6')
WHERE T.taskType IN (2, 4)  AND ISNULL(T.disabled, 0) =  0

IF  object_id('tempdb.dbo.#TaskAssoc') is not null
	DROP TABLE #TaskAssoc

CREATE TABLE #TaskAssoc (taskId INT, taskName NVARCHAR(255), taskType INT, disabled INT, subTaskId INT, subTaskName NVARCHAR(255), 
            assocType INT, clientGroupId INT, clientId INT, appTypeId INT, instanceId INT, backupsetId INT, appId INT)
INSERT      INTO #TaskAssoc
SELECT      DISTINCT T.taskId, T.taskName, T.taskType, T.disabled, T.subTaskId, ISNULL(T.subTaskName, ''), 
            AE.assocType, AE.clientGroupId, AE.clientId, 
            AE.apptypeId, AE.instanceId, AE.backupsetId, AE.subclientId
FROM  TM_AssocEntity AE
            INNER JOIN #BackupTask T ON AE.taskId = T.taskId
WHERE (T.taskType = 2 OR T.taskType = 4 AND AE.assocType NOT IN (2, 28))
            AND AE.taskId NOT IN (SELECT DISTINCT taskId FROM TM_AssocFilter WHERE filter_type = 2 AND filter_value = 124)
UNION
SELECT      DISTINCT T.taskId, T.taskName, T.taskType, T.disabled, T.SubTaskId, T.subTaskName,
            AE.assocType, AE.clientGroupId, 0, 
            CASE WHEN ISNULL(AF.filter_type, 0) = 1 THEN ISNULL(ATGA.appTypeId, 0) ELSE ISNULL(AF.filter_value, 0) END, 0, 0, 0
FROM  TM_AssocEntity AE
            INNER JOIN #BackupTask T ON AE.taskId = T.taskId AND T.taskType = 4
            LEFT OUTER JOIN TM_AssocFilter AF ON AF.taskId = T.taskId
            LEFT OUTER JOIN APP_AppTypeGroup ATG ON ATG.appTypeGroupId = AF.filter_value AND AF.filter_type = 1
            LEFT OUTER JOIN APP_AppTypeGroupAssoc ATGA ON ATGA.appGroupId = ATG.appTypeGroupId
WHERE AE.assocType IN (2, 28) AND (ISNULL(AF.filter_type, 0) <> 2 OR ISNULL(AF.filter_value, 0) <> 124)

IF  object_id('tempdb.dbo.#NextbackupSchedule') is not null
	DROP TABLE #NextbackupSchedule
CREATE TABLE #NextbackupSchedule 
(
	  taskId INT,
	  subTaskId INT,
      schedPolicyId NVARCHAR(1024),
      schedName   NVARCHAR(1024),
      schedBackupType  NVARCHAR(128),
      schedPattern  NVARCHAR(1024),
      clientGroupId INT,
      clientId INT,
      appTypeId INT,
      instanceId INT,
      backupsetId INT,
      appId INT,
      assocType INT,
       nextRunTime				DATETIME,
      freq_subday_interval	integer				,
      flags INT --flags to indicate for while loop
)

INSERT INTO #NextbackupSchedule 
SELECT
            TASK.taskId, TASK.subTaskId, TASK.taskname ,TASK.subtaskname,
            CASE CONVERT(INT, SOPT.value)
                  WHEN 1 THEN 'Full'
                  WHEN 2 THEN 'Incremental'
                  WHEN 3 THEN 'Differential'
                  WHEN 4 THEN 'Synthetic Full'
                  WHEN 5 THEN 'ASR'
                  WHEN 6 THEN 'Transaction Log'
                  WHEN 7 THEN 'Pre-Selected Backup Type'
                  WHEN 8 THEN 'Snapshot'
                  WHEN 9 THEN 'Create OSSV Replica(s)'
                  WHEN 10 THEN 'Incrementally UPDATE OSSV volumes'
                  WHEN 11 THEN 'SRM Analysis'
                  WHEN 12 THEN 'SRM Discovery'
                  ELSE 'Unknown'
            END ,
            PAT.description ,
            TASK.clientGroupId, TASK.clientid, TASK.appTypeId, TASK.instanceId, TASK.backupsetId,
            TASK.appId, TASK.assocType,
            RTASSOC.nextRunTime,
             PAT.freq_subday_interval,
            CASE  WHEN PAT.freq_subday_interval IS NULL then 1 
				  WHEN PAT.freq_subday_interval=0 then 1
				  ELSE 0
				  END		  
      FROM
            #TaskAssoc TASK
            INNER JOIN TM_SubTaskOptions AS SOPT ON TASK.subTaskId = SOPT.subTaskId
            INNER JOIN TM_PatternAssoc AS PATASSOC ON PATASSOC.subTaskId = TASK.subTaskId
            INNER JOIN TM_Pattern AS PAT ON PAT.patternId = PATASSOC.patternId
            LEFT OUTER JOIN TM_RunTime AS RT ON RT.patternId = PAT.patternId
            LEFT OUTER JOIN TM_RunTimeAssoc AS RTASSOC ON RTASSOC.runTimeId = RT.runTimeId
            LEFT OUTER JOIN TempCvView3 t3 ON PAT.PatternId = t3.patternid
      WHERE
            SOPT.optionId = 458405394
            AND ISNULL(RTASSOC.processed, 0) = 0 AND ISNULL(RTASSOC.firing, 0) = 0
            AND ISNULL(RT.processed, 0) = 0 AND ISNULL(RT.firing, 0) =  0
            AND RTASSOC.nextRunTime BETWEEN @startdate AND @enddate


--IF WE HAVE REPEATION WITHIN A DAY, WE NEED TO INSERT ALL REPEATITION.      
DECLARE @allprocessed INT =0
SET @allprocessed = ISNULL((SELECT MIN(flags) FROM #NextbackupSchedule),1)

SELECT * INTO #tempnextschedule	FROM #NextbackupSchedule  WHERE flags = -1
WHILE (@allprocessed =0)           
BEGIN
	INSERT INTO #tempnextschedule SELECT * FROM #NextbackupSchedule  WHERE flags = 0

	UPDATE #NextbackupSchedule SET flags =1 WHERE flags=0

	UPDATE #tempnextschedule 
	SET  nextRunTime = DATEADD(SECOND,freq_subday_interval,nextRunTime),
		 flags = (CASE WHEN DATEADD(SECOND,freq_subday_interval,nextRunTime)>= @enddate THEN 1 ELSE 0 END)

	INSERT INTO #NextbackupSchedule	SELECT * FROM #tempnextschedule
	SET @allprocessed = ISNULL((SELECT MIN(flags) FROM #NextbackupSchedule),1)
	
	TRUNCATE TABLE #tempnextschedule
END
DROP TABLE #tempnextschedule

IF  object_id('tempdb.dbo.#subclients') is not null
	DROP TABLE #subclients

CREATE TABLE #subclients
(
clientId INT,
appTypeId INT,
instanceId INT,
backupsetId INT,
appId INT,
subclientName NVARCHAR(256),
SubclientPolicyAppId INT
)
IF (@specialGroupExists = 0)
BEGIN
	INSERT INTO #subclients
	SELECT  A.clientId,A.appTypeID,A.instance , A.backupSet,A.id,A.subclientNAme,
	CAST(ISNULL(SCP.attrVal, '0') AS INT) AS 'subclientPolicyAppId'   
	FROM
        App_Application A With (nolock)
        LEFT OUTER JOIN APP_SubClientProp SCP With (nolock) ON SCP.componentNameId = A.id 
              AND SCP.attrName = 'Associated subclient Policy' AND SCP.modified = 0
	WHERE 
        A.appTypeId < 600 AND A.appTypeId NOT IN (72, 84, 85, 107, 121, 122, 127) 
	AND (A.appTypeId NOT IN (24, 25, 40, 47, 48, 50, 65, 66, 67, 68, 73, 75, 76) OR A.subclientStatus&8 = 0)
        AND (A.subclientStatus & (2|4|8|16|32|64|128|4096)) IN (0, 8, 64, 128, 4096)
        AND A.id NOT IN (SELECT appId FROM @ExcludedAppIds)
END
ELSE
BEGIN    
	INSERT INTO #subclients
	SELECT  A.clientId,A.appTypeID,A.instance , A.backupSet,A.id,A.subclientNAme,
	CAST(ISNULL(SCP.attrVal, '0') AS INT) AS 'subclientPolicyAppId'   
	FROM
        App_Application A With (nolock)
      LEFT OUTER JOIN APP_SubClientProp SCP With (nolock) ON SCP.componentNameId = A.id 
              AND SCP.attrName = 'Associated subclient Policy' AND SCP.modified = 0
	WHERE 
        A.appTypeId < 600 AND A.appTypeId NOT IN (72, 84, 85, 107, 121, 122, 127) 
	AND (A.appTypeId NOT IN (24, 25, 40, 47, 48, 50, 65, 66, 67, 68, 73, 75, 76) OR A.subclientStatus&8 = 0)
        AND (A.subclientStatus & (2|4|8|16|32|64|128|4096)) IN (0, 8, 64, 128, 4096)
        AND A.id NOT IN (SELECT appId FROM @ExcludedAppIds)
END        
IF  object_id('tempdb.dbo.#NextSubclientBackupJobs') is not null
	DROP TABLE #NextSubclientBackupJobs

CREATE TABLE #NextSubclientBackupJobs
(
clientId INT,
appTypeId INT,
instanceId INT,
backupsetId INT,
appId INT,
 taskId INT,
 subTaskId INT,
 
 nextRunTime				DATETIME

)
INSERT INTO #NextSubclientBackupJobs
SELECT
    sc.ClientId , sc.appTypeId, sc.instanceId , sc.backupsetId , sc.AppId, bs.taskId , bs.subTaskId , bs.nextRunTime 
FROM
  #subclients sc
  INNER JOIN #NextbackupSchedule AS bs WITH (NOLOCK)
        on bs.ClientGroupId = 0
        AND (bs.ClientId > 0 OR bs.AssocType = 3)
        AND bs.ClientId IN (sc.ClientId, 0)
        AND bs.AppTypeId IN (sc.AppTypeId, 0)
        AND bs.InstanceId IN (sc.InstanceId, 0)
        AND bs.BackupsetId IN (sc.BackupsetId, 0)
        AND bs.AppId IN (sc.AppId, sc.SubclientPolicyAppId, 0)
        
UNION
SELECT
     sc.ClientId , sc.appTypeId, sc.instanceId , sc.backupsetId , sc.AppId, bs.taskId , bs.subTaskId , bs.nextRunTime   
FROM
  #subclients sc
  INNER JOIN #NextbackupSchedule AS bs WITH (NOLOCK)
        on bs.ClientGroupId > 0
        AND (bs.ClientId > 0 OR bs.AssocType = 3)
        AND bs.ClientId IN (sc.ClientId, 0)
        AND bs.AppTypeId IN (sc.AppTypeId, 0)
        AND bs.InstanceId IN (sc.InstanceId, 0)
        AND bs.BackupsetId IN (sc.BackupsetId, 0)
        AND bs.AppId IN (sc.AppId, sc.SubclientPolicyAppId, 0)
        
UNION
SELECT 
     sc.ClientId , sc.appTypeId, sc.instanceId , sc.backupsetId , sc.AppId, bs.taskId , bs.subTaskId , bs.nextRunTime 
FROM
  #subclients sc
  INNER JOIN #NextbackupSchedule AS bs WITH (NOLOCK)
  ON   
         bs.ClientGroupId > 0 AND bs.ClientId = 0
        AND bs.AppTypeId IN (sc.AppTypeId, 0)
    INNER JOIN APP_ClientGroupAssoc AS cga WITH (NOLOCK)
        on sc.ClientId = cga.ClientId AND bs.ClientGroupId = cga.ClientGroupId
ORDER BY  sc.AppId 
--select * from #NextSubclientBackupJobs order by nextRunTime asc
 
DECLARE @NextDaySchStatsData TABLE (DateStartVal DATETIME,DateEndVal DATETIME, jobs BIGINT)

INSERT INTO @NextDaySchStatsData
SELECT @startdate , @enddate , COUNT(*) as '@jobs'
          FROM  #NextSubclientBackupJobs  HJ
          where HJ.nextRunTime  >= @startdate AND HJ.nextRunTime  < @enddate    
         

--select * from @NextDaySchStatsData
DECLARE @DaySchStats XML
SET  @DaySchStats = (select  DateStartVal  as '@DateStartVal',DateEndVal AS '@DateEndVal',
          jobs as '@jobs' FROM @NextDaySchStatsData
          
FOR XML PATH ('DaySchStats'))

DROP TABLE #BackupTask
DROP TABLE #subclients
DROP TABLE #NextbackupSchedule
DROP TABLE #TaskAssoc
DROP TABLE #NextSubclientBackupJobs

IF (@LastSchStats IS NULL )
BEGIN
	SET @LastSchStats = (SELECT @DaySchStats FOR XML PATH('LastSchStatsXML' ))
END

DECLARE @nreleaseId INT =1
SET @nreleaseId =(SELECT releaseId from APP_Client WITH (NOLOCK) where id =2)

END

IF (@LastSchStats IS NOT NULL )
BEGIN

	IF  object_id('tempdb.dbo.#LastSchStatsData') is not null
		DROP TABLE #LastSchStatsData
		SELECT
		csInfo.n.value('@DateStartVal', 'DATETIME') AS DateStartVal,
		csInfo.n.value('@DateEndVal', 'DATETIME') AS DateEndVal,
		csInfo.n.value('@jobs', 'BIGINT') AS jobs
		INTO #LastSchStatsData
	FROM
	@LastSchStats.nodes('/LastSchStatsXML/DaySchStats') AS csInfo(n)
	
	
	IF NOT EXISTS(SELECT * FROM #LastSchStatsData WHERE DateEndVal =@enddate)
	INSERT INTO #LastSchStatsData
			SELECT 	B.DateStartVal,
					B.DateEndVal,
					B.jobs
				FROM @NextDaySchStatsData AS B
	ELSE 
	UPDATE #LastSchStatsData
	SET jobs = B.jobs
	FROM @NextDaySchStatsData AS B
	WHERE B.DateEndVal =#LastSchStatsData.DateEndVal
	AND B.DateStartVal = #LastSchStatsData.DateStartVal
	SET @LastSchStats = (
			SELECT TOP(7) DateStartVal  as '@DateStartVal',DateEndVal AS '@DateEndVal', jobs as '@jobs' FROM #LastSchStatsData
			ORDER BY DateStartVal DESC
			FOR XML PATH ('DaySchStats'))
	  SET @LastSchStats = (SELECT @LastSchStats FOR XML PATH('LastSchStatsXML' ))			
END


IF(@nreleaseId = 15 )
BEGIN
	DECLARE @nstring NVARCHAR(MAX)
	IF (@found=0)
	BEGIN
		
		SET @nstring ='INSERT INTO GXGlobalParam (name,value,created, modified)
		SELECT ''CommservSurveyDaySchStats'','''', dbo.GetUnixTime(getutcdate()),0'
		EXEC sp_executesql @nstring

	END
		UPDATE  GXGlobalParam
		SET value = CAST(@LastSchStats AS NVARCHAR(MAX))
		WHERE name='CommservSurveyDaySchStats'
END
ELSE IF (@nreleaseId = 14 )
BEGIN
IF (@found=0)
	 INSERT INTO GXGlobalParam (name,value)
 	 SELECT 'CommservSurveyDaySchStats',CAST(@LastSchStats AS NVARCHAR(MAX))
ELSE
 	 UPDATE  GXGlobalParam
	 SET value = CAST(@LastSchStats AS NVARCHAR(MAX))
WHERE name='CommservSurveyDaySchStats'

END
 

--Name:- Back Up Job Statistics
--a) collects Yesterday's jobs data
 
--Description:- 

--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------
SET NOCOUNT ON

--------- Insert your SQL statements here 


-- Check if any special group to consider for data collection.
-- Get the list of client group ids if exists

DECLARE @hourlyJobsInfo table
(
	servStartDate DATETIME,
	hour INT,
	initFrom INT,
	TotalSchJobs INT,
	CJobs INT,
	CWEJobs INT,
	CWWJobs INT,
	FJobs INT,
	KJobs INT,
	AJobs INT,
	QJobs INT

)


DECLARE @hourlyCompletedJobs table
(
	servStartDate DATETIME,
	hour INT,
	initFrom INT,
	CJobs BIGINT,
	CWEJobs BIGINT,
	CWWJobs BIGINT,
	FJobs BIGINT,
	KJobs BIGINT

)
DECLARE @hourlyRunningJobs table
(
	servStartDate DATETIME,
	hour INT,
	initFrom INT,
	AJobs BIGINT, 
	QJobs BIGINT

)

IF (@specialGroupExists = 0)
BEGIN
	INSERT INTO @hourlyCompletedJobs
	SELECT	H.DateVal,H.Hour,B.initFrom,
		SUM(CASE WHEN B.status IN (1) THEN 1 ELSE 0 END) AS CJobs,
		SUM(CASE WHEN B.status IN (3) THEN 1 ELSE 0 END) as CWEJobs,
		SUM(CASE WHEN B.status IN (14) THEN 1 ELSE 0 END) as CWWJobs,
		SUM(CASE WHEN B.status IN (2,9) THEN 1 ELSE 0 END) as FJobs,
		SUM(CASE WHEN B.status IN (4) THEN 1 ELSE 0 END) as KJobs

FROM	@HourTbl H 
		INNER JOIN JMBkpStats B WITH (NOLOCK)
			on B.servEndDate >= HourBegin AND B.servEndDate < HourEnd
			AND B.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
		INNER JOIN APP_Application A WITH (NOLOCK) ON B.appId= A.id
	WHERE A.id NOT IN (SELECT appId FROM @ExcludedAppIds)
	GROUP BY H.DateVal,H.Hour,B.initFrom
	
	INSERT INTO @hourlyRunningJobs
	SELECT	H.DateVal,H.Hour,B.initFrom,
	 	SUM(CASE WHEN B.STATE =1 THEN 1 ELSE 0 END) Ajobs,SUM(CASE WHEN B.STATE IN(15,16) THEN 1 ELSE 0 END) Qjobs
	FROM @HourTbl H 
	INNER JOIN JMJobInfo B 
	ON B.jobStartTime >= HourBegin AND B.jobStartTime<HourEnd
	INNER JOIN JMBkpJobInfo J ON J.jobId = B.jobId
	AND B.STATE in (1,15,16)
	AND B.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
		INNER JOIN APP_Application A WITH (NOLOCK) ON J.applicationId= A.id
	WHERE A.id NOT IN (SELECT appId FROM @ExcludedAppIds)
	GROUP BY B.initFrom,H.DateVal,H.Hour
END
ELSE
BEGIN
	INSERT INTO @hourlyCompletedJobs
	SELECT	H.DateVal,H.Hour, B.initFrom,
		SUM(CASE WHEN B.status IN (1) THEN 1 ELSE 0 END) AS CJobs,
		SUM(CASE WHEN B.status IN (3) THEN 1 ELSE 0 END) as CWEJobs,
		SUM(CASE WHEN B.status IN (14) THEN 1 ELSE 0 END) as CWWJobs,
		SUM(CASE WHEN B.status IN (2,9) THEN 1 ELSE 0 END) as FJobs,
		SUM(CASE WHEN B.status IN (4) THEN 1 ELSE 0 END) as KJobs
		
	FROM	@HourTbl H 
		INNER JOIN JMBkpStats B WITH (NOLOCK)
			on B.servEndDate >= HourBegin AND B.servEndDate < HourEnd
			AND B.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
		INNER JOIN APP_Application A WITH (NOLOCK) ON B.appId= A.id
		INNER JOIN @includeClients C ON C.clientId = A.clientId
	WHERE A.id NOT IN (SELECT appId FROM @ExcludedAppIds)
 	GROUP BY H.DateVal,H.Hour,B.initFrom

	INSERT INTO @hourlyRunningJobs
		SELECT	H.DateVal,H.Hour,B.initFrom,
	 		SUM(CASE WHEN B.STATE =1 THEN 1 ELSE 0 END) Ajobs,SUM(CASE WHEN B.STATE IN(15,16) THEN 1 ELSE 0 END) Qjobs
		FROM @HourTbl H 
		INNER JOIN JMJobInfo B 
		ON B.jobStartTime >= HourBegin AND B.jobStartTime<HourEnd
		INNER JOIN JMBkpJobInfo J ON J.jobId = B.jobId
		AND B.STATE in (1,15,16)
		AND B.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
			INNER JOIN APP_Application A WITH (NOLOCK) ON J.applicationId= A.id
			INNER JOIN @includeClients C ON C.clientId = A.clientId
		WHERE A.id NOT IN (SELECT appId FROM @ExcludedAppIds)
		GROUP BY B.initFrom,H.DateVal,H.Hour 	
	 
END

INSERT INTO @hourlyJobsInfo
SELECT	H.DateVal,H.Hour,ISNULL(H.initFrom,0),0,
		ISNULL(A.CJobs,0),
		ISNULL(A.CWEJobs,0),
		ISNULL(A.CWWJobs,0),
		ISNULL(A.FJobs,0),
		ISNULL(A.KJobs,0),
		ISNULL(A.AJobs,0),
		ISNULL(A.QJobs,0)
FROM @HourTbl H
LEFT OUTER JOIN
(SELECT ISNULL(C.servStartDate,r.servStartDate) AS servStartDate,
	   ISNULL(C.Hour,r.Hour) AS Hour, 
	   ISNULL(C.initFrom,R.initFrom) AS initFrom,
	   ISNULL(C.CJobs,0)   AS CJobs,
	   ISNULL(C.CWEJobs,0) AS CWEJobs,
	   ISNULL(C.CWWJobs,0) AS CWWJobs,
	   ISNULL(C.FJobs,0)   AS FJobs,
	   ISNULL(C.KJobs,0)   AS KJobs,
	   ISNULL(R.AJobs,0)   AS AJobs,
	   ISNULL(R.QJobs,0)   AS QJobs
FROM  @hourlyCompletedJobs C
Full  OUTER JOIN @hourlyRunningJobs R
ON R.hour = c.Hour AND R.servStartDate = c.servStartDate and C.initFrom = R.initFrom) A
ON H.Hour = A.Hour AND H.DateVal = A.servStartDate AND H.initFrom = A.initFrom

--inserting schedule information
INSERT INTO @hourlyJobsInfo
SELECT S.DateStartVal,-1,3,S.jobs,0,0,0,0,0,0,0

FROM #LastSchStatsData S
 WHERE DateEndVal =@enddate



DECLARE @hourlyJobstatsXML XML = (select dbo.getUnixtime(H.servStartDate ) as '@DateStartVal',
										H.hour AS '@hour',
          H.initFrom as '@InitFrom',
          H.TotalSchJobs as '@TotalSchJobs',
          H.CJobs       as   '@CompletedJobs',
          H.CWEJobs + H.CWWJobs as '@PartialJobs',
          H.FJobs as '@FailedJobs',
		  H.KJobs as '@KilledJobs',
          H.AJobs as '@ActiveJobs',
		  H.QJobs as '@QueuedJobs'

          FROM @hourlyJobsInfo H
          ORDER BY H.servStartDate,H.hour,H.initFrom 
FOR XML PATH ('DailyJobStats'))

SET @surveyXML =
(
SELECT    

@hourlyJobstatsXML
FOR XML PATH('DailyJobStatsXML' ) 



)
--select cast (@surveyXML as XML)
--------- END SURVEY QUERY ---------


--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------
DECLARE @EndTime AS BIGINT = dbo.GetUnixTime(GETUTCDATE())

SET NOCOUNT OFF
--------- END SURVEY QUERY ---------

SET @outputXML = 
(
	SELECT
		@queryId AS '@QueryId',
		@EndTime AS '@LogDate',
		(@EndTime - @LogDate) AS '@QueryRunningTime',
		@surveyXML
	FOR XML PATH('Rpt_CSSXMLDATA')
)
SET NOCOUNT OFF
--------- END - GENERATED CODE ---------

