--- Please follow the below comments to insert SQL statements.
-- Client version query
--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------

SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

DECLARE @LogDate AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @queryId AS INTEGER = 150
DECLARE @surveyXML NVARCHAR(MAX)

--------- BEGIN SURVEY QUERY ---------
IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[BLEntity]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN
SET @surveyXML = (SELECT
	-- Billing Entity
	(SELECT	EntityGUID AS '@GUID', 
			DisplayName AS '@Name', 
			Description AS '@Description', 
			ContactInfo AS '@ContactInfo', 
			ModifiedTime AS '@ModifiedTime'
	FROM	BLEntity
	WHERE	EntityID > 1
	FOR XML PATH('Entity'), TYPE),

	-- Billing Entity Member
	(SELECT	EntityGUID AS '@GUID', 
			ClientID AS '@ClientID', 
			AppTypeID AS '@AppTypeId', 
			InstanceID AS '@InstanceId', 
			BackupSetID AS '@BackupsetId',
			AppID AS '@AppID'
	FROM	BLEntityMembers M
			INNER JOIN BLEntity E ON M.EntityID = E.EntityID
	WHERE	E.EntityID > 1
	FOR XML PATH('Member'), TYPE)
	
FOR XML PATH ('BillingEntities')
)
END
ELSE
SET @surveyXML = '<BillingEntities />'

--------- END SURVEY QUERY ---------

--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------

DECLARE @EndTime AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
SET @outputXML = 
(
	SELECT
		@queryId AS '@QueryId',
		@EndTime AS '@LogDate',
		(@EndTime - @LogDate) AS '@QueryRunningTime',
		@surveyXML
	FOR XML PATH('Rpt_CSSXMLDATA')
)
SET NOCOUNT OFF

--------- END - GENERATED CODE ---------
