--Name:- Clients Statistics
--Description:- Total installed clients3, uninstalled clients, deconfigured clients, Laptop clients
--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

DECLARE @LogDate AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @queryId AS INTEGER = 8
DECLARE @surveyXML NVARCHAR(MAX)
--------- END - GENERATED CODE ---------

--------- BEGIN SURVEY QUERY ---------

--------- Insert your SQL statements here 

CREATE TABLE #uninst_table (clientid INTEGER PRIMARY KEY)
CREATE TABLE #deconf_table (clientid INTEGER PRIMARY KEY)
CREATE TABLE #deconf_uninst_table (clientid INTEGER PRIMARY KEY)
CREATE TABLE #inst_table (clientid INTEGER PRIMARY KEY)
CREATE TABLE #uninst_category_table (clientid INTEGER)

DECLARE @MiniSRMAgent INTEGER
DECLARE @VirtualServerDiscoveredClients INTEGER
DECLARE @ProxyforExchange INTEGER
DECLARE @DataClassificationInstalledonClient INTEGER
DECLARE @DB2DPF INTEGER
DECLARE @ORACLERac INTEGER
DECLARE @DAG INTEGER
DECLARE @EDCdiscoveredClient INTEGER
DECLARE @uninstalled INTEGER
DECLARE @installed INTEGER
DECLARE @deconfigure INTEGER
DECLARE @categorized INTEGER
DECLARE @NumLaptopClients	INTEGER
DECLARE @restoreonlyclients INTEGER
DECLARE @ActiveDiscoveredVMs INTEGER = 0


CREATE TABLE #ClientInstalledProp 
(
	id INT, name NVARCHAR(255), displayName NVARCHAR(255), description NVARCHAR(MAX), netHostName NVARCHAR(255), OSId INT,
	OSName NVARCHAR(255), hwId INT, hwName VARCHAR(255), licenses INT, bkpEnabled INT,
	rstEnabled INT, deleted INT, priority INT, clientFlag INT, isCommServer INT,
	encryption INT, rsaPubKey NVARCHAR(1024), rsaPriKeySF NVARCHAR(1024), releaseId INT, status INT,
	virtual INT, isLicensed INT, physClientId INT, physClientName NVARCHAR(1024), DCinstalled INT,
	contentIndexingEnabled INT, CIActivityEnabled INT, updateStatus INT, snapBackupsEnabled INT, snapBackupsMAInstalled INT,
	collectDelegateInfo INT, donotSingleInstance INT, noPhysMachPresent INT, proxyFSClientId INT, proxyFSClientName NVARCHAR(1024),
	evmgrcPort INT, miniSRM INT, virtualDiscovered INT, EDCDiscovered INT, specialStatusFlags INT, outlookAddin INT,
	commNetClientCount INT, clientVersion VARCHAR(255), releasedIDWhenClientWasInstalled INT, ArchiverEnabled INT, virtualEntityFlags INT,
	isAdvancedFSPackageInstalled INT, isRemoteCacheEnabled INT, isWebServerInstalled INT, cvdPort INT, dataSecurityEnabled INT,sharePointFarmClient INT,
	canSchedule integer,canClientGroup integer,canSubclientPolicy integer,canPseudoClientCreate integer,canAdmin integer,canLogMonitor integer,canAlert integer,
	canReport INT, SPVersionInfo VARCHAR(255), SPVersionAndPatchInfo VARCHAR(MAX), isIndexingV2 INT, isQsnapInstalled INT, isDescriptionInHTMLFormat INT , 
	refCopyClientType INT, isFileShareArchiverClientPackageInstalled INT, isAgentLicenseConsumed INT, clientType INT, clusterType INT, isIndexingV2NAS INT,
	isVirtualServerPresent INT, is1TouchClient INT, clientGuid VARCHAR(40), cloudStatus INT, nasOSType INT, nasCapabilities BIGINT, isExchangePackageInstalled INT,
	clientAppType INT, isIndexingV2VSA INT, retireClientPhase INT, agentList VARCHAR(MAX), indexingV2EnabledMask BIGINT
)

DECLARE @nstring NVARCHAR(MAX)
DECLARE	@csReleaseId INT = (SELECT releaseId FROM APP_Client WITH(NOLOCK) WHERE id = 2)

DECLARE @SpRevision NVARCHAR(20) = ''
SELECT	@SpRevision = revision FROM GxDBVersions WITH(NOLOCK) where name = 'getClientListAndInitialProps'

DECLARE	@n INT = 1, @p INT = 1, @q INT = 1
DECLARE @r VARCHAR(20) = '', @s VARCHAR(20) = ''

IF @SpRevision LIKE 'v%'
BEGIN
	SET @SpRevision = @SpRevision+'.'
	SET @q = CHARINDEX('.', @SpRevision, @p+1)
	WHILE @q > 0
	BEGIN
		SET @s = SUBSTRING(@SpRevision, @p+1, @q-@p-1)
		IF  @n <= 4
			SET @r += (CASE @q-@p-1 WHEN 1 THEN '000' WHEN 2 THEN '00' WHEN 3 THEN '0' ELSE '' END + @s)
		ELSE
			SET @r += (CASE @q-@p-1 WHEN 1 THEN '0' ELSE '' END + @s)
		
		SET @n += 1
		SET @p = @q
		SET @q = CHARINDEX('.', @SpRevision, @p+1)
	END
	SET @SpRevision = @r
END

IF	ISNUMERIC(@SpRevision) = 0
	SET @SpRevision = '9223372036854775807'
	
DECLARE @SpVersion BIGINT = CAST(@SpRevision AS BIGINT)

IF	@csReleaseId < 15
BEGIN
	ALTER TABLE #ClientInstalledProp DROP COLUMN isAdvancedFSPackageInstalled
	ALTER TABLE #ClientInstalledProp DROP COLUMN isRemoteCacheEnabled
	ALTER TABLE #ClientInstalledProp DROP COLUMN isWebServerInstalled
	ALTER TABLE #ClientInstalledProp DROP COLUMN dataSecurityEnabled
	ALTER TABLE #ClientInstalledProp DROP COLUMN SPVersionInfo
	ALTER TABLE #ClientInstalledProp DROP COLUMN SPVersionAndPatchInfo

	ALTER TABLE #ClientInstalledProp DROP COLUMN canSchedule
	ALTER TABLE #ClientInstalledProp DROP COLUMN canClientGroup
	ALTER TABLE #ClientInstalledProp DROP COLUMN canSubclientPolicy
	ALTER TABLE #ClientInstalledProp DROP COLUMN canPseudoClientCreate
	ALTER TABLE #ClientInstalledProp DROP COLUMN canAdmin
	ALTER TABLE #ClientInstalledProp DROP COLUMN canLogMonitor	
	ALTER TABLE #ClientInstalledProp DROP COLUMN sharePointFarmClient	
	ALTER TABLE #ClientInstalledProp DROP COLUMN canAlert
	ALTER TABLE #ClientInstalledProp DROP COLUMN displayName	
	ALTER TABLE #ClientInstalledProp DROP COLUMN isIndexingV2
	ALTER TABLE #ClientInstalledProp DROP COLUMN isQsnapInstalled
	ALTER TABLE #ClientInstalledProp DROP COLUMN canReport
	ALTER TABLE #ClientInstalledProp DROP COLUMN isDescriptionInHTMLFormat
	ALTER TABLE #ClientInstalledProp DROP COLUMN refCopyClientType
	ALTER TABLE #ClientInstalledProp DROP COLUMN isFileShareArchiverClientPackageInstalled
	ALTER TABLE #ClientInstalledProp DROP COLUMN isAgentLicenseConsumed
	ALTER TABLE #ClientInstalledProp DROP COLUMN clientType
	ALTER TABLE #ClientInstalledProp DROP COLUMN clusterType
	ALTER TABLE #ClientInstalledProp DROP COLUMN isIndexingV2NAS
	ALTER TABLE #ClientInstalledProp DROP COLUMN isVirtualServerPresent
	ALTER TABLE #ClientInstalledProp DROP COLUMN is1TouchClient
	ALTER TABLE #ClientInstalledProp DROP COLUMN clientGuid
	ALTER TABLE #ClientInstalledProp DROP COLUMN cloudStatus
	ALTER TABLE #ClientInstalledProp DROP COLUMN nasOSType
	ALTER TABLE #ClientInstalledProp DROP COLUMN nasCapabilities
	ALTER TABLE #ClientInstalledProp DROP COLUMN isExchangePackageInstalled
	ALTER TABLE #ClientInstalledProp DROP COLUMN clientAppType
	ALTER TABLE #ClientInstalledProp DROP COLUMN isIndexingV2VSA
	ALTER TABLE #ClientInstalledProp DROP COLUMN retireClientPhase
	ALTER TABLE #ClientInstalledProp DROP COLUMN agentList
	ALTER TABLE #ClientInstalledProp DROP COLUMN indexingV2EnabledMask

	IF @SpVersion < 00010075002600060000 -- Below 9.0 SP8
		ALTER TABLE #ClientInstalledProp DROP COLUMN cvdPort

	IF @SpVersion < 00010075002600030000 -- Below 9.0 SP3 (REL_9_0_0_B92_VMPROV)
		ALTER TABLE #ClientInstalledProp DROP COLUMN virtualEntityFlags
END
ELSE IF	@csReleaseId = 15
BEGIN
	ALTER TABLE #ClientInstalledProp DROP COLUMN sharePointFarmClient	
	ALTER TABLE #ClientInstalledProp DROP COLUMN canAlert
	ALTER TABLE #ClientInstalledProp DROP COLUMN displayName
	ALTER TABLE #ClientInstalledProp DROP COLUMN isIndexingV2
	ALTER TABLE #ClientInstalledProp DROP COLUMN isQsnapInstalled
	ALTER TABLE #ClientInstalledProp DROP COLUMN canReport
	ALTER TABLE #ClientInstalledProp DROP COLUMN isDescriptionInHTMLFormat
	ALTER TABLE #ClientInstalledProp DROP COLUMN refCopyClientType
	ALTER TABLE #ClientInstalledProp DROP COLUMN isFileShareArchiverClientPackageInstalled
	ALTER TABLE #ClientInstalledProp DROP COLUMN isAgentLicenseConsumed
	ALTER TABLE #ClientInstalledProp DROP COLUMN clientType
	ALTER TABLE #ClientInstalledProp DROP COLUMN clusterType
	ALTER TABLE #ClientInstalledProp DROP COLUMN isIndexingV2NAS
	ALTER TABLE #ClientInstalledProp DROP COLUMN isVirtualServerPresent
	ALTER TABLE #ClientInstalledProp DROP COLUMN is1TouchClient
	ALTER TABLE #ClientInstalledProp DROP COLUMN clientGuid
	ALTER TABLE #ClientInstalledProp DROP COLUMN cloudStatus
	ALTER TABLE #ClientInstalledProp DROP COLUMN nasOSType
	ALTER TABLE #ClientInstalledProp DROP COLUMN nasCapabilities
	ALTER TABLE #ClientInstalledProp DROP COLUMN isExchangePackageInstalled
	ALTER TABLE #ClientInstalledProp DROP COLUMN clientAppType
	ALTER TABLE #ClientInstalledProp DROP COLUMN isIndexingV2VSA
	ALTER TABLE #ClientInstalledProp DROP COLUMN retireClientPhase
	ALTER TABLE #ClientInstalledProp DROP COLUMN agentList
	ALTER TABLE #ClientInstalledProp DROP COLUMN indexingV2EnabledMask

	IF @SpVersion < 10092000400110000 -- Below 10.0 SP7a
	BEGIN
		ALTER TABLE #ClientInstalledProp DROP COLUMN canSchedule
		ALTER TABLE #ClientInstalledProp DROP COLUMN canClientGroup
		ALTER TABLE #ClientInstalledProp DROP COLUMN canSubclientPolicy
		ALTER TABLE #ClientInstalledProp DROP COLUMN canPseudoClientCreate
		ALTER TABLE #ClientInstalledProp DROP COLUMN canAdmin
		ALTER TABLE #ClientInstalledProp DROP COLUMN canLogMonitor		

		IF @SpVersion < 10092000400080000 -- Below 10.0 SP5a
			ALTER TABLE #ClientInstalledProp DROP COLUMN dataSecurityEnabled
	END
END
ELSE IF	@csReleaseId = 16
BEGIN
	IF @SpVersion < 10121000200090000 -- Below 11.0 SP4a
		ALTER TABLE #ClientInstalledProp DROP COLUMN clientType

	IF @SpVersion <= 10121000200120000 -- 11.0 SP5
		ALTER TABLE #ClientInstalledProp DROP COLUMN clusterType

	IF @SpVersion < 10121000200150000 -- 11.0 SP6
		ALTER TABLE #ClientInstalledProp DROP COLUMN isIndexingV2NAS

	IF @SpVersion < 10121000200170000 -- 11.0 SP7
	BEGIN
		ALTER TABLE #ClientInstalledProp DROP COLUMN isVirtualServerPresent
		ALTER TABLE #ClientInstalledProp DROP COLUMN is1TouchClient
	END

	IF @SpVersion < 10121000200240000 -- 11.0 SP9
		ALTER TABLE #ClientInstalledProp DROP COLUMN clientGuid
	
	IF  @SpVersion < 10121000200240201  --11.0 SP9 HF
		ALTER TABLE #ClientInstalledProp DROP COLUMN cloudStatus

	IF  @SpVersion < 10121000200280202  --11.0 SP11 HF
	BEGIN
		ALTER TABLE #ClientInstalledProp DROP COLUMN nasOSType
		ALTER TABLE #ClientInstalledProp DROP COLUMN nasCapabilities
	END

	IF  @SpVersion < 10121000200330201  --11.0 SP12 HF
		ALTER TABLE #ClientInstalledProp DROP COLUMN isExchangePackageInstalled

	IF  @SpVersion < 10121000200430000 -- 11.0 SP13
		ALTER TABLE #ClientInstalledProp DROP COLUMN clientAppType

	IF  @SpVersion < 10121000200560000 -- 11.0 SP16
		ALTER TABLE #ClientInstalledProp DROP COLUMN isIndexingV2VSA

	IF  @SpVersion < 10121000200610000 -- 11.0 SP21
		ALTER TABLE #ClientInstalledProp DROP COLUMN retireClientPhase
		
	IF  @SpVersion < 10121000200620000 -- 11.0 SP21
		ALTER TABLE #ClientInstalledProp DROP COLUMN agentList	
		
	IF  @SpVersion < 10121000200630000 -- 11.0 SP22
		ALTER TABLE #ClientInstalledProp DROP COLUMN indexingV2EnabledMask
		
END

-- getClientListAndInitialProps procedure is used for displaying clients in CommCell GUI
INSERT INTO #ClientInstalledProp
EXEC getClientListAndInitialProps 0, 1, 1


INSERT INTO #deconf_uninst_table 
SELECT id FROM #ClientInstalledProp WHERE ISNULL(deleted, 0) <> 0
--#deconf_uninst_table include both deconfigured and uninstalled client

INSERT INTO #uninst_table
SELECT clientid FROM #deconf_uninst_table
EXCEPT 
SELECT DISTINCT(ClientId) FROM simInstalledPackages WITH (NOLOCK)

INSERT INTO #deconf_table
SELECT clientid FROM #deconf_uninst_table
EXCEPT 
SELECT clientid FROM #uninst_table

INSERT INTO #inst_table 
SELECT id FROM #ClientInstalledProp WHERE ISNULL(deleted, 0) = 0 AND ISNULL(virtualDiscovered, 0) = 0

-- All the below clients are categorised under uninstalled clients
-- Clients Discovered by Standalone SRM Agent, Virtual Server Discovered clients, Exchange Proxy Clients, Data Classification clients, Exchange DAG,
--  DB2 DPF clients, Oracle RAC clients and EDC discovered clients

SELECT	@MiniSRMAgent = SUM(ISNULL(miniSRM, 0)),
		@VirtualServerDiscoveredClients = SUM(ISNULL(virtualDiscovered, 0)),
		@EDCdiscoveredClient = SUM(ISNULL(EDCDiscovered, 0)),
		@DataClassificationInstalledonClient = SUM(ISNULL(DCinstalled, 0))
FROM	#ClientInstalledProp

SELECT	@ProxyforExchange = COUNT(*)
FROM	#uninst_table JOIN APP_ClientProp WITH (NOLOCK) ON clientid = componentNameId 
WHERE	attrName = 'Proxy for Exchange' AND modified = 0

DECLARE @flags INT = CAST(0x200000 AS INT)|CAST(0x0040 AS INT)|CAST(0x0200 AS INT)

SELECT	@DAG = SUM(CASE WHEN (status & 0x200000) = 0 THEN 0 ELSE 1 END),
		@DB2DPF = SUM(CASE WHEN (status & 0x0040) = 0 THEN 0 ELSE 1 END),
		@ORACLERac = SUM(CASE WHEN (status & 0x0200) = 0 THEN 0 ELSE 1 END)
FROM	#uninst_table JOIN APP_Client WITH (NOLOCK) ON clientid = id 
WHERE	(status & @flags) > 0


INSERT INTO #uninst_category_table
SELECT clientid 
FROM #uninst_table 
	JOIN APP_ClientProp WITH (NOLOCK) ON clientid=componentNameId 
WHERE ((attrName = 'Mini SRM Agent') 
	OR (attrName = 'Virtual Server Discovered Clients') 
	OR (attrName = 'Proxy for Exchange') 
	OR (attrname = 'Data Classification Installed on Client')) AND modified=0

INSERT INTO #uninst_category_table
SELECT clientid 
FROM #uninst_table JOIN APP_Client WITH (NOLOCK) ON clientid=id 
WHERE ((status & 0x200000) = 0x200000) OR ((status & 0x0040) = 0x0040 ) OR ((status & 0x0200) = 0x0200)

INSERT INTO #uninst_category_table
SELECT DISTINCT(UIN.clientid) 
FROM #uninst_table UIN 
	JOIN app_clientGroupAssoc CGA WITH (NOLOCK) ON UIN.clientid=CGA.clientId
	JOIN APP_ClientGroup CG WITH (NOLOCK) ON CG.id = CGA.clientGroupId   
WHERE ((CG.flag & 0x100 = 0x100) OR (CG.flag & 0x200 = 0x200))


SET @categorized= (SELECT COUNT( DISTINCT(clientid)) FROM #uninst_category_table)
SET @deconfigure= (SELECT COUNT(*) FROM #deconf_table)
SET @installed=(SELECT COUNT(*) FROM #inst_table)
SET @uninstalled=(SELECT COUNT(*) FROM #uninst_table)

SET @restoreonlyclients=(
	SELECT COUNT(clientid) 
	FROM #deconf_table JOIN APP_Client WITH (NOLOCK) ON id=clientid 
	WHERE (specialClientFlags & 0x2) <> 0x2 
	)

-- Laptop clients status CV_STATUS_PERSONAL_WKSTN = 0x1000
SET @NumLaptopClients = (
	select COUNT(*) 
	from #ClientInstalledProp 
	where (status & 0x1000) > 0 AND ISNULL(deleted, 0) = 0 AND ISNULL(virtualDiscovered, 0) = 0
	)

IF @csReleaseId >= 15
BEGIN
	CREATE TABLE #tempVMs (VMClientId INT, Deconfigured INT)

	SET @nstring = N'
	INSERT INTO #tempVMs
	SELECT	DISTINCT C.id, CASE WHEN T.componentNameId IS NOT NULL OR J.clientId IS NULL THEN 1 ELSE 0 END
	FROM	APP_Client C WITH (NOLOCK)
		INNER JOIN APP_ClientProp CP WITH (NOLOCK) ON C.id = CP.componentNameId
		AND	CP.attrName = ''Virtual Server Discovered Clients'' AND CP.attrVal = ''1'' AND CP.modified =0
		LEFT OUTER JOIN (
		SELECT	DISTINCT componentNameId
		FROM	APP_ClientProp WITH (NOLOCK)
		WHERE	attrName = ''Virtual Machine Deletion Time'' AND ISNULL(attrVal, ''0'') <> ''0'' AND modified = 0
		) T ON C.id = T.componentNameId
		LEFT OUTER JOIN (
		SELECT	DISTINCT Q.clientId
		FROM	JMQinetixUpdateStatus Q WITH (NOLOCK)
				INNER JOIN JMBkpStats B WITH (NOLOCK) ON B.jobId = Q.jobId AND B.commCellId = Q.commCellId
					AND B.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101) AND B.bkpLevel IN (1, 2, 4, 256, 1024, 32768) 
		) J ON C.id = J.clientId'

	EXEC sp_executesql @nstring

	SET @VirtualServerDiscoveredClients = (SELECT COUNT(*) FROM #tempVMs)
	SET @ActiveDiscoveredVMs = (SELECT COUNT(*) FROM #tempVMs WHERE Deconfigured = 0)

	DELETE C FROM #ClientInstalledProp C INNER JOIN #tempVMs V ON C.id = V.VMClientId AND V.Deconfigured = 0
	SET @installed = (SELECT COUNT(*) FROM #ClientInstalledProp WHERE ISNULL(deleted, 0) = 0 AND (specialStatusFlags & 0x2) = 0)
	SET @NumLaptopClients = (SELECT COUNT(*) FROM #ClientInstalledProp WHERE (status & 0x1000) > 0 AND ISNULL(deleted, 0) = 0 AND (specialStatusFlags & 0x2) = 0)

	DROP TABLE #tempVMs
END
ELSE
	SET @ActiveDiscoveredVMs = @VirtualServerDiscoveredClients


SET @surveyXML = (
	SELECT	ISNULL((@uninstalled+@installed+@deconfigure), 0) AS '@total',
			ISNULL(@installed, 0) + ISNULL(@ActiveDiscoveredVMs, 0) AS 'INSTALLED/@totalClients', 
			ISNULL(@deconfigure, 0) AS 'DECONFIGURED/@totalclient',
			ISNULL(@restoreonlyclients, 0) AS 'DECONFIGURED/@restoreonlyclients', 
			ISNULL(@uninstalled, 0) AS 'UNINSTALLED/@totalclient', 
			ISNULL(@MiniSRMAgent, 0) AS 'UNINSTALLED/@MiniSRMAgent',
			ISNULL(@VirtualServerDiscoveredClients, 0) AS 'UNINSTALLED/@VirtualServerDiscoveredClients',
			ISNULL(@ActiveDiscoveredVMs, 0) AS 'UNINSTALLED/@ActiveDiscoveredVMs',
			ISNULL(@ProxyforExchange, 0) AS 'UNINSTALLED/@ProxyforExchange', 
			ISNULL(@DataClassificationInstalledonClient, 0) AS 'UNINSTALLED/@DataClassificationInstalledonClient', 
			ISNULL(@DB2DPF, 0) AS 'UNINSTALLED/@DB2DPF', 
			ISNULL(@ORACLERac, 0) AS 'UNINSTALLED/@ORACLERac', 
			ISNULL(@DAG, 0) AS 'UNINSTALLED/@DAG', 
			ISNULL(@EDCdiscoveredClient, 0) AS 'UNINSTALLED/@EDCdiscoveredClient',
			ISNULL((@uninstalled-@categorized), 0) AS 'UNINSTALLED/@others',
			ISNULL(@NumLaptopClients, 0) AS 'LAPTOPCLIENTS/@totalclients'
	FOR XML PATH('CLIENTS')
)
 
DROP TABLE #ClientInstalledProp
DROP TABLE #uninst_table
DROP TABLE #deconf_table
DROP TABLE #deconf_uninst_table
DROP TABLE #inst_table
DROP TABLE #uninst_category_table
--------- END SURVEY QUERY ---------

--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------

DECLARE @EndTime AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
SET @outputXML = 
(
	SELECT
		@queryId AS '@QueryId',
		@EndTime AS '@LogDate',
		(@EndTime - @LogDate) AS '@QueryRunningTime',
		@surveyXML
	FOR XML PATH('Rpt_CSSXMLDATA')
)

SET NOCOUNT OFF

--------- END - GENERATED CODE ---------


