SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

DECLARE @LogDate AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @queryId AS INTEGER = 255


--------- END - GENERATED CODE ---------

--------- BEGIN SURVEY QUERY ---------

DECLARE @surveyXML NVARCHAR(MAX)
SET @surveyXML = (SELECT 
				C.id AS '@ClientId',
				A.simPackageID AS '@PackageID'
				FROM	APP_Client C
				inner join simInstalledPackages as A
				on A.ClientId = C.id and A.simPackageID = 1176
				FOR XML PATH('hedvigRecord'), ROOT('HedvigNodes'))

--------- END SURVEY QUERY ---------

--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------

DECLARE @EndTime AS BIGINT = dbo.GetUnixTime(GETUTCDATE())

SET @outputXML = 
(
	SELECT
		@queryId AS '@QueryId',
		@EndTime AS '@LogDate',
		(@EndTime - @LogDate) AS '@QueryRunningTime',
		@surveyXML
	FOR XML PATH('Rpt_CSSXMLDATA')
)

SET NOCOUNT OFF
