--@querytype 	CSV
--Name:- Client Group Association

--------- BEGIN SURVEY QUERY ---------
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

DECLARE	@csReleaseId INT = 0
SELECT	@csReleaseId = releaseId FROM APP_Client WHERE id = 2

DECLARE @csSPVersion INT = 0
IF @csReleaseId = 15
	SELECT	@csSPVersion = ISNULL(MAX(HighestSP), 0) FROM simInstalledPackages WHERE ClientId = 2

IF @csReleaseId < 15 OR @csReleaseId = 15 AND @csSPVersion < 7
BEGIN
	RETURN -- Use Query 151
END

DECLARE @collectClientGroupAssociations INT = 0
DECLARE @isPrivateRunning varchar(256) = '';

IF EXISTS(SELECT name FROM GXGlobalParam WHERE name = 'CommservSurveyRunning')
BEGIN
    SELECT @isPrivateRunning = value from GXGlobalParam where name ='CommservSurveyRunning'
END

IF OBJECT_ID('CloudMonitoringService') IS NOT NULL
BEGIN
	IF (@isPrivateRunning IN ('Metrics Reporting', 'Metrics Direct Dip'))
	BEGIN
		select @collectClientGroupAssociations = 1
	END
	ELSE
	IF EXISTS (select * from CloudMonitoringService where name IN ('Activity', 'ChargeBack', 'HealthCheck') and isEnabled&1 = 1)
	BEGIN
		select @collectClientGroupAssociations = 1
	END
END
	
IF(@collectClientGroupAssociations > 0)
BEGIN
	SELECT ClientGroupId, clientId
	FROM APP_ClientGroupAssoc
END

--------- END SURVEY QUERY ---------
SET NOCOUNT OFF
