--@querytype    CSV
--Name:- License Info
--Description:- Collects details of licenses purchased and used 

SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

BEGIN TRY
        
	DECLARE @LogDate AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
	DECLARE @queryId AS INTEGER = 232

	DECLARE @TIME_STAMP_NAME NVARCHAR(512) = 'SQLQuery232_LastCollectionTime'
	DECLARE @isPrivateRunning VARCHAR(256)='';
	DECLARE @frequencyMode   NVARCHAR(MAX) ='0';
	DECLARE @isActivityEnabled INT = 0;
	DECLARE @sqlQuery NVARCHAR(MAX) = '';

	IF EXISTS(SELECT 1 FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#MetricsInputParams'))
		SELECT @frequencyMode = mode FROM #MetricsInputParams

	IF EXISTS(SELECT name FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'CommservSurveyRunning')
		SELECT @isPrivateRunning = value FROM GXGlobalParam WITH (NOLOCK) WHERE name ='CommservSurveyRunning'

	IF OBJECT_ID('CloudMonitoringService') IS NOT NULL
	BEGIN
		IF (@isPrivateRunning = 'Metrics Reporting')
			SELECT @isActivityEnabled = (isEnabled & 2) FROM CloudMonitoringService WITH (NOLOCK) WHERE name = 'Activity'
		ELSE
			SELECT @isActivityEnabled = (isEnabled & 1) FROM CloudMonitoringService WITH (NOLOCK) WHERE name = 'Activity'
	END

	IF ((@isPrivateRunning = 'Metrics Reporting') OR (@frequencyMode = '1'))
		SET @TIME_STAMP_NAME = 'CommservSurveyPrivate_LicLicenseInfo_CollectionTime'
	ELSE
		SET @TIME_STAMP_NAME = 'CommservSurveyPublic_LicLicenseInfo_CollectionTime'

	--if gxGlobalParam is explicitly set to 0, do not collect anything (will act as back out mechanism in case, we want to stop collecting these usages)
	DECLARE @useNewLicCal INT = 1
	IF EXISTS(SELECT name FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'nUseNewLicCal')
		SELECT @useNewLicCal = CAST(CAST(value AS VARCHAR(32)) AS INT) FROM GXGlobalParam WITH (NOLOCK) WHERE name ='nUseNewLicCal'
	IF @useNewLicCal=0
		GOTO LIC_ERROR
	
	IF @isActivityEnabled=0
	BEGIN
		--upload summary of LicenseInfo from view Lic_LicenseInfoSummary_vw 
		SET @sqlQuery = N'
			SELECT DISTINCT 
			LicType AS ''LicType'', 
			ISNULL(PermTotal,0) AS ''PermTotal'', 
			ISNULL(PermUsed,0) AS ''PermUsed'', 
			ISNULL(EvalTotal,0) AS ''EvalTotal'', 
			ISNULL(EvalUsed,0) AS ''EvalUsed'', 
			ISNULL(TermDate,CONVERT(DATETIME, ''1970-01-01 00:00:00.000'')) AS ''TermDate'', 
			-1 AS ''ClientId'',
			-1 AS ''AppTypeId'', 
			CONVERT(DATETIME, ''1970-01-01 00:00:00.000'') AS ''InstallDate'', 
			ISNULL(ExpiryDate,CONVERT(DATETIME, ''1970-01-01 00:00:00.000'')) AS ''ExpiryDate''
            FROM 
		'
		IF (OBJECT_ID('CommServ.dbo.Lic_LicenseInfoSummary_vw') IS NOT NULL)--from SP17 this view is moved to CSDB
			SET @sqlQuery += N' CommServ.dbo.Lic_LicenseInfoSummary_vw'            		
		ELSE IF (OBJECT_ID('HistoryDB.dbo.Lic_LicenseInfoSummary_vw') IS NOT NULL)--if CS is below SP17, continue to collect usage using HistoryDB view
            SET @sqlQuery += N' HistoryDB.dbo.Lic_LicenseInfoSummary_vw'	
		ELSE
			GOTO LIC_ERROR
	END
	ELSE
	BEGIN
		--upload details of LicenseInfo from Lic_LicenseInfo table
		SET @sqlQuery = N'
			SELECT DISTINCT 
			LicType AS ''LicType'', 
			ISNULL(PermTotal,0) AS ''PermTotal'', 
			ISNULL(PermUsed,0) AS ''PermUsed'', 
			ISNULL(EvalTotal,0) AS ''EvalTotal'', 
			ISNULL(EvalUsed,0) AS ''EvalUsed'', 
			ISNULL(TermDate,CONVERT(DATETIME, ''1970-01-01 00:00:00.000'')) AS ''TermDate'', 
			ISNULL(ClientId,0) AS ''ClientId'',  
			AppTypeId AS ''AppTypeId'', 
			ISNULL(InstallDate,CONVERT(DATETIME, ''1970-01-01 00:00:00.000'')) AS ''InstallDate'', 
			ISNULL(ExpiryDate,CONVERT(DATETIME, ''1970-01-01 00:00:00.000'')) AS ''ExpiryDate''
            FROM
		'
		IF (OBJECT_ID('CommServ.dbo.Lic_LicenseInfo') IS NOT NULL)--from SP17 this table is moved to CSDB
			SET @sqlQuery += N' CommServ.dbo.Lic_LicenseInfo'            		
		ELSE IF (OBJECT_ID('HistoryDB.dbo.Lic_LicenseInfo') IS NOT NULL)--if CS is below SP17, continue to collect usage from HistoryDB
            SET @sqlQuery += N' HistoryDB.dbo.Lic_LicenseInfo'	
		ELSE
			GOTO LIC_ERROR		
	END   
	
	SET @sqlQuery += N' WITH(NOLOCK)'
	EXEC sp_executesql @sqlQuery	

	DECLARE @DO_IT VARCHAR(256)
	IF NOT EXISTS (SELECT 1 FROM GXGlobalParam WITH(NOLOCK) WHERE name = @TIME_STAMP_NAME)
	BEGIN
		IF EXISTS (SELECT 1 FROM APP_Client WITH(NOLOCK) WHERE id = 2 AND releaseId < 15)
			INSERT INTO GXGlobalParam (name, value) SELECT @TIME_STAMP_NAME, ''
		ELSE
		BEGIN
			SET @DO_IT = 'INSERT INTO GXGlobalParam (name, value, created, modified) VALUES('''
			 + @TIME_STAMP_NAME
			 + ''', '''','
			 + CONVERT(varchar(20), @logDate)                   -- Use Proper "create" date!
			 + ',0)'
			EXEC (@DO_IT)
		END
	END  	

END TRY
BEGIN CATCH  
  DECLARE @ErrorMessage NVARCHAR(4000);  
  SET @ErrorMessage = ERROR_MESSAGE();
  RAISERROR(@ErrorMessage,16,1);
RETURN
END CATCH   

UPDATE GXGlobalParam SET value = CAST(dbo.getunixtime(GETDATE()) AS NVARCHAR(20)) WHERE name = @TIME_STAMP_NAME

LIC_ERROR:

SET NOCOUNT OFF