
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

DECLARE @LogDate AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @queryId AS INTEGER = 224
DECLARE @surveyXML NVARCHAR(MAX)

--------- END - GENERATED CODE ---------


--------- BEGIN SURVEY QUERY ---------

if object_id('tempdb.dbo.#alertCriteriaTbl') is not null
              DROP TABLE #alertCriteriaTbl
              CREATE TABLE #alertCriteriaTbl (
                     alertId INT,
                     selCriteriaID INT,
                     criteriaName nvarchar(max)
              )

if object_id('tempdb.dbo.#alertQueryType') is not null DROP TABLE #alertQueryType
CREATE TABLE #alertQueryType (
        alertId INT,
        queryType INT,  
		queryName nvarchar(max)                   
)


INSERT INTO #alertCriteriaTbl(alertId,selCriteriaID,criteriaName)
SELECT NTnotificationRule.ID,NTSelCriteria.id,NTcriteria.name
FROM NTnotificationRule (NOLOCK)
INNER JOIN NTSelCriteria (NOLOCK) ON NTSelCriteria.ruleId = NTnotificationRule.id 
INNER JOIN NTcriteria (NOLOCK) ON NTSelCriteria.availCriteriaid = NTcriteria.id 
WHERE revision=1 ANd (status&2)=0

DECLARE @alertID INT
DECLARE @selCriteriaID INT
DECLARE @criteriaName NVARCHAR(MAX)
DECLARE @charStartIndex INT = 0
DECLARE @charEndIndex INT = 0
IF ( CURSOR_STATUS('global', 'alertCriteriaNameCursor') >= 0   OR CURSOR_STATUS('local', 'alertCriteriaNameCursor') >= 0 )  -- CLOSE CURSOR IF OPEN
              CLOSE alertCriteriaNameCursor
IF ( CURSOR_STATUS('global','alertCriteriaNameCursor') = -1     OR CURSOR_STATUS('local','alertCriteriaNameCursor') = -1 )
       DEALLOCATE alertCriteriaNameCursor
DECLARE alertCriteriaNameCursor CURSOR FOR
       SELECT  alertId, selCriteriaID, criteriaName
              FROM #alertCriteriaTbl
              WHERE criteriaName like '%<%' AND criteriaName like '%>%'
       OPEN alertCriteriaNameCursor
       FETCH NEXT FROM alertCriteriaNameCursor INTO @alertId,@selCriteriaID, @criteriaName
       WHILE @@FETCH_STATUS = 0
       BEGIN
              DECLARE @paramInd INT = 0
              DECLARE @paramVal Nvarchar(100) 
              SET @charStartIndex = charindex('<',@criteriaName)
              WHILE @charStartIndex>0
              BEGIN
                     SET @charEndIndex = charindex('>',@criteriaName)
                     SELECT @paramVal = NTSelcriteriaparams.value
                     FROM NTSelcriteriaparams 
                     WHERE NTSelcriteriaparams.selCriteriaid = @selCriteriaID AND NTSelCriteriaParams.paramIndex = @paramInd
                     SET @criteriaName = REPLACE(@criteriaName, Substring(@criteriaName,@charStartIndex, @charEndIndex-@charStartIndex+1), @paramVal)
                     SET @charStartIndex = charindex('<',@criteriaName)
                     SET @paramInd = @paramInd + 1
                     UPDATE #alertCriteriaTbl
                     SET criteriaName = @criteriaName
                     WHERE selCriteriaID = @selCriteriaID
              END
              FETCH NEXT FROM alertCriteriaNameCursor INTO @alertId,@selCriteriaID, @criteriaName
       END       

       IF ( CURSOR_STATUS('global', 'alertCriteriaNameCursor') >= 0   OR CURSOR_STATUS('local', 'alertCriteriaNameCursor') >= 0 )  -- CLOSE CURSOR IF OPEN
              CLOSE alertCriteriaNameCursor
       IF ( CURSOR_STATUS('global','alertCriteriaNameCursor') = -1     OR CURSOR_STATUS('local','alertCriteriaNameCursor') = -1 )
              DEALLOCATE alertCriteriaNameCursor

IF OBJECT_ID('NTNotificationQueryMapping', 'U') IS NOT NULL
INSERT INTO #alertQueryType
SELECT M.NtNotificationId, ISNULL(SQ.QueryType, 0), queryName
FROM NTNotificationQueryMapping M 
	INNER JOIN (SELECT Q.queryId, e.n.value('@queryType', 'INT') AS QueryType, queryName
				FROM (select queryId, queryName, 							 
							 CAST((CASE WHEN ISNULL(xmlInfo,'') = ''
										THEN '<App_AdditionalQueryDetails><externalQueryEntity queryType="0"/></App_AdditionalQueryDetails>'
									   ELSE xmlInfo
								 END) AS XML) AS xmlInfo 
					  FROM NTQueryList) Q
						   cross apply Q.xmlInfo.nodes('(App_AdditionalQueryDetails/externalQueryEntity)[1]') e(n)) SQ ON M.QueryId = SQ.queryId 


SET @surveyXML = (select notificationName AS '@notificationName',
					  NTcategory.name AS '@categoryName',
					  CASE WHEN NTAlertType.id = 65 
							THEN (CASE WHEN QT.queryType IN (2,4) THEN 'Metrics Alert'
									   WHEN QT.queryType = 3 THEN 'LM Alert'
									   ELSE queryName
								 END)
							ELSE NTAlertType.name END AS '@alertType',
					  notifType AS '@notificationType',
					  status AS '@status', 					  
					  (select CASE WHEN NTAlertType.id = 65 THEN '' ELSE NTSelCriteria.criteriaName END '@name' 
					  from #alertCriteriaTbl NTSelCriteria
					  where NTSelCriteria.alertId = NTNotificationrule.id for xml path('criteria'),root('criteria') ) AS '@notificationRule'
				from NTnotificationRule (NOLOCK)
					   inner join NTcategory (NOLOCK)
							  ON NTnotificationRule.categoryId = NTcategory.id 
					   inner join NTAlertType (NOLOCK)
							  on NTnotificationRule.alertTypeId = NTAlertType.id
					   left join #alertQueryType QT
							  ON NTNotificationrule.id = QT.alertId
				WHERE revision=1 ANd (status&2)=0
				FOR XML PATH('alert'), ROOT('alertsConfiguration'))


--------- END SURVEY QUERY ---------

--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------

DECLARE @EndTime AS BIGINT = dbo.GetUnixTime(GETUTCDATE())

--SELECT cast(@surveyXML as xml)
SET @outputXML = 
(
	SELECT
		@queryId AS '@QueryId',
		@EndTime AS '@LogDate',
		(@EndTime - @LogDate) AS '@QueryRunningTime',
		@surveyXML
	FOR XML PATH('Rpt_CSSXMLDATA')
)

SET NOCOUNT OFF