
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

DECLARE @LogDate AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @queryId AS INTEGER = 223
DECLARE @surveyXML NVARCHAR(MAX)

--------- END - GENERATED CODE ---------


--------- BEGIN SURVEY QUERY ---------

USE MSDB;

SET @surveyXML = (SELECT restore_date AS '@restore_date', 
						 destination_database_name AS '@destination_database_name', 
						 user_name AS '@user_name', 
						 restore_type AS '@restore_type', 
						 replace AS '@replace', 
						 recovery AS '@recovery'
				  FROM restorehistory 
				  WHERE destination_database_name = 'CommServ' AND restore_date > DATEADD(Year, -1, GETDATE())
				  FOR XML PATH('row'), ROOT('CommServDBRestores'))

USE CommServ;

--------- END SURVEY QUERY ---------

--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------

DECLARE @EndTime AS BIGINT = dbo.GetUnixTime(GETUTCDATE())

--SELECT cast(@surveyXML as xml)
SET @outputXML = 
(
	SELECT
		@queryId AS '@QueryId',
		@EndTime AS '@LogDate',
		(@EndTime - @LogDate) AS '@QueryRunningTime',
		@surveyXML
	FOR XML PATH('Rpt_CSSXMLDATA')
)

SET NOCOUNT OFF